/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.imt2020uplink.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.OptionalValue;
import org.seamcat.model.plugin.eventprocessing.LongTask;
import org.seamcat.model.plugin.system.CustomPanelBuilder;
import org.seamcat.model.plugin.system.ModelEditor;
import org.seamcat.model.plugin.system.PanelModelEditor;
import org.seamcat.model.systems.imt2020uplink.IMT2020UpLinkMicroSystemPlugin;
import org.seamcat.model.systems.imt2020uplink.simulation.CouplingLossEstimatorMicro;
import org.seamcat.model.systems.imt2020uplink.ui.SystemModelIMT2020UpLinkMicro;
import org.seamcat.model.systems.ofdmauplink.ui.OFDMAUpLinkUI;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.display.VectorDialog;
import org.seamcat.presentation.genericgui.LongTaskSwingExecutor;
import org.seamcat.presentation.genericgui.item.CalculatedValueItem;
import org.seamcat.presentation.genericgui.panelbuilder.GenericPanelEditor;

public class CouplingLossEstimationMicroUI
implements CustomPanelBuilder<OFDMAUpLinkUI, SystemModelIMT2020UpLinkMicro> {
    private static final DecimalFormat df = new DecimalFormat("#.###");
    private List<Double> samples = new ArrayList<Double>();

    @Override
    public PanelModelEditor<OFDMAUpLinkUI> build(OFDMAUpLinkUI model, final ModelEditor<SystemModelIMT2020UpLinkMicro> modelEditor) {
        final GenericPanelEditor<OFDMAUpLinkUI> editor = new GenericPanelEditor<OFDMAUpLinkUI>(MainWindow.getInstance(), OFDMAUpLinkUI.class, model);
        final CalculatedValueItem item = editor.getCalculatedValues().get(0);
        item.setPreviewText("CDF");
        item.getPreviewButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CouplingLossEstimationMicroUI.this.showCDF();
            }
        });
        item.getEvaluateButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LongTaskSwingExecutor.execute(new LongTask<Double>(){

                    @Override
                    public Double process() throws Exception {
                        CouplingLossEstimationMicroUI.this.samples.clear();
                        double frequency = ((SystemModelIMT2020UpLinkMicro)modelEditor.getModel()).general().frequency().trial();
                        IMT2020UpLinkMicroSystemPlugin plugin = new IMT2020UpLinkMicroSystemPlugin();
                        plugin.setUI((SystemModelIMT2020UpLinkMicro)modelEditor.getModel());
                        plugin.prepareSimulation(null);
                        double couplingLossPercentile = CouplingLossEstimatorMicro.estimate(plugin, frequency, CouplingLossEstimationMicroUI.this.samples);
                        item.setResult(df.format(couplingLossPercentile));
                        item.showPreview();
                        return couplingLossPercentile;
                    }

                    @Override
                    public void done(Double result) {
                        OFDMAUpLinkUI prototype = Factory.prototype(OFDMAUpLinkUI.class, ((SystemModelIMT2020UpLinkMicro)modelEditor.getModel()).generalSettings().ofdmaUpLink());
                        OptionalValue<Double> current = ((SystemModelIMT2020UpLinkMicro)modelEditor.getModel()).generalSettings().ofdmaUpLink().percentile();
                        Factory.when(prototype.percentile()).thenReturn(Factory.results().optional(current.isRelevant(), (double)Math.round(result * 1000.0) / 1000.0));
                        editor.setModel(Factory.build(prototype));
                    }
                });
            }
        });
        return new PanelModelEditor<OFDMAUpLinkUI>(){

            @Override
            public JPanel getPanel() {
                return editor;
            }

            @Override
            public OFDMAUpLinkUI getModel() {
                return (OFDMAUpLinkUI)editor.getModel();
            }
        };
    }

    private void showCDF() {
        if (this.samples.isEmpty()) {
            return;
        }
        double[] data = new double[this.samples.size()];
        for (int i = 0; i < this.samples.size(); ++i) {
            data[i] = this.samples.get(i);
        }
        new VectorDialog(data, "Sorted samples of the coupling loss", "dB", "samples");
    }
}

