/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.imt2020uplink.simulation;

import org.seamcat.model.engines.InterferenceSimulationEngine;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.simulation.result.DefaultVictimImpl;
import org.seamcat.model.systems.imt2020uplink.simulation.Link;
import org.seamcat.model.systems.imt2020uplink.simulation.MobileStation;

public class VictimImpl
extends DefaultVictimImpl<VictimImpl> {
    private Link connection;
    private double achievedSINR;
    private double achievedBitrate;

    public VictimImpl(Link connection) {
        super(connection.getBaseStation().getAntennaGain(), connection.getLinkResult());
        this.connection = connection;
        if (connection.isWrapAroundLink()) {
            connection.getLinkResult().setValue(InterferenceSimulationEngine.SYSTEM_LINK_TYPE, "Secondary Link");
        }
    }

    public void calculateAchievedSINRWatt() {
        double rPowerWatt = Mathematics.fromdBm2Watt(this.connection.getUserTerminal().getServingLink().getCurrentReceivePower());
        double totalInterferenceWatt = this.connection.getUserTerminal().getTotalInterferenceWatt();
        double extIntWatt = Mathematics.fromdBm2Watt(this.getTotalInterferenceBlocking()) + Mathematics.fromdBm2Watt(this.getTotalInterferenceUnwanted());
        double v = rPowerWatt / (totalInterferenceWatt + extIntWatt);
        this.achievedSINR = Mathematics.linear2dB(v);
    }

    public boolean isConnectedToReferenceCell() {
        return this.connection.getBaseStation().isReferenceCell();
    }

    public double getNonInterferedAchievedSINR() {
        return this.connection.getUserTerminal().getAchievedSINR();
    }

    public double getAchievedSINR() {
        return this.achievedSINR;
    }

    public double getNonInterferedAchievedBitrate() {
        return this.connection.getUserTerminal().getAchievedBitrate();
    }

    public double getAchievedBitrate() {
        return this.achievedBitrate;
    }

    public double getReceivePower() {
        return this.connection.getCurrentReceivePower();
    }

    public double getUEFrequency() {
        return this.connection.getUserTerminal().getFrequency();
    }

    @Override
    public boolean isSameRx(VictimImpl other) {
        return this.connection.getBaseStation().getBaseStationId() == other.connection.getBaseStation().getBaseStationId();
    }

    public void calculateAchievedBitrate() {
        double maxAch = this.connection.getUserTerminal().getMaxAchievableBitRate(this.achievedSINR);
        int requestedSubCarriers = this.connection.getSettings().getMaxRBsPrMS();
        this.achievedBitrate = (double)requestedSubCarriers * (maxAch / (double)this.connection.getSettings().getMaxRBsPrBS());
    }

    public double getCurrentTransmitPower() {
        return this.connection.getUserTerminal().getCurrentTransmitPower();
    }

    public MobileStation getUserTerminal() {
        return this.connection.getUserTerminal();
    }

    public int getBaseStationId() {
        return this.connection.getBaseStation().getBaseStationId();
    }

    @Override
    public String getRxName() {
        return this.connection.getBaseStation().getName();
    }

    @Override
    public String getTxName() {
        return this.connection.getUserTerminal().getName();
    }
}

