/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.imt2020uplink.simulation;

import java.util.ArrayList;
import java.util.List;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.geometry.Polygon2D;
import org.seamcat.model.plugin.system.SimulationInstance;
import org.seamcat.model.plugin.system.Space;
import org.seamcat.model.plugin.system.SystemSpaces;
import org.seamcat.model.plugin.system.optional.SectorPropertyType;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.InterfererResultCollector;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.systems.cellulargrid.HexagonCells;
import org.seamcat.model.systems.imt2020uplink.IMT2020UpLinkSystemPlugin;
import org.seamcat.model.systems.imt2020uplink.simulation.BaseStation;
import org.seamcat.model.systems.imt2020uplink.simulation.IMT2020UpLinkCalculations;
import org.seamcat.model.systems.imt2020uplink.simulation.IMT2020UpLinkSettings;
import org.seamcat.model.systems.imt2020uplink.simulation.InterfererImpl;
import org.seamcat.model.systems.imt2020uplink.simulation.Link;
import org.seamcat.model.systems.imt2020uplink.simulation.VictimImpl;
import org.seamcat.model.systems.ofdmadownlink.OFDMADownLinkSystemPlugin;
import org.seamcat.model.systems.ofdmauplink.OFDMAUpLinkSystemPlugin;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.result.Results;

public class IMT2020UpLinkSimulation
implements SimulationInstance {
    private IMT2020UpLinkSettings settings;
    private final IMT2020UpLinkSystemPlugin plugin;
    private final SystemSpaces sectorShapes;

    public IMT2020UpLinkSimulation(IMT2020UpLinkSystemPlugin plugin, SystemSpaces sectorShapes) {
        this.settings = plugin.getSettings();
        this.plugin = plugin;
        this.sectorShapes = sectorShapes;
    }

    @Override
    public void victimSimulation(VictimResultCollector collector) {
        Results pre = collector.getPreSimulationResults();
        double frequency = pre.findDoubleValue(OFDMADownLinkSystemPlugin.SIMULATION_FREQUENCY);
        double couplingLossPercentile = pre.findDoubleValue(OFDMAUpLinkSystemPlugin.COUPLING_LOSS_PERCENTILE);
        double thermalNoiseUE = pre.findDoubleValue(OFDMADownLinkSystemPlugin.THERMAL_NOISE_UE);
        List<Link> activeConnections = IMT2020UpLinkCalculations.scalePower(this.positionAndConnect(Point2D.ORIGIN, frequency, this.sectorShapes), couplingLossPercentile, thermalNoiseUE);
        for (Link active : activeConnections) {
            VictimImpl victim = new VictimImpl(active);
            collector.add(victim);
        }
        IMT2020UpLinkCalculations.calculateVictimResults(collector);
    }

    @Override
    public void interferingSystemSimulation(EventResult eventResult, InterferenceLink link, Point2D position) {
        InterfererResultCollector collector = eventResult.getInterferingSystemResult(link);
        Results pre = collector.getPreSimulationResults();
        double frequency = pre.findDoubleValue(OFDMADownLinkSystemPlugin.SIMULATION_FREQUENCY);
        double couplingLossPercentile = pre.findDoubleValue(OFDMAUpLinkSystemPlugin.COUPLING_LOSS_PERCENTILE);
        double thermalNoiseUE = pre.findDoubleValue(OFDMADownLinkSystemPlugin.THERMAL_NOISE_UE);
        List<Link> activeConnections = IMT2020UpLinkCalculations.scalePower(this.positionAndConnect(position, frequency, this.sectorShapes), couplingLossPercentile, thermalNoiseUE);
        for (Link active : activeConnections) {
            double mcl = link.getCorrelationSettings().getMinimumCouplingLoss().trial();
            collector.add(new InterfererImpl(link.linkIndex(), active, mcl));
        }
    }

    @Override
    public void interferingSystemSimulation(EventResult eventResult, InterferenceLink link, Point2D position, LinkResult positionFromCoLocation) {
    }

    @Override
    public void interferedVictimSimulation(EventResult eventResult) {
        IMT2020UpLinkCalculations.calculateInterferedVictim(eventResult);
    }

    @Override
    public List<Victim> getResultingVictims(VictimResultCollector vCollector) {
        ArrayList<Victim> victims = new ArrayList<Victim>();
        for (Victim victim : vCollector.getVictims()) {
            VictimImpl v = (VictimImpl)victim;
            if (!v.isConnectedToReferenceCell()) continue;
            victims.add(v);
        }
        return victims;
    }

    @Override
    public void postEvent(EventResult eventResult) {
    }

    public List<Link> positionAndConnect(Point2D position, double frequency, SystemSpaces shapes) {
        ArrayList<BaseStation> baseStations = new ArrayList<BaseStation>();
        List<Object> wrapAroundBS = new ArrayList();
        if (this.plugin.isUsingWrapAround()) {
            wrapAroundBS = HexagonCells.wrapAroundOffsets(this.plugin.getCellRadius(), this.plugin.getSectorSetup());
        }
        List<Space> rxSpaces = shapes.getRxSpaces();
        for (int i = 0; i < rxSpaces.size(); ++i) {
            String name;
            Polygon2D rxSpace = rxSpaces.get(i).getSpace();
            boolean refCell = rxSpaces.get(i).hasProperty(SectorPropertyType.REFERENCE_CELL);
            if (this.plugin.getSectorSetup().getSectors() == 1) {
                name = "BS Cell #" + (i + 1);
            } else {
                int cell = i / 3;
                int sector = 1 + i % 3;
                name = "BS Cell #" + cell;
                name = name + " Sector " + sector;
            }
            BaseStation baseStation = this.settings.create(name, position.add(rxSpace.getVertices().get(0)), refCell, i, frequency);
            baseStations.add(baseStation);
            for (Point2D point2D : wrapAroundBS) {
                baseStations.add(this.settings.createWrapAround(baseStation, point2D.add(position)));
            }
        }
        return this.settings.positionMSsAndInitialConnectBS(baseStations, position, frequency, shapes.getTxSpaces());
    }
}

