/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.imt2020uplink.simulation;

import java.util.ArrayList;
import java.util.List;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.geometry.PolygonUtil;
import org.seamcat.model.plugin.system.SimulationInstance;
import org.seamcat.model.plugin.system.Space;
import org.seamcat.model.plugin.system.SystemSpaces;
import org.seamcat.model.plugin.system.optional.SectorPropertyType;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.InterfererResultCollector;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.systems.imt2020uplink.IMT2020UpLinkMicroSystemPlugin;
import org.seamcat.model.systems.imt2020uplink.IMT2020UpLinkSystemPlugin;
import org.seamcat.model.systems.imt2020uplink.simulation.BaseStation;
import org.seamcat.model.systems.imt2020uplink.simulation.IMT2020UpLinkCalculations;
import org.seamcat.model.systems.imt2020uplink.simulation.IMT2020UpLinkSettings;
import org.seamcat.model.systems.imt2020uplink.simulation.InterfererImpl;
import org.seamcat.model.systems.imt2020uplink.simulation.Link;
import org.seamcat.model.systems.imt2020uplink.simulation.VictimImpl;
import org.seamcat.model.systems.ofdmadownlink.OFDMADownLinkSystemPlugin;
import org.seamcat.model.systems.ofdmauplink.OFDMAUpLinkSystemPlugin;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.result.Results;

public class IMT2020UpLinkMicroSimulation
implements SimulationInstance {
    private IMT2020UpLinkSettings settings;
    private IMT2020UpLinkMicroSystemPlugin plugin;
    private SystemSpaces sectorShapes;

    public IMT2020UpLinkMicroSimulation(IMT2020UpLinkMicroSystemPlugin plugin, SystemSpaces sectorShapes) {
        this.settings = plugin.getSettings();
        this.plugin = plugin;
        this.sectorShapes = sectorShapes;
    }

    @Override
    public void victimSimulation(VictimResultCollector collector) {
        Results pre = collector.getPreSimulationResults();
        double frequency = pre.findDoubleValue(IMT2020UpLinkSystemPlugin.SIMULATION_FREQUENCY);
        List<Link> activeConnections = this.positionAndConnect(Point2D.ORIGIN, frequency, this.sectorShapes);
        double couplingLossPercentile = pre.findDoubleValue(OFDMAUpLinkSystemPlugin.COUPLING_LOSS_PERCENTILE);
        double thermalNoiseUE = pre.findDoubleValue(OFDMADownLinkSystemPlugin.THERMAL_NOISE_UE);
        IMT2020UpLinkCalculations.scalePower(activeConnections, couplingLossPercentile, thermalNoiseUE);
        for (Link active : activeConnections) {
            collector.add(new VictimImpl(active));
        }
        IMT2020UpLinkCalculations.calculateVictimResults(collector);
    }

    @Override
    public void interferingSystemSimulation(EventResult eventResult, InterferenceLink link, Point2D position) {
        InterfererResultCollector collector = eventResult.getInterferingSystemResult(link);
        Results pre = collector.getPreSimulationResults();
        double frequency = pre.findDoubleValue(IMT2020UpLinkSystemPlugin.SIMULATION_FREQUENCY);
        List<Link> activeConnections = this.positionAndConnect(position, frequency, this.sectorShapes);
        double couplingLossPercentile = pre.findDoubleValue(OFDMAUpLinkSystemPlugin.COUPLING_LOSS_PERCENTILE);
        double thermalNoiseUE = pre.findDoubleValue(OFDMADownLinkSystemPlugin.THERMAL_NOISE_UE);
        IMT2020UpLinkCalculations.scalePower(activeConnections, couplingLossPercentile, thermalNoiseUE);
        for (Link active : activeConnections) {
            double mcl = link.getCorrelationSettings().getMinimumCouplingLoss().trial();
            collector.add(new InterfererImpl(link.linkIndex(), active, mcl));
        }
    }

    @Override
    public void interferingSystemSimulation(EventResult eventResult, InterferenceLink link, Point2D position, LinkResult positionFromCoLocation) {
    }

    @Override
    public void interferedVictimSimulation(EventResult eventResult) {
        IMT2020UpLinkCalculations.calculateInterferedVictim(eventResult);
    }

    @Override
    public List<Victim> getResultingVictims(VictimResultCollector vCollector) {
        ArrayList<Victim> victims = new ArrayList<Victim>();
        for (Victim victim : vCollector.getVictims()) {
            if (!(victim instanceof VictimImpl) || !((VictimImpl)victim).isConnectedToReferenceCell()) continue;
            victims.add(victim);
        }
        return victims;
    }

    @Override
    public void postEvent(EventResult eventResult) {
    }

    public List<Link> positionAndConnect(Point2D position, double frequency, SystemSpaces shapes) {
        int bsId = 0;
        ArrayList<BaseStation> baseStations = new ArrayList<BaseStation>();
        List<Space> rxSpaces = shapes.getRxSpaces();
        for (int i = 0; i < rxSpaces.size(); ++i) {
            Space rxShape = rxSpaces.get(i);
            for (int j = 0; j < this.plugin.numberOfBSInMicroClusters(); ++j) {
                Point2D bsPosition = PolygonUtil.getRandomPointInside(rxShape.getSpace()).add(position);
                boolean refCell = rxShape.hasProperty(SectorPropertyType.REFERENCE_CELL);
                String name = "Cluster #" + i + " BS " + (j + 1);
                baseStations.add(this.settings.create(name, bsPosition, refCell, bsId, frequency));
                ++bsId;
            }
        }
        return this.settings.positionMSsAndInitialConnectBS(baseStations, position, frequency, shapes.getTxSpaces());
    }
}

