/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.imt2020uplink.simulation;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.seamcat.model.factory.RandomAccessor;
import org.seamcat.model.factory.SeamcatRandom;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.systems.imt2020uplink.simulation.IMT2020UpLinkSettings;
import org.seamcat.model.systems.imt2020uplink.simulation.Link;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.model.types.LocalEnvironment;

class BaseStation {
    protected static final Logger LOG = Logger.getLogger(BaseStation.class);
    private boolean isWrapAround = false;
    private BaseStation corresponding;
    private Point2D offset;
    private List<Link> candidateConnections;
    private List<Link> activeConnections;
    private List<Link> inActiveConnections;
    private String name;
    private IMT2020UpLinkSettings settings;
    private Point2D position;
    private double antennaHeight;
    private double antennaTilt;
    private double frequency;
    private int baseStationId;
    private int subCarriersInUse = 0;
    private SeamcatRandom random;
    private AntennaGain ag;
    private boolean referenceCell;
    private int activeSize;
    private int inActiveSize;
    private double cache;
    private static double adjustmentFactorForNonCoLocatedResourceBlock = 30.0;

    public double getFrequency() {
        return this.frequency;
    }

    public BaseStation(BaseStation corresponding, Point2D offset) {
        this.corresponding = corresponding;
        this.offset = offset;
        this.isWrapAround = true;
    }

    public double getAntennaTilt() {
        return this.antennaTilt;
    }

    public BaseStation(String name, Point2D position, boolean isReferenceCell, int baseStationId, double frequency, IMT2020UpLinkSettings settings, double antHeight, AntennaGain ag, double antennaTilt) {
        this.name = name;
        this.settings = settings;
        this.frequency = frequency;
        this.position = position;
        this.ag = ag;
        this.referenceCell = isReferenceCell;
        this.antennaHeight = antHeight;
        this.antennaTilt = antennaTilt;
        this.baseStationId = baseStationId;
        this.candidateConnections = new ArrayList<Link>();
        this.activeConnections = new ArrayList<Link>();
        this.inActiveConnections = new ArrayList<Link>();
        this.random = RandomAccessor.getRandom();
    }

    public String getName() {
        return this.name;
    }

    public int getBaseStationId() {
        return this.baseStationId;
    }

    public Point2D getPosition() {
        return this.position;
    }

    void setAntennaProperties(AntennaResult ant) {
        ant.setHeight(this.antennaHeight);
        ant.setTilt(this.antennaTilt);
        ant.setPosition(this.position);
    }

    public void addCandidate(Link candidate) {
        this.candidateConnections.add(candidate);
    }

    public void removeCandidate(Link link) {
        this.candidateConnections.remove(link);
    }

    public void addInActive(Link link) {
        this.inActiveConnections.add(link);
    }

    public boolean initialConnect(List<Link> activeLinks) {
        boolean candidatesAvailable;
        int sum = this.getSubCarriersInUse();
        int limit = this.settings.getNumberOfResourceBlocksPrBS();
        int count = sum / this.settings.getMaxRBsPrMS();
        boolean underLoaded = count < limit;
        boolean bl = candidatesAvailable = this.candidateConnections.size() > 0;
        while (underLoaded && candidatesAvailable) {
            Link candidate = this.fetchRandomCandidate();
            ++count;
            sum += this.settings.getMaxRBsPrMS();
            this.activeConnections.add(candidate);
            candidate.activateLink();
            activeLinks.add(candidate);
            candidatesAvailable = this.candidateConnections.size() > 0;
            underLoaded = count < limit;
        }
        this.setSubCarriersInUse(sum);
        return !underLoaded;
    }

    private Link fetchRandomCandidate() {
        int i = this.random.nextInt(this.candidateConnections.size());
        return this.candidateConnections.remove(i);
    }

    public int getSubCarriersInUse() {
        return this.subCarriersInUse;
    }

    public void setSubCarriersInUse(int subCarriersInUse) {
        this.subCarriersInUse = subCarriersInUse;
    }

    public boolean isReferenceCell() {
        return this.referenceCell;
    }

    public int getLinkIndexOfActiveUser(Link link) {
        return this.activeConnections.indexOf(link);
    }

    public double calculateTotalInterference_Watt(Link excludeLink) {
        Link link;
        int i;
        double sum_Watt = this.cache;
        int resourceBlockNo = excludeLink.getResourceBlockNumber();
        if (this.activeSize < this.activeConnections.size()) {
            for (i = this.activeSize; i < this.activeConnections.size(); ++i) {
                link = this.activeConnections.get(i);
                this.cache += this.currentReceivePowerWatt(link);
                ++this.activeSize;
            }
            sum_Watt = this.cache;
        }
        if (this.inActiveSize < this.inActiveConnections.size()) {
            for (i = this.inActiveSize; i < this.inActiveConnections.size(); ++i) {
                link = this.inActiveConnections.get(i);
                link.calculateCurrentReceivePower();
                this.cache += this.currentReceivePowerWatt(link);
                ++this.inActiveSize;
            }
            sum_Watt = this.cache;
        }
        sum_Watt -= this.currentReceivePowerWatt(excludeLink);
        if (this.settings.useNumberOfActiveMsPerBs()) {
            Double percentage = this.settings.getProbabilities().get(resourceBlockNo);
            int sameRB = (int)Math.round((double)this.inActiveConnections.size() * percentage / 100.0);
            while (sameRB > 0) {
                sum_Watt = this.adjustForCoLocatedResourceBlock(sum_Watt, this.inActiveConnections.get(--sameRB));
            }
            for (Link connection : this.activeConnections) {
                if (connection == excludeLink || connection.getResourceBlockNumber() != resourceBlockNo) continue;
                sum_Watt = this.adjustForCoLocatedResourceBlock(sum_Watt, connection);
            }
        } else {
            int users = this.activeConnections.size();
            int rounds = this.inActiveConnections.size() / users;
            for (int i2 = 0; i2 < rounds; ++i2) {
                sum_Watt = this.adjustForCoLocatedResourceBlock(sum_Watt, this.inActiveConnections.get(users * i2 + resourceBlockNo));
            }
        }
        return sum_Watt;
    }

    private double currentReceivePowerWatt(Link link) {
        double inter_dBm = link.getCurrentReceivePower() - adjustmentFactorForNonCoLocatedResourceBlock;
        return Mathematics.fromdBm2Watt(inter_dBm);
    }

    private double adjustForCoLocatedResourceBlock(double sum_Watt, Link link) {
        sum_Watt -= this.currentReceivePowerWatt(link);
        return sum_Watt += Mathematics.fromdBm2Watt(link.getCurrentReceivePower());
    }

    public AntennaGain getAntennaGain() {
        return this.ag;
    }

    public boolean isAWrapAroundBS() {
        return this.isWrapAround;
    }

    public Point2D getOffset() {
        return this.offset;
    }

    public BaseStation getCorresponding() {
        return this.corresponding;
    }

    public List<LocalEnvironment> getEnvironments() {
        return this.settings.getRxEnvironments();
    }
}

