/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.imt2020uplink;

import java.util.ArrayList;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.Scenario;
import org.seamcat.model.distributions.UniformDistribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.functions.VectorSpace;
import org.seamcat.model.generic.PathLossCorrelationUI;
import org.seamcat.model.geometry.InnerPlacementBoundaryCalculator;
import org.seamcat.model.geometry.Polygon2D;
import org.seamcat.model.geometry.PolygonUtil;
import org.seamcat.model.plugin.OptionalValue;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.Context;
import org.seamcat.model.plugin.system.NoFeasibleShapesException;
import org.seamcat.model.plugin.system.Origin;
import org.seamcat.model.plugin.system.SimulationInstance;
import org.seamcat.model.plugin.system.Space;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.plugin.system.SystemSpaces;
import org.seamcat.model.plugin.system.optional.SectorPropertyDescription;
import org.seamcat.model.plugin.system.optional.SectorPropertyType;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.systems.UIToModelConverter;
import org.seamcat.model.systems.imt2020downlink.IMT2020DownLinkMicroSystemPlugin;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020MicroBaseStation;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020Mobile;
import org.seamcat.model.systems.imt2020uplink.IMT2020UpLinkSystemPlugin;
import org.seamcat.model.systems.imt2020uplink.simulation.CouplingLossEstimatorMicro;
import org.seamcat.model.systems.imt2020uplink.simulation.IMT2020UpLinkMicroSimulation;
import org.seamcat.model.systems.imt2020uplink.simulation.IMT2020UpLinkSettings;
import org.seamcat.model.systems.imt2020uplink.simulation.IMT2020UplinkConsistencyCheck;
import org.seamcat.model.systems.imt2020uplink.ui.IMT2020UpLinkGeneralSettings;
import org.seamcat.model.systems.imt2020uplink.ui.SystemModelIMT2020UpLinkMicro;
import org.seamcat.model.systems.ofdma.ReceiverSettings;
import org.seamcat.model.systems.ofdma.TransmitterSettings;
import org.seamcat.model.types.PropagationModel;
import org.seamcat.model.types.Receiver;
import org.seamcat.model.types.Transmitter;
import org.seamcat.model.types.result.DoubleResultType;
import org.seamcat.model.types.result.Results;
import org.seamcat.simulation.cellular.PathLossCorrelation;

public class IMT2020UpLinkMicroSystemPlugin
implements SystemPlugin<SystemModelIMT2020UpLinkMicro> {
    private SystemModelIMT2020UpLinkMicro ui;
    private RadioSystem victim;
    private RadioSystem interferer;
    private IMT2020UpLinkSettings settings;
    public static final SectorPropertyDescription MICRO = new SectorPropertyDescription("Micro BS Cluster");
    public static final SectorPropertyDescription MACRO_CELL = new SectorPropertyDescription("Macro Cell Sector");

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, Scenario scenario, Validator validator) {
        IMT2020UplinkConsistencyCheck.checkMicroSystem(scenario, context, validator);
        if (context.getOrigin() == Origin.INTERFERENCE_LINK) {
            IMT2020UplinkConsistencyCheck.checkPathLossCorrelationInterferer(context, validator);
        }
    }

    @Override
    public Bounds getSystemCoverage() {
        return new Bounds(0.0, 2.5 * (double)this.ui.positioning().microBS().cellClusters(), true);
    }

    @Override
    public VectorSpace getInterferenceLinkSystemCoverage(boolean victim, ConsistencyCheckContext context) {
        VectorSpace range = VectorSpace.ZERO;
        range.addCircle(this.getSystemCoverage());
        return range;
    }

    @Override
    public void setUI(SystemModelIMT2020UpLinkMicro ui) {
        this.ui = ui;
    }

    @Override
    public SystemModelIMT2020UpLinkMicro getUI() {
        return this.ui;
    }

    @Override
    public void prepareSimulation(Scenario scenario) {
        IMT2020UpLinkGeneralSettings gen = this.ui.generalSettings().generalSettings();
        PathLossCorrelationUI plUI = this.ui.generalSettings().pathLossCorrelation();
        PathLossCorrelation plCorr = new PathLossCorrelation(plUI.usePathLossCorrelation(), plUI.pathLossVariance(), plUI.correlationFactor());
        ReceiverSettings rx = this.ui.generalSettings().receiverSettings();
        double bandwidth = gen.bandwidthResourceBlock() * (double)gen.maxSubcarriersMs() / 1000.0;
        IMT2020MicroBaseStation bs = this.ui.positioning().microBS();
        Receiver vReceiver = UIToModelConverter.getDmaReceiver(rx.standardDesensitisation(), rx.targetINR(), gen.receiverNoiseFigure(), rx.blockingMask(), bandwidth, Factory.results().convert(this.ui.generalSettings().localEnvironments().receiverEnvironments()), bs.antennaGain(), bs.antennaHeight());
        bandwidth = gen.bandwidthResourceBlock() * (double)gen.maxSubcarriersBs() / 1000.0;
        Receiver iReceiver = UIToModelConverter.getDmaReceiver(rx.standardDesensitisation(), rx.targetINR(), gen.receiverNoiseFigure(), rx.blockingMask(), bandwidth, Factory.results().convert(this.ui.generalSettings().localEnvironments().receiverEnvironments()), bs.antennaGain(), bs.antennaHeight());
        TransmitterSettings tx = this.ui.generalSettings().transmitterSettings();
        IMT2020Mobile ms = this.ui.positioning().mobile();
        Transmitter transmitter = new Transmitter(tx.emissionMask(), tx.emissionFloor().getValue(), tx.emissionFloor().isRelevant(), gen.bandwidthResourceBlock() * (double)gen.maxSubcarriersMs() / 1000.0, null, Factory.results().convert(this.ui.generalSettings().localEnvironments().transmitterEnvironments()), ms.antennaGain(), ms.antennaHeight(), 0.0, false);
        PropagationModel propagationModel = this.ui.positioning().propagationModel();
        this.victim = new RadioSystem(vReceiver, transmitter, propagationModel);
        this.interferer = new RadioSystem(iReceiver, transmitter, propagationModel);
        this.settings = new IMT2020UpLinkSettings(this.victim, gen, plCorr, this.ui.generalSettings().ofdmaUpLink(), this.ui.generalSettings().ueDistribution(), bs.antennaHeight(), ms.antennaGain(), ms.antennaHeight(), ms.azimuth(), ms.azimuthOffset(), ms.elevation(), ms.elevationOffset(), bs.azimuth(), bs.azimuthOffset(), bs.elevation(), bs.elevationOffset());
        this.settings.setBsGain(bs.antennaGain());
    }

    @Override
    public RadioSystem getSystem(Context context) {
        if (context.isVictim()) {
            return this.victim;
        }
        return this.interferer;
    }

    @Override
    public void preSimulation(Context context, Results results) {
        UniformDistribution freq;
        double bw;
        double frequency = context.getFrequency().trial();
        results.getSingleValueTypes().add(new DoubleResultType(IMT2020UpLinkSystemPlugin.SIMULATION_FREQUENCY, frequency));
        if (context.isVictim()) {
            bw = (double)this.settings.getMaxRBsPrBS() * this.settings.getBandwidthOfAnRB() / 1000.0;
            freq = Factory.distributionFactory().getUniformDistribution(frequency - bw / 2.0, frequency + bw / 2.0);
        } else {
            bw = this.interferer.getReceiver().getBandwidth();
            freq = Factory.distributionFactory().getUniformDistribution(frequency - bw / 2.0, frequency + bw / 2.0);
        }
        context.getSystemPlugin().setFrequency(freq);
        double clp = this.getPercentile().isRelevant() ? this.getPercentile().getValue() : CouplingLossEstimatorMicro.estimate(this, frequency);
        results.getSingleValueTypes().add(new DoubleResultType(IMT2020UpLinkSystemPlugin.COUPLING_LOSS_PERCENTILE, clp));
    }

    @Override
    public void postSimulation(Context context, Results results) {
    }

    @Override
    public SimulationInstance simulationInstance(Context context, SystemSpaces sectorShapes) {
        return new IMT2020UpLinkMicroSimulation(this, sectorShapes);
    }

    public int numberOfMicroClusters() {
        return this.ui.positioning().microBS().cellClusters();
    }

    public int numberOfBSInMicroClusters() {
        return this.ui.positioning().microBS().microBSPerCluster();
    }

    public double getClusterRadius() {
        return this.ui.positioning().microBS().clusterRadius();
    }

    @Override
    public SystemSpaces generateSystemSpaces(SystemSpaces enclosing) {
        ArrayList<Space> spaces = new ArrayList<Space>();
        if (enclosing == null) {
            double ueCircle = 3.5 * this.getClusterRadius();
            Polygon2D txSector = PolygonUtil.convertCircle(ueCircle, 0.0, 6, new Bounds(0.0, 360.0, true));
            spaces.add(new Space(txSector, false, MACRO_CELL));
            Polygon2D inner = PolygonUtil.convertCircle(this.getClusterRadius(), 0.0, 16, new Bounds(0.0, 360.0, true));
            Polygon2D feasibleInnerCircle = InnerPlacementBoundaryCalculator.innerPlacementBoundary(txSector, inner);
            IMT2020DownLinkMicroSystemPlugin.addClustersForCell(feasibleInnerCircle, spaces, MICRO, SectorPropertyType.REFERENCE_CELL, inner, this.getClusterRadius(), this.numberOfMicroClusters(), true);
        } else {
            Polygon2D sampleMicroCluster = PolygonUtil.convertCircle(this.getClusterRadius(), 0.0, 16, new Bounds(0.0, 360.0, true));
            for (Space txSpace : enclosing.getTxSpaces()) {
                spaces.add(txSpace);
                boolean refCell = txSpace.hasProperty(SectorPropertyType.REFERENCE_CELL);
                SectorPropertyType type = refCell ? SectorPropertyType.REFERENCE_CELL : SectorPropertyType.CELL;
                try {
                    Polygon2D feasibleInner = InnerPlacementBoundaryCalculator.innerPlacementBoundary(txSpace.getSpace(), sampleMicroCluster);
                    IMT2020DownLinkMicroSystemPlugin.addClustersForCell(feasibleInner, spaces, MICRO, type, sampleMicroCluster, this.getClusterRadius(), this.numberOfMicroClusters(), true);
                }
                catch (Exception e) {
                    throw new NoFeasibleShapesException("Unable to position a micro grid cluster with radius " + this.getClusterRadius() + " km inside surrounding shapes");
                }
            }
        }
        return new SystemSpaces(spaces);
    }

    public IMT2020UpLinkSettings getSettings() {
        return this.settings;
    }

    public double getPowerScalingThreshold() {
        return this.ui.generalSettings().ofdmaUpLink().getPowerScalingThreshold();
    }

    public OptionalValue<Double> getPercentile() {
        return this.ui.generalSettings().ofdmaUpLink().percentile();
    }
}

