/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.imt2020downlink.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020Layout;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020LayoutPanel;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020PositionHolder;
import org.seamcat.presentation.layout.VerticalSubPanelLayoutManager;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;

public class SystemLayoutPanel
extends JPanel {
    private JRadioButton center = new JRadioButton("Center of \"infinite\" network");
    private JRadioButton left = new JRadioButton("Left hand side of network edge");
    private JRadioButton right = new JRadioButton("Right hand side of network edge");
    private JCheckBox interferenceFromCluster = new JCheckBox("Measure Interference from entire cluster");
    private JCheckBox plotWrapAround = new JCheckBox("Generate Wrap-Around");
    private Box innerPanel;
    private boolean entireEnable;
    private IMT2020LayoutPanel.Refresher refresher;
    private IMT2020PositionHolder cellularPositionHolder;

    public SystemLayoutPanel(boolean entireEnable, IMT2020LayoutPanel.Refresher refresher) {
        this.entireEnable = entireEnable;
        this.refresher = refresher;
        this.initializeWidgets();
        this.setLayout(new VerticalSubPanelLayoutManager());
        this.add(this.innerPanel);
    }

    public void setModel(IMT2020PositionHolder cellularPositionHolder) {
        this.cellularPositionHolder = cellularPositionHolder;
        this.refreshFromModel();
    }

    public IMT2020PositionHolder getModel() {
        return this.cellularPositionHolder;
    }

    public void initializeWidgets() {
        this.innerPanel = Box.createVerticalBox();
        ButtonGroup networkEdgeButtons = new ButtonGroup();
        networkEdgeButtons.add(this.center);
        networkEdgeButtons.add(this.left);
        networkEdgeButtons.add(this.right);
        this.innerPanel.add(this.center);
        this.innerPanel.add(this.left);
        this.innerPanel.add(this.right);
        this.innerPanel.add(Box.createVerticalStrut(20));
        this.innerPanel.add(this.interferenceFromCluster);
        this.innerPanel.add(this.plotWrapAround);
        for (Component c : this.innerPanel.getComponents()) {
            if (!(c instanceof JComponent)) continue;
            ((JComponent)c).setAlignmentX(0.0f);
        }
        this.center.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (SystemLayoutPanel.this.center.isSelected()) {
                    SystemLayoutPanel.this.localUpdate();
                    SystemLayoutPanel.this.updateModel();
                }
            }
        });
        this.left.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (SystemLayoutPanel.this.left.isSelected()) {
                    SystemLayoutPanel.this.localUpdate();
                    SystemLayoutPanel.this.updateModel();
                }
            }
        });
        this.right.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (SystemLayoutPanel.this.right.isSelected()) {
                    SystemLayoutPanel.this.localUpdate();
                    SystemLayoutPanel.this.updateModel();
                }
            }
        });
        this.plotWrapAround.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SystemLayoutPanel.this.updateModel();
                boolean enable = !SystemLayoutPanel.this.plotWrapAround.isSelected();
                SystemLayoutPanel.this.left.setEnabled(enable);
                SystemLayoutPanel.this.right.setEnabled(enable);
                SystemLayoutPanel.this.center.setEnabled(enable);
            }
        });
        if (!this.entireEnable) {
            this.interferenceFromCluster.setVisible(false);
        } else {
            this.interferenceFromCluster.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SystemLayoutPanel.this.updateModel();
                }
            });
        }
    }

    public void refreshFromModel() {
        IMT2020Layout model = this.getModel().get();
        if (model.tiers() != 2) {
            this.plotWrapAround.setSelected(false);
            this.plotWrapAround.setEnabled(false);
        } else {
            this.plotWrapAround.setEnabled(true);
            this.plotWrapAround.setSelected(model.generateWrapAround());
        }
        boolean enable = !this.plotWrapAround.isSelected();
        this.center.setEnabled(enable);
        this.left.setEnabled(enable);
        this.right.setEnabled(enable);
        if (model.layout().equals((Object)HybridSystemPlugin.SystemLayout.CenterOfInfiniteNetwork)) {
            this.center.setSelected(true);
        } else if (model.layout().equals((Object)HybridSystemPlugin.SystemLayout.LeftHandSideOfNetworkEdge)) {
            this.left.setSelected(true);
        } else {
            this.right.setSelected(true);
        }
        this.interferenceFromCluster.setEnabled(true);
        this.interferenceFromCluster.setSelected(model.measureFromEntireCluster());
    }

    private void localUpdate() {
        IMT2020Layout prototype = Factory.prototype(IMT2020Layout.class, this.getModel().get());
        if (this.center.isSelected()) {
            Factory.when(prototype.referenceSector()).thenReturn(0);
            Factory.when(prototype.referenceCellId()).thenReturn(0);
        } else {
            Factory.when(prototype.referenceSector()).thenReturn(0);
            switch (this.getModel().get().tiers()) {
                case 2: {
                    Factory.when(prototype.referenceCellId()).thenReturn(this.left.isSelected() ? 13 : 7);
                    break;
                }
                case 1: {
                    if (this.getModel().get().sectorType().equals((Object)HybridSystemPlugin.SectorSetup.TriSector3GPP)) {
                        Factory.when(prototype.referenceCellId()).thenReturn(this.left.isSelected() ? 4 : 1);
                        break;
                    }
                    Factory.when(prototype.referenceCellId()).thenReturn(this.left.isSelected() ? 3 : 1);
                    break;
                }
                default: {
                    Factory.when(prototype.referenceCellId()).thenReturn(0);
                }
            }
        }
        this.getModel().set(Factory.build(prototype));
    }

    public void updateModel() {
        IMT2020Layout prototype = Factory.prototype(IMT2020Layout.class, this.getModel().get());
        Factory.when(prototype.generateWrapAround()).thenReturn(this.plotWrapAround.isSelected());
        Factory.when(prototype.measureFromEntireCluster()).thenReturn(this.interferenceFromCluster.isSelected());
        if (this.center.isSelected()) {
            Factory.when(prototype.layout()).thenReturn(HybridSystemPlugin.SystemLayout.CenterOfInfiniteNetwork);
        } else {
            HybridSystemPlugin.SystemLayout layout = this.left.isSelected() ? HybridSystemPlugin.SystemLayout.LeftHandSideOfNetworkEdge : HybridSystemPlugin.SystemLayout.RightHandSideOfNetworkEdge;
            Factory.when(prototype.layout()).thenReturn(layout);
        }
        this.getModel().set(Factory.build(prototype));
        this.refresher.refresh();
    }
}

