/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.imt2020downlink.ui;

import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.Config;
import org.seamcat.model.types.AntennaGain;

public interface IMT2020Mobile {
    public static final Distribution antennaHeight = Factory.distributionFactory().getConstantDistribution(1.5);
    public static final AzimuthPointing azimuth = AzimuthPointing.TOWARD_BS;
    public static final Distribution azimuthOffset = Factory.distributionFactory().getUniformDistribution(-60.0, 60.0);
    public static final ElevationPointing elevation = ElevationPointing.HORIZONTAL;
    public static final Distribution elevationOffset = Factory.distributionFactory().getUniformDistribution(-90.0, 90.0);

    @Config(order=1, name="Antenna height", unit="m", distributions={"CONSTANT", "USER_DEFINED", "UNIFORM", "STAIR", "DISCRETE_UNIFORM"})
    public Distribution antennaHeight();

    @Config(order=2, name="Azimuth pointing reference (i.e. 0 degree) for the MS", renderHint="radio")
    public AzimuthPointing azimuth();

    @Config(order=3, name="Azimuth additional offset", unit="deg", distributions={"CONSTANT", "USER_DEFINED", "UNIFORM", "STAIR", "DISCRETE_UNIFORM", "UNIFORM_POLAR_ANGLE"})
    public Distribution azimuthOffset();

    @Config(order=4, name="Elevation pointing reference (i.e. 0 degree) for the MS", renderHint="radio")
    public ElevationPointing elevation();

    @Config(order=5, name="Elevation additional offset", unit="deg", distributions={"CONSTANT", "USER_DEFINED", "UNIFORM", "STAIR", "DISCRETE_UNIFORM", "UNIFORM_POLAR_ANGLE"})
    public Distribution elevationOffset();

    @Config(order=6, name="Antenna gain", embed=true)
    public AntennaGain antennaGain();

    public static enum ElevationPointing {
        HORIZONTAL("towards the horizon"),
        TOWARD_BS("towards the BS");

        private String title;

        private ElevationPointing(String title) {
            this.title = title;
        }

        public String toString() {
            return this.title;
        }
    }

    public static enum AzimuthPointing {
        TOWARD_BS("towards the BS"),
        EAST("towards East");

        private String title;

        private AzimuthPointing(String title) {
            this.title = title;
        }

        public String toString() {
            return this.title;
        }
    }
}

