/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.imt2020downlink.simulation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.systems.imt2020downlink.simulation.BaseStation;
import org.seamcat.model.systems.imt2020downlink.simulation.IMT2020Settings;
import org.seamcat.model.systems.imt2020downlink.simulation.Link;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.model.types.LocalEnvironment;
import org.seamcat.simulation.cellular.PathLossCorrelation;

class MobileStation {
    private List<Link> links;
    private Link servingLink;
    private IMT2020Settings settings;
    private RadioSystem system;
    private double antennaHeight;
    private double frequency;
    private final int userid;
    private Point2D position;
    private AntennaGain antennaGain;

    public double getFrequency() {
        return this.frequency;
    }

    public MobileStation(Point2D position, double frequency, IMT2020Settings settings, RadioSystem system, int _userid, AntennaGain antGain, double antHeight) {
        this.position = position;
        this.frequency = frequency;
        this.userid = _userid;
        this.antennaHeight = antHeight;
        this.antennaGain = antGain;
        this.system = system;
        this.settings = settings;
    }

    public List<Link> getAllLinks() {
        return this.links;
    }

    public Link getServingLink() {
        return this.servingLink;
    }

    public void setServingLink(Link servingLink, double frequency) {
        this.servingLink = servingLink;
        this.frequency = frequency;
        servingLink.getLinkResult().setFrequency(frequency);
        for (Link link : this.links) {
            if (link == servingLink) continue;
            link.getBaseStation().removeCandidate(link);
        }
    }

    public Point2D getPosition() {
        return this.position;
    }

    public AntennaGain getAntennaGain() {
        return this.antennaGain;
    }

    void setAntennaProperties(AntennaResult ant) {
        ant.setHeight(this.antennaHeight);
        ant.setTilt(0.0);
        ant.setPosition(this.position);
    }

    public void linkToBSAndAddToCandidateList(List<BaseStation> cells, boolean triSector) {
        ArrayList<Link> links = new ArrayList<Link>();
        PathLossCorrelation correlation = this.settings.getPathLossCorrelation();
        double correlationInterSite = correlation.getCorrelationFactor();
        double a_inter = Math.sqrt(Math.abs(correlationInterSite));
        double b_inter = Math.sqrt(1.0 - Math.abs(correlationInterSite));
        double x = correlation.trial();
        for (int i = 0; i < cells.size(); ++i) {
            double y = correlation.trial();
            double pathLossOffset = 0.0;
            if (correlation.isUsingPathLossCorrelation()) {
                pathLossOffset = a_inter * x + b_inter * y;
            }
            Link link = new Link(this.settings, cells.get(i), this, this.system, this.frequency, pathLossOffset);
            links.add(link);
        }
        Collections.sort(links, Link.comparator);
        Link first = (Link)links.get(0);
        first.addAsCandidate();
        if (links.size() > 1) {
            int index = 1;
            double lowestLink = first.getEffectivePathloss();
            double nextLink = ((Link)links.get(index)).getEffectivePathloss();
            while (lowestLink + this.settings.getHandoverMargin() > nextLink) {
                ((Link)links.get(index)).addAsCandidate();
                if (++index >= links.size()) break;
                nextLink = ((Link)links.get(index)).getEffectivePathloss();
            }
        }
        this.links = new ArrayList<Link>();
        for (Link link : links) {
            if (link.getBaseStation().isAWrapAroundBS()) continue;
            this.links.add(link);
        }
    }

    public int getUserid() {
        return this.userid;
    }

    public List<LocalEnvironment> getEnvironments() {
        return this.settings.getRxEnvironments();
    }

    public String getName() {
        return "MS " + (this.userid + 1);
    }
}

