/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.imt2020downlink.simulation;

import java.util.Comparator;
import org.apache.log4j.Logger;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.simulation.result.Direction;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.systems.imt2020downlink.simulation.BaseStation;
import org.seamcat.model.systems.imt2020downlink.simulation.IMT2020Settings;
import org.seamcat.model.systems.imt2020downlink.simulation.MobileStation;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020MacroBaseStation;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020Mobile;

class Link {
    protected static final Logger LOG = Logger.getLogger(Link.class);
    static Comparator<Link> comparator = new Comparator<Link>(){

        @Override
        public int compare(Link l1, Link l2) {
            double l2Result;
            if (l1 == null && l2 == null) {
                return 0;
            }
            if (l1 == null) {
                return -1;
            }
            if (l2 == null) {
                return 1;
            }
            double l1Result = l1.txRxPathLoss - l1.gainSum();
            if (l1Result > (l2Result = l2.txRxPathLoss - l2.gainSum())) {
                return 1;
            }
            if (l1Result < l2Result) {
                return -1;
            }
            return 0;
        }

        @Override
        public boolean equals(Object obj) {
            return false;
        }
    };
    private boolean isWrapAround = false;
    private BaseStation basestation;
    private MobileStation user;
    private IMT2020Settings settings;
    private RadioSystem system;
    private double totalReceivedPower;
    private double txRxPathLoss;
    private double effectivePathLoss;
    private LinkResult linkResult;

    public Link(IMT2020Settings settings, BaseStation BS, MobileStation MS, RadioSystem system, double frequency, double pathLossOffset) {
        this.settings = settings;
        this.system = system;
        this.initialize(BS, MS, frequency);
        this.setTxRxPathLoss(system.getPropagationModel().evaluate(this.linkResult) + pathLossOffset);
    }

    public Link(IMT2020Settings settings, BaseStation BS, MobileStation MS, RadioSystem system, double frequency, double pathLoss, boolean cachedEffectivePathLoss) {
        this.settings = settings;
        this.system = system;
        this.initialize(BS, MS, frequency);
        this.setTxRxPathLoss(pathLoss);
    }

    private void setTxRxPathLoss(double txRxPathLoss) {
        this.txRxPathLoss = txRxPathLoss;
        this.linkResult.setTxRxPathLoss(txRxPathLoss);
        this.effectivePathLoss = Math.max(this.linkResult.getTxRxPathLoss() - this.gainSum(), this.settings.getMinimumCouplingLoss());
        this.linkResult.setEffectiveTxRxPathLoss(this.effectivePathLoss);
    }

    private void initialize(BaseStation BS, MobileStation MS, double frequency) {
        this.linkResult = Factory.results().linkResult(this.system, frequency);
        AntennaResult tx = this.linkResult.txAntenna();
        AntennaResult rx = this.linkResult.rxAntenna();
        if (BS.isAWrapAroundBS()) {
            this.isWrapAround = true;
            this.basestation = BS.getCorresponding();
            this.basestation.setAntennaProperties(tx);
            tx.setPosition(this.basestation.getPosition().add(BS.getOffset()));
        } else {
            this.basestation = BS;
            this.basestation.setAntennaProperties(tx);
        }
        this.user = MS;
        this.user.setAntennaProperties(rx);
        this.linkResult.setTxRxDistance(Mathematics.distance(rx.getPosition(), tx.getPosition()));
        double txRxAzi = Mathematics.convertAngleToConfineToHorizontalDefinedRange(Mathematics.calculateKartesianAngle(rx.getPosition(), tx.getPosition()));
        double rxTxAzi = Mathematics.convertAngleToConfineToHorizontalDefinedRange(Mathematics.calculateKartesianAngle(tx.getPosition(), rx.getPosition()));
        this.linkResult.setTxRxAngle(txRxAzi);
        double txRxEle = Mathematics.calculateElevation(tx, rx);
        double azimuthTrial = Mathematics.convertAngleToConfineToHorizontalDefinedRange(this.settings.getMsAzimuthOffset().trial());
        rx.setRandomPanelOffsetAzimuth(azimuthTrial);
        if (this.settings.getMsAzimuthPointing() == IMT2020Mobile.AzimuthPointing.TOWARD_BS) {
            rx.setAzimuthCompensation(rxTxAzi);
            rx.setAzimuth(0.0);
        } else {
            rx.setAzimuth(rxTxAzi - azimuthTrial);
            rx.setAzimuthCompensation(azimuthTrial);
        }
        double elevationTrial = this.settings.getMsElevationOffset().trial();
        rx.setRandomPanelOffsetElevation(elevationTrial);
        if (this.settings.getMsElevationPointing() == IMT2020Mobile.ElevationPointing.TOWARD_BS) {
            rx.setElevationCompensation(-txRxEle);
            rx.setElevation(0.0);
        } else {
            rx.setElevationCompensation(0.0);
            rx.setElevation(-txRxEle);
        }
        rx.setTilt(0.0);
        azimuthTrial = Mathematics.convertAngleToConfineToHorizontalDefinedRange(this.settings.getBsAzimuthOffset().trial());
        if (this.settings.getBsAzimuthPointing() == IMT2020MacroBaseStation.AzimuthPointing.TOWARD_MS) {
            tx.setAzimuthCompensation(txRxAzi);
            tx.setAzimuth(0.0);
            tx.setRandomPanelOffsetAzimuth(0.0);
        } else {
            tx.setAzimuth(Mathematics.convertAngleToConfineToHorizontalDefinedRange(txRxAzi - azimuthTrial));
            tx.setAzimuthCompensation(azimuthTrial);
            tx.setRandomPanelOffsetAzimuth(azimuthTrial);
        }
        if (this.settings.getBsElevationPointing() == IMT2020MacroBaseStation.ElevationPointing.TOWARD_MS) {
            tx.setElevation(0.0);
            tx.setElevationCompensation(txRxEle);
        } else {
            tx.setElevation(txRxEle);
            tx.setElevationCompensation(0.0);
            tx.setRandomPanelOffsetElevation(this.basestation.getAntennaTilt());
        }
        tx.setTilt(this.basestation.getAntennaTilt());
        tx.setGain(this.basestation.getAntennaGain().evaluate(this.linkResult, tx));
        rx.setGain(this.user.getAntennaGain().evaluate(this.linkResult, rx));
        this.linkResult.assignLocalEnvironment(this.user.getEnvironments(), Direction.To_RX);
        this.linkResult.assignLocalEnvironment(this.basestation.getEnvironments(), Direction.To_TX);
        this.linkResult.trialTxRxInSameBuilding();
        this.linkResult.setValue(SystemPlugin.BANDWIDTH_CORRECTION, Mathematics.linear2dB((double)this.settings.getMaxRBsPrMS() / (double)this.settings.getMaxRBsPrBS()));
    }

    public IMT2020Settings getSettings() {
        return this.settings;
    }

    private double gainSum() {
        return this.linkResult.txAntenna().getGain() + this.linkResult.rxAntenna().getGain();
    }

    public BaseStation getBaseStation() {
        return this.basestation;
    }

    public double getEffectivePathloss() {
        return this.effectivePathLoss;
    }

    public MobileStation getUserTerminal() {
        return this.user;
    }

    public double getTxRxPathLoss() {
        return this.txRxPathLoss;
    }

    public double getDistance() {
        return this.linkResult.getTxRxDistance();
    }

    public LinkResult getLinkResult() {
        return this.linkResult;
    }

    public double calculateCurrentReceivePower_dBm() {
        if (this.totalReceivedPower != 0.0) {
            return this.totalReceivedPower;
        }
        double eff = this.getEffectivePathloss();
        double userSubCarriers = this.settings.getMaxRBsPrMS();
        double basestationSubCarriers = this.getBaseStation().getSubCarriersInUse();
        double fraction = userSubCarriers / basestationSubCarriers;
        double power_W = this.getBaseStation().calculateCurrentTransmitPower_Watt();
        double adjustedPower_W = power_W * fraction;
        double chPower = Mathematics.fromWatt2dBm(adjustedPower_W);
        this.totalReceivedPower = chPower - eff;
        return this.totalReceivedPower;
    }

    public String toString() {
        return "IMT-2020 DownLink: BS #" + this.getBaseStation().getBaseStationId() + " -> Mobile #" + this.getUserTerminal().getUserid() + " PL = " + this.getEffectivePathloss();
    }

    public void addAsCandidate() {
        if (this.isWrapAround) {
            this.linkResult.txAntenna().setPosition(this.basestation.getPosition());
        }
        this.basestation.addCandidate(this);
    }

    public boolean isWrapAroundLink() {
        return this.isWrapAround;
    }
}

