/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.imt2020downlink.simulation;

import org.seamcat.model.engines.InterferenceSimulationEngine;
import org.seamcat.model.simulation.result.DefaultInterfererImpl;
import org.seamcat.model.systems.imt2020downlink.simulation.Link;

class Interferer
extends DefaultInterfererImpl<Interferer> {
    private final int cellid;
    private final Link connection;

    public Interferer(int linkIndex, Link connection, double mcl) {
        super(linkIndex, connection.getBaseStation().getAntennaGain(), connection.getLinkResult(), mcl);
        this.cellid = connection.getBaseStation().getBaseStationId();
        if (connection.isWrapAroundLink()) {
            connection.getLinkResult().setValue(InterferenceSimulationEngine.SYSTEM_LINK_TYPE, "Secondary Link");
        }
        this.connection = connection;
    }

    @Override
    public boolean isSameTx(Interferer other) {
        return this.cellid == other.cellid;
    }

    @Override
    public String getRxName() {
        return this.connection.getUserTerminal().getName();
    }

    @Override
    public String getTxName() {
        return this.connection.getBaseStation().getName();
    }
}

