/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.imt2020downlink.simulation;

import java.util.ArrayList;
import java.util.List;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.system.SimulationInstance;
import org.seamcat.model.plugin.system.Space;
import org.seamcat.model.plugin.system.SystemSpaces;
import org.seamcat.model.plugin.system.optional.SectorPropertyType;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.systems.cellulargrid.HexagonCells;
import org.seamcat.model.systems.imt2020downlink.IMT2020DownLinkSystemPlugin;
import org.seamcat.model.systems.imt2020downlink.simulation.BaseStation;
import org.seamcat.model.systems.imt2020downlink.simulation.IMT2020DownLinkCalculations;
import org.seamcat.model.systems.imt2020downlink.simulation.IMT2020DownLinkVictim;
import org.seamcat.model.systems.imt2020downlink.simulation.IMT2020Settings;
import org.seamcat.model.systems.imt2020downlink.simulation.Interferer;
import org.seamcat.model.systems.imt2020downlink.simulation.Link;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.result.Results;

public class IMT2020DownLinkSimulation
implements SimulationInstance {
    private SystemSpaces systemSpaces;
    private IMT2020DownLinkSystemPlugin plugin;

    public IMT2020DownLinkSimulation(IMT2020DownLinkSystemPlugin plugin, SystemSpaces systemSpaces) {
        this.plugin = plugin;
        this.systemSpaces = systemSpaces;
    }

    @Override
    public void victimSimulation(VictimResultCollector collector) {
        Results pre = collector.getPreSimulationResults();
        List<Link> activeConnections = this.initializeSystem(pre, Point2D.ORIGIN);
        for (Link active : activeConnections) {
            collector.add(new IMT2020DownLinkVictim(collector.getPreSimulationResults(), active));
        }
        IMT2020DownLinkCalculations.calculateVictimResults(this.plugin.getSettings(), collector);
    }

    private List<Link> initializeSystem(Results pre, Point2D position) {
        double frequency = pre.findDoubleValue(IMT2020DownLinkSystemPlugin.SIMULATION_FREQUENCY);
        RadioSystem system = this.plugin.getSystem(null);
        List<Space> txSpaces = this.systemSpaces.getTxSpaces();
        List<Object> wrapAroundOffsets = new ArrayList();
        if (this.plugin.isUsingWrapAround()) {
            wrapAroundOffsets = HexagonCells.wrapAroundOffsets(this.plugin.getCellRadius(), this.plugin.getSectorSetup());
        }
        ArrayList<BaseStation> baseStations = new ArrayList<BaseStation>();
        IMT2020Settings settings = this.plugin.getSettings();
        for (int i = 0; i < txSpaces.size(); ++i) {
            String name;
            Space txSpace = txSpaces.get(i);
            Point2D bsPosition = position.add(txSpace.getSpace().getVertices().get(0));
            boolean refCell = txSpace.hasProperty(SectorPropertyType.REFERENCE_CELL);
            if (this.plugin.getSectorSetup().getSectors() == 1) {
                name = "BS Cell #" + (i + 1);
            } else {
                int cell = i / 3;
                int sector = 1 + i % 3;
                name = "BS Cell #" + cell;
                name = name + " Sector " + sector;
            }
            BaseStation baseStation = settings.create(name, i, refCell, bsPosition, frequency);
            baseStations.add(baseStation);
            for (Point2D point2D : wrapAroundOffsets) {
                baseStations.add(settings.createWrapAround(baseStation, point2D));
            }
        }
        return settings.positionMSsAndInitialConnectBS(system, baseStations, this.systemSpaces.getRxSpaces(), this.plugin.triSector(), position, frequency);
    }

    @Override
    public void interferingSystemSimulation(EventResult eventResult, InterferenceLink link, Point2D position) {
        Results pre = eventResult.getInterferingSystemResult(link).getPreSimulationResults();
        List<Link> activeConnections = this.initializeSystem(pre, position);
        for (Link active : activeConnections) {
            BaseStation bs = active.getBaseStation();
            Interferer interferer = new Interferer(link.linkIndex(), active, link.getCorrelationSettings().getMinimumCouplingLoss().trial());
            double txPower = Mathematics.fromWatt2dBm(bs.calculateCurrentTransmitPower_Watt());
            interferer.getLinkResult().setTxPower(txPower);
            eventResult.getInterferingSystemResult(link).add(interferer);
        }
    }

    @Override
    public void interferingSystemSimulation(EventResult eventResult, InterferenceLink link, Point2D position, LinkResult positionFromCoLocation) {
    }

    @Override
    public void interferedVictimSimulation(EventResult eventResult) {
        IMT2020DownLinkCalculations.calculateInterferedVictim(eventResult, this.plugin.getSettings());
    }

    @Override
    public List<Victim> getResultingVictims(VictimResultCollector vCollector) {
        ArrayList<Victim> victims = new ArrayList<Victim>();
        for (Victim victim : vCollector.getVictims()) {
            IMT2020DownLinkVictim v = (IMT2020DownLinkVictim)victim;
            if (!v.isConnectedToReferenceCell()) continue;
            victims.add(v);
        }
        return victims;
    }

    @Override
    public void postEvent(EventResult eventResult) {
        VictimResultCollector vCollector = eventResult.getVictimResult();
        IMT2020DownLinkCalculations.averageResults(vCollector, this.getResultingVictims(vCollector));
    }
}

