/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.imt2020downlink.simulation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.systems.imt2020downlink.IMT2020DownLinkSystemPlugin;
import org.seamcat.model.systems.imt2020downlink.simulation.IMT2020DownLinkVictim;
import org.seamcat.model.systems.imt2020downlink.simulation.IMT2020Settings;
import org.seamcat.simulation.cellular.OFDMADownLinkVictimSystemSimulation;

class IMT2020DownLinkCalculations {
    IMT2020DownLinkCalculations() {
    }

    static void calculateVictimResults(IMT2020Settings settings, VictimResultCollector collector) {
        settings.collectBitRates(IMT2020DownLinkSystemPlugin.AVGAchievedBitRateSystem, IMT2020DownLinkSystemPlugin.AchievedBitRateRefCell, collector);
        LinkedHashMap<VectorDef, List<Double>> vectors = new LinkedHashMap<VectorDef, List<Double>>();
        for (Victim victim : collector.getVictims()) {
            if (!(victim instanceof IMT2020DownLinkVictim)) continue;
            IMT2020DownLinkVictim v = (IMT2020DownLinkVictim)victim;
            IMT2020DownLinkCalculations.handle(vectors, v);
        }
        for (Map.Entry entry : vectors.entrySet()) {
            collector.add((VectorDef)entry.getKey(), (List)entry.getValue());
        }
    }

    private static void handle(Map<VectorDef, List<Double>> vectors, IMT2020DownLinkVictim victim) {
        if (victim.isConnectedToReferenceCell()) {
            IMT2020DownLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.FREQUENCY, victim.getUEFrequency());
            IMT2020DownLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.BIT_RATE_ACHIEVED, victim.getAchievedBitrate());
            IMT2020DownLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.RECEIVED_POWER, victim.getReceivePower());
            IMT2020DownLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.SINR_ACHIEVED, victim.getSinr());
            IMT2020DownLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.PATH_LOSS, victim.getLinkResult().getTxRxPathLoss());
            IMT2020DownLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.EFFECTIVE_PATH_LOSS, victim.getLinkResult().getEffectiveTxRxPathLoss());
            IMT2020DownLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.INTERFERENCE_POWER, victim.getInterferencePower());
            IMT2020DownLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.CURRENT_TRANSMIT_POWER, victim.getCurrentTransmitPower());
            IMT2020DownLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.INTER_SYSTEM_INTERFERENCE, victim.getInterSystemInterference());
        } else {
            IMT2020DownLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.FREQUENCY_ALL, victim.getUEFrequency());
            IMT2020DownLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.BIT_RATE_ACHIEVED_ALL, victim.getAchievedBitrate());
            IMT2020DownLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.RECEIVED_POWER_ALL, victim.getReceivePower());
            IMT2020DownLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.SINR_ACHIEVED_ALL, victim.getSinr());
            IMT2020DownLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.PATH_LOSS_ALL, victim.getLinkResult().getTxRxPathLoss());
            IMT2020DownLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.EFFECTIVE_PATH_LOSS_ALL, victim.getLinkResult().getEffectiveTxRxPathLoss());
            IMT2020DownLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.INTERFERENCE_POWER_ALL, victim.getInterferencePower());
            IMT2020DownLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.CURRENT_TRANSMIT_POWER_ALL, victim.getCurrentTransmitPower());
            IMT2020DownLinkCalculations.append(vectors, OFDMADownLinkVictimSystemSimulation.INTER_SYSTEM_INTERFERENCE_ALL, victim.getInterSystemInterference());
        }
    }

    private static void append(Map<VectorDef, List<Double>> vectors, VectorDef def, double value) {
        List<Double> values = vectors.get(def);
        if (values == null) {
            values = new ArrayList<Double>();
            vectors.put(def, values);
        }
        values.add(value);
    }

    static void calculateInterferedVictim(EventResult eventResult, IMT2020Settings settings) {
        VictimResultCollector collector = eventResult.getVictimResult();
        settings.collectBitRates(IMT2020DownLinkSystemPlugin.AVGInterferedBitRateSystem, IMT2020DownLinkSystemPlugin.InterferedBitRateRefCell, collector);
        double avg = 0.0;
        double refSum = 0.0;
        int refSize = 0;
        double sum = 0.0;
        int size = 0;
        for (Victim victim : collector.getVictims()) {
            if (!(victim instanceof IMT2020DownLinkVictim)) continue;
            IMT2020DownLinkVictim v = (IMT2020DownLinkVictim)victim;
            double sinrW = Mathematics.dB2Linear(v.getSinr());
            sum += sinrW;
            if (v.isConnectedToReferenceCell()) {
                ++refSize;
                refSum += sinrW;
            }
            ++size;
        }
        avg = size == 0 ? 0.0 : sum / (double)size;
        collector.add(IMT2020DownLinkSystemPlugin.SINR_SYSTEM, Mathematics.linear2dB(avg));
        refSum = refSize == 0 ? 0.0 : refSum / (double)refSize;
        collector.add(IMT2020DownLinkSystemPlugin.SINR_REFCELL, Mathematics.linear2dB(refSum));
    }

    static void averageResults(VictimResultCollector vCollector, List<Victim> resultingVictims) {
        if (!resultingVictims.isEmpty()) {
            for (VectorDef def : vCollector.getVectorDefinitions()) {
                if (!def.name().startsWith("iRSS Unwanted") && !def.name().startsWith("iRSS Blocking")) continue;
                vCollector.add(def, Mathematics.linear2dB(Mathematics.dB2Linear(vCollector.get(def)) / (double)resultingVictims.size()));
            }
        }
    }
}

