/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.cellulargrid;

import java.util.ArrayList;
import java.util.List;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.geometry.Polygon2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.system.Space;
import org.seamcat.model.plugin.system.SystemSpaces;
import org.seamcat.model.plugin.system.optional.SectorPropertyDescription;
import org.seamcat.model.plugin.system.optional.SectorPropertyType;
import org.seamcat.simulation.cellular.GridPositionCalculator;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;

public class HexagonCells {
    public static final SectorPropertyDescription REF_CELL = new SectorPropertyDescription("Reference cell");
    public static final SectorPropertyDescription CELL = new SectorPropertyDescription("Cell");
    public static final SectorPropertyDescription BS = new SectorPropertyDescription("Base Station");

    public static SystemSpaces generate(boolean uplink, double cellRadius, HybridSystemPlugin.TierSetup tier, HybridSystemPlugin.SectorSetup setup, int referenceCell) {
        ArrayList<Space> spaces = new ArrayList<Space>();
        boolean msIsRx = !uplink;
        int cellSites = tier.getCellSites();
        double d = HexagonCells.getInterCellDistance(cellRadius, setup);
        switch (setup) {
            case SingleSector: {
                for (int i = 0; i < cellSites; ++i) {
                    Point2D point = GridPositionCalculator.ppg2(i, Point2D.ORIGIN, d);
                    ArrayList<Point2D> hexagon = new ArrayList<Point2D>(6);
                    for (int k = 0; k < 6; ++k) {
                        double angle = 360 - 60 * k;
                        hexagon.add(point.add(Mathematics.cosD(angle) * cellRadius, Mathematics.sinD(angle) * cellRadius));
                    }
                    boolean refCell = referenceCell == i;
                    SectorPropertyType type = refCell ? SectorPropertyType.REFERENCE_CELL : SectorPropertyType.CELL;
                    spaces.add(new Space(new Polygon2D(hexagon), msIsRx, HexagonCells.desc(refCell, true), type));
                    spaces.add(new Space(new Polygon2D(point), !msIsRx, HexagonCells.desc(refCell, false), type));
                }
                break;
            }
            case TriSector3GPP2: {
                for (int i = 0; i < cellSites; ++i) {
                    Point2D point = GridPositionCalculator.ppg2(i, Point2D.ORIGIN, d);
                    ArrayList<Point2D> hexagon = new ArrayList<Point2D>(6);
                    for (int k = 0; k < 6; ++k) {
                        double angle = 360 - 60 * k;
                        hexagon.add(point.add(Mathematics.cosD(angle) * cellRadius, Mathematics.sinD(angle) * cellRadius));
                    }
                    ArrayList<Point2D> sector1 = new ArrayList<Point2D>(4);
                    sector1.add(point);
                    sector1.add((Point2D)hexagon.get(0));
                    sector1.add((Point2D)hexagon.get(1));
                    sector1.add((Point2D)hexagon.get(2));
                    boolean refCell = referenceCell == i;
                    SectorPropertyType type = refCell ? SectorPropertyType.REFERENCE_CELL : SectorPropertyType.CELL;
                    spaces.add(new Space(new Polygon2D(sector1), msIsRx, HexagonCells.desc(refCell, true), type));
                    spaces.add(new Space(new Polygon2D(point), !msIsRx, HexagonCells.desc(refCell, false), type));
                    ArrayList<Point2D> sector2 = new ArrayList<Point2D>(4);
                    sector2.add(point);
                    sector2.add((Point2D)hexagon.get(2));
                    sector2.add((Point2D)hexagon.get(3));
                    sector2.add((Point2D)hexagon.get(4));
                    spaces.add(new Space(new Polygon2D(sector2), msIsRx, HexagonCells.desc(refCell, true), type));
                    spaces.add(new Space(new Polygon2D(point), !msIsRx, HexagonCells.desc(refCell, false), type));
                    ArrayList<Point2D> sector3 = new ArrayList<Point2D>(4);
                    sector3.add(point);
                    sector3.add((Point2D)hexagon.get(4));
                    sector3.add((Point2D)hexagon.get(5));
                    sector3.add((Point2D)hexagon.get(0));
                    spaces.add(new Space(new Polygon2D(sector3), msIsRx, HexagonCells.desc(refCell, true), type));
                    spaces.add(new Space(new Polygon2D(point), !msIsRx, HexagonCells.desc(refCell, false), type));
                }
                break;
            }
            case TriSector3GPP: {
                for (int i = 0; i < cellSites; ++i) {
                    Point2D point = GridPositionCalculator.standard(i, Point2D.ORIGIN, d);
                    ArrayList<Point2D> hexagon = new ArrayList<Point2D>(6);
                    for (int k = 0; k < 6; ++k) {
                        double angle = 360 - 60 * k;
                        hexagon.add(point.add(Mathematics.cosD(angle) * cellRadius, Mathematics.sinD(angle) * cellRadius));
                    }
                    Point2D center1 = new Point2D(cellRadius, 0.0);
                    Point2D center2 = new Point2D(Mathematics.cosD(120.0) * cellRadius, Mathematics.sinD(120.0) * cellRadius);
                    Point2D center3 = new Point2D(Mathematics.cosD(240.0) * cellRadius, Mathematics.sinD(240.0) * cellRadius);
                    ArrayList<Point2D> sector1 = new ArrayList<Point2D>(6);
                    ArrayList<Point2D> sector2 = new ArrayList<Point2D>(6);
                    ArrayList<Point2D> sector3 = new ArrayList<Point2D>(6);
                    for (Point2D point2D : hexagon) {
                        sector1.add(point2D.add(center1));
                        sector2.add(point2D.add(center2));
                        sector3.add(point2D.add(center3));
                    }
                    boolean refCell = referenceCell == i;
                    SectorPropertyType type = refCell ? SectorPropertyType.REFERENCE_CELL : SectorPropertyType.CELL;
                    spaces.add(new Space(new Polygon2D(sector1), msIsRx, HexagonCells.desc(refCell, true), type));
                    spaces.add(new Space(new Polygon2D(point), !msIsRx, HexagonCells.desc(refCell, false), type));
                    spaces.add(new Space(new Polygon2D(sector2), msIsRx, HexagonCells.desc(refCell, true), type));
                    spaces.add(new Space(new Polygon2D(point), !msIsRx, HexagonCells.desc(refCell, false), type));
                    spaces.add(new Space(new Polygon2D(sector3), msIsRx, HexagonCells.desc(refCell, true), type));
                    spaces.add(new Space(new Polygon2D(point), !msIsRx, HexagonCells.desc(refCell, false), type));
                }
                break;
            }
        }
        return new SystemSpaces(spaces);
    }

    public static List<Point2D> wrapAroundOffsets(double cellRadius, HybridSystemPlugin.SectorSetup setup) {
        double D = HexagonCells.getInterCellDistance(cellRadius, setup);
        ArrayList<Point2D> offsets = new ArrayList<Point2D>();
        if (setup == HybridSystemPlugin.SectorSetup.TriSector3GPP) {
            offsets.add(new Point2D(3.5 * D, 1.5 * D * Mathematics.SQRT3));
            offsets.add(new Point2D(0.5 * D, -2.5 * D * Mathematics.SQRT3));
            offsets.add(new Point2D(4.0 * D, -D * Mathematics.SQRT3));
            offsets.add(new Point2D(-0.5 * D, 2.5 * D * Mathematics.SQRT3));
            offsets.add(new Point2D(-4.0 * D, D * Mathematics.SQRT3));
            offsets.add(new Point2D(-3.5 * D, -1.5 * D * Mathematics.SQRT3));
        } else {
            offsets.add(new Point2D(3.0 * D / Mathematics.SQRT3, 4.0 * D));
            offsets.add(new Point2D(7.5 * D / Mathematics.SQRT3, D / 2.0));
            offsets.add(new Point2D(4.5 * D / Mathematics.SQRT3, -7.0 * D / 2.0));
            offsets.add(new Point2D(-7.5 * D / Mathematics.SQRT3, -D / 2.0));
            offsets.add(new Point2D(-3.0 * D / Mathematics.SQRT3, -4.0 * D));
            offsets.add(new Point2D(-4.5 * D / Mathematics.SQRT3, 7.0 * D / 2.0));
        }
        return offsets;
    }

    private static double getInterCellDistance(double cellRadius, HybridSystemPlugin.SectorSetup setup) {
        double interCellDistance = setup != HybridSystemPlugin.SectorSetup.TriSector3GPP ? cellRadius * Mathematics.SQRT3 : cellRadius * 3.0;
        return interCellDistance;
    }

    private static SectorPropertyDescription desc(boolean refCell, boolean ms) {
        return refCell ? REF_CELL : (ms ? CELL : BS);
    }
}

