/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.cdma;

import java.util.ArrayList;
import java.util.List;
import org.seamcat.function.DiscreteFunction;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.plugin.antenna.HorizontalVerticalInput;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.model.types.CDMALLD;
import org.seamcat.model.types.CDMALLDPath;
import org.seamcat.model.types.CDMALLDPoint;
import org.seamcat.model.types.result.DescriptionImpl;
import org.seamcat.plugin.AntennaGainConfiguration;

public class Defaults {
    public static CDMALLD defaultDownLink() {
        CDMALLD prototype = Factory.prototype(CDMALLD.class);
        Factory.when(prototype.source()).thenReturn("Lucent Technologies, INC");
        Factory.when(prototype.frequency()).thenReturn(850.0);
        Factory.when(prototype.system()).thenReturn("W-CDMA/UMTS");
        Factory.when(prototype.systemType()).thenReturn("downlink");
        Factory.when(prototype.targetPct()).thenReturn("0.7");
        Factory.when(prototype.targetType()).thenReturn("BLER");
        List paths = Factory.when(prototype.paths()).thenReturn(new ArrayList());
        CDMALLDPath path1 = Factory.prototype(CDMALLDPath.class);
        Factory.when(path1.caption()).thenReturn("UMTS 12.2k Voice, 850 MHz, 1-path Rayleigh");
        Factory.when(path1.no()).thenReturn(1);
        List points1 = Factory.when(path1.points()).thenReturn(new ArrayList());
        points1.add(Defaults.point(-26.0, 12.0, 100.0));
        points1.add(Defaults.point(-23.1, 12.0, 30.0));
        points1.add(Defaults.point(-21.2, 12.0, 3.0));
        points1.add(Defaults.point(-30.3, 12.0, 0.0));
        points1.add(Defaults.point(-23.0, 9.0, 100.0));
        points1.add(Defaults.point(-20.0, 9.0, 30.0));
        points1.add(Defaults.point(-18.3, 9.0, 3.0));
        points1.add(Defaults.point(-27.2, 9.0, 0.0));
        points1.add(Defaults.point(-19.9, 6.0, 100.0));
        points1.add(Defaults.point(-17.0, 6.0, 30.0));
        points1.add(Defaults.point(-15.8, 6.0, 3.0));
        points1.add(Defaults.point(-24.4, 6.0, 0.0));
        points1.add(Defaults.point(-16.9, 3.0, 100.0));
        points1.add(Defaults.point(-14.0, 3.0, 30.0));
        points1.add(Defaults.point(-13.0, 3.0, 3.0));
        points1.add(Defaults.point(-21.3, 3.0, 0.0));
        points1.add(Defaults.point(-13.9, 0.0, 100.0));
        points1.add(Defaults.point(-11.1, 0.0, 30.0));
        points1.add(Defaults.point(-10.3, 0.0, 3.0));
        points1.add(Defaults.point(-18.3, 0.0, 0.0));
        points1.add(Defaults.point(-10.8, -3.0, 100.0));
        points1.add(Defaults.point(-8.3, -3.0, 30.0));
        points1.add(Defaults.point(-8.0, -3.0, 3.0));
        points1.add(Defaults.point(-15.3, -3.0, 0.0));
        points1.add(Defaults.point(-7.9, -6.0, 100.0));
        points1.add(Defaults.point(-5.3, -6.0, 30.0));
        points1.add(Defaults.point(-5.3, -6.0, 3.0));
        points1.add(Defaults.point(-12.4, -6.0, 0.0));
        paths.add(Factory.build(path1));
        CDMALLDPath path2 = Factory.prototype(CDMALLDPath.class);
        Factory.when(path2.caption()).thenReturn("UMTS 12.2k Voice, 850 MHz, 2-path Rayleigh (0, -3dB)");
        Factory.when(path2.no()).thenReturn(2);
        List points2 = Factory.when(path2.points()).thenReturn(new ArrayList());
        points2.add(Defaults.point(-19.5, 12.0, 100.0));
        points2.add(Defaults.point(-18.9, 12.0, 30.0));
        points2.add(Defaults.point(-21.4, 12.0, 3.0));
        points2.add(Defaults.point(-30.3, 12.0, 0.0));
        points2.add(Defaults.point(-19.0, 9.0, 100.0));
        points2.add(Defaults.point(-18.6, 9.0, 30.0));
        points2.add(Defaults.point(-20.4, 9.0, 3.0));
        points2.add(Defaults.point(-27.2, 9.0, 0.0));
        points2.add(Defaults.point(-18.2, 6.0, 100.0));
        points2.add(Defaults.point(-17.6, 6.0, 30.0));
        points2.add(Defaults.point(-18.9, 6.0, 3.0));
        points2.add(Defaults.point(-24.4, 6.0, 0.0));
        points2.add(Defaults.point(-16.8, 3.0, 100.0));
        points2.add(Defaults.point(-16.1, 3.0, 30.0));
        points2.add(Defaults.point(-16.8, 3.0, 3.0));
        points2.add(Defaults.point(-21.3, 3.0, 0.0));
        points2.add(Defaults.point(-14.9, 0.0, 100.0));
        points2.add(Defaults.point(-14.1, 0.0, 30.0));
        points2.add(Defaults.point(-14.3, 0.0, 3.0));
        points2.add(Defaults.point(-18.3, 0.0, 0.0));
        points2.add(Defaults.point(-12.7, -3.0, 100.0));
        points2.add(Defaults.point(-11.3, -3.0, 30.0));
        points2.add(Defaults.point(-11.5, -3.0, 3.0));
        points2.add(Defaults.point(-15.3, -3.0, 0.0));
        points2.add(Defaults.point(-9.9, -6.0, 100.0));
        points2.add(Defaults.point(-8.5, -6.0, 30.0));
        points2.add(Defaults.point(-8.8, -6.0, 3.0));
        points2.add(Defaults.point(-12.4, -6.0, 0.0));
        paths.add(Factory.build(path2));
        return Factory.build(prototype);
    }

    public static CDMALLD defaultUpLink() {
        CDMALLD prototype = Factory.prototype(CDMALLD.class);
        Factory.when(prototype.source()).thenReturn("QUALCOMM Europe");
        Factory.when(prototype.frequency()).thenReturn(835.0);
        Factory.when(prototype.system()).thenReturn("W-CDMA/UMTS");
        Factory.when(prototype.systemType()).thenReturn("uplink");
        Factory.when(prototype.targetPct()).thenReturn("1");
        Factory.when(prototype.targetType()).thenReturn("FER");
        List paths = Factory.when(prototype.paths()).thenReturn(new ArrayList());
        CDMALLDPath path1 = Factory.prototype(CDMALLDPath.class);
        Factory.when(path1.caption()).thenReturn("Multi-path 1");
        Factory.when(path1.no()).thenReturn(1);
        List points1 = Factory.when(path1.points()).thenReturn(new ArrayList());
        points1.add(Defaults.point(8.85, 0.0, 100.0));
        points1.add(Defaults.point(8.25, 0.0, 30.0));
        points1.add(Defaults.point(7.92, 0.0, 30.0));
        points1.add(Defaults.point(7.57, 0.0, 0.0));
        paths.add(Factory.build(path1));
        CDMALLDPath path2 = Factory.prototype(CDMALLDPath.class);
        Factory.when(path2.caption()).thenReturn("Multi-path 2");
        Factory.when(path2.no()).thenReturn(2);
        List points2 = Factory.when(path2.points()).thenReturn(new ArrayList());
        points2.add(Defaults.point(8.64, 0.0, 100.0));
        points2.add(Defaults.point(8.23, 0.0, 30.0));
        points2.add(Defaults.point(8.17, 0.0, 30.0));
        points2.add(Defaults.point(7.57, 0.0, 0.0));
        paths.add(Factory.build(path2));
        return Factory.build(prototype);
    }

    private static CDMALLDPoint point(double ecior, double geo, double speed) {
        CDMALLDPoint prototype = Factory.prototype(CDMALLDPoint.class);
        Factory.when(prototype.ecior()).thenReturn(ecior);
        Factory.when(prototype.geo()).thenReturn(geo);
        Factory.when(prototype.speed()).thenReturn(speed);
        return Factory.build(prototype);
    }

    public static AntennaGain defaultBaseStationGain() {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        points.add(new Point2D(0.0, 0.0));
        points.add(new Point2D(10.0, 0.0));
        points.add(new Point2D(20.0, -0.182));
        points.add(new Point2D(30.0, -0.364));
        points.add(new Point2D(40.0, -1.37));
        points.add(new Point2D(50.0, -2.73));
        points.add(new Point2D(60.0, -3.82));
        points.add(new Point2D(70.0, -5.27));
        points.add(new Point2D(80.0, -7.18));
        points.add(new Point2D(90.0, -9.36));
        points.add(new Point2D(100.0, -11.36));
        points.add(new Point2D(110.0, -13.73));
        points.add(new Point2D(120.0, -15.55));
        points.add(new Point2D(130.0, -17.36));
        points.add(new Point2D(140.0, -18.64));
        points.add(new Point2D(150.0, -20.364));
        points.add(new Point2D(160.0, -23.0));
        points.add(new Point2D(170.0, -24.27));
        points.add(new Point2D(180.0, -23.18));
        points.add(new Point2D(190.0, -24.27));
        points.add(new Point2D(200.0, -23.0));
        points.add(new Point2D(210.0, -20.364));
        points.add(new Point2D(220.0, -18.64));
        points.add(new Point2D(230.0, -17.36));
        points.add(new Point2D(240.0, -15.55));
        points.add(new Point2D(250.0, -13.73));
        points.add(new Point2D(260.0, -11.36));
        points.add(new Point2D(270.0, -9.36));
        points.add(new Point2D(280.0, -7.18));
        points.add(new Point2D(290.0, -5.27));
        points.add(new Point2D(300.0, -3.82));
        points.add(new Point2D(310.0, -2.73));
        points.add(new Point2D(320.0, -1.37));
        points.add(new Point2D(330.0, -0.364));
        points.add(new Point2D(340.0, -0.182));
        points.add(new Point2D(350.0, 0.0));
        points.add(new Point2D(360.0, 0.0));
        DiscreteFunction horizontal = new DiscreteFunction(points);
        HorizontalVerticalInput prototype = Factory.prototype(HorizontalVerticalInput.class);
        Factory.when(prototype.horizontal()).thenReturn(Factory.results().optional(true, horizontal));
        ArrayList<Point2D> vPoints = new ArrayList<Point2D>();
        vPoints.add(new Point2D(-90.0, 0.0));
        vPoints.add(new Point2D(90.0, 0.0));
        DiscreteFunction vertical = new DiscreteFunction(vPoints);
        Factory.when(prototype.vertical()).thenReturn(Factory.results().optional(false, vertical));
        AntennaGain<HorizontalVerticalInput> antenna = Factory.antennaGainFactory().getHorizontalVerticalAntenna(Factory.build(prototype), 15.0);
        AntennaGainConfiguration configuration = (AntennaGainConfiguration)antenna;
        configuration.setDescription(new DescriptionImpl("3GPP Tri-Sector (horizontal only)", "3GPP 3-sector (60deg)"));
        return configuration;
    }
}

