/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.cdma;

import org.seamcat.model.plugin.Config;
import org.seamcat.model.systems.cdma.Defaults;
import org.seamcat.model.types.CDMALLD;

public interface CDMAGeneralSettings {
    public static final double receiverNoiseFigure = 8.0;
    public static final double handoverMargin = 4.0;
    public static final double callDropThreshold = 3.0;
    public static final double voiceBitRate = 9.6;
    public static final double bandwidth = 3.84;
    public static final double minimumCouplingLoss = 70.0;
    public static final double voiceActivityFactor = 1.0;
    public static final CDMALLD lld = Defaults.defaultDownLink();

    @Config(order=1, name="Receiver noise figure", unit="dB")
    public double receiverNoiseFigure();

    @Config(order=2, name="Handover margin", unit="dB")
    public double handoverMargin();

    @Config(order=3, name="Call drop threshold", unit="dB")
    public double callDropThreshold();

    @Config(order=4, name="Voice bit rate", unit="kbps")
    public double voiceBitRate();

    @Config(order=5, name="Reference bandwidth", unit="MHz")
    public double bandwidth();

    @Config(order=6, name="Minimum coupling loss", unit="dB")
    public double minimumCouplingLoss();

    @Config(order=7, name="Voice activity factor")
    public double voiceActivityFactor();

    @Config(order=8, name="LLD: ")
    public CDMALLD lld();
}

