/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.aggregate;

import java.util.List;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.plugin.system.Context;
import org.seamcat.model.plugin.system.SimulationInstance;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.plugin.system.SystemSpaces;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.systems.aggregate.AggregateSectorShapes;
import org.seamcat.model.systems.aggregate.AggregateSystemPlugin;
import org.seamcat.model.types.InterferenceLink;

class AggregateSimulationInstance
implements SimulationInstance {
    private SimulationInstance simulationInstance;

    AggregateSimulationInstance(Context context, AggregateSystemPlugin plugin, SystemSpaces sectorShapes) {
        AggregateSectorShapes aggregateSectorShapes = (AggregateSectorShapes)sectorShapes;
        List<SystemPlugin> components = plugin.getComponents();
        int index = context.isVictim() ? plugin.getVictimSystemIndex() : plugin.getInterferenceLinkSystemIndex(context.getInterferenceLink());
        this.simulationInstance = components.get(index).simulationInstance(context, aggregateSectorShapes.getAggregateShapes().get(index));
    }

    @Override
    public void victimSimulation(VictimResultCollector collector) {
        this.simulationInstance.victimSimulation(collector);
    }

    @Override
    public void interferingSystemSimulation(EventResult eventResult, InterferenceLink link, Point2D position) {
        this.simulationInstance.interferingSystemSimulation(eventResult, link, position);
    }

    @Override
    public void interferingSystemSimulation(EventResult eventResult, InterferenceLink link, Point2D position, LinkResult positionFromCoLocation) {
        this.simulationInstance.interferingSystemSimulation(eventResult, link, position, positionFromCoLocation);
    }

    @Override
    public void interferedVictimSimulation(EventResult eventResult) {
        this.simulationInstance.interferedVictimSimulation(eventResult);
    }

    @Override
    public List<Victim> getResultingVictims(VictimResultCollector vCollector) {
        return this.simulationInstance.getResultingVictims(vCollector);
    }

    @Override
    public void postEvent(EventResult eventResult) {
        this.simulationInstance.postEvent(eventResult);
    }
}

