/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.seamcat.function.DiscreteFunction;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.distributions.StairDistributionImpl;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.BlockingMask;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.functions.EmissionMask;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.MaskFunction;
import org.seamcat.model.generic.PathLossCorrelationUI;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.systems.ofdma.CellularBastStation;
import org.seamcat.model.systems.ofdma.OFDMADownLinkGeneralTab;
import org.seamcat.model.systems.ofdma.OFDMAMobile;
import org.seamcat.model.systems.ofdma.OFDMAUpLinkGeneralTab;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.model.types.LocalEnvironment;
import org.seamcat.model.types.Receiver;
import org.seamcat.model.types.Transmitter;
import org.seamcat.plugin.AntennaGainConfiguration;
import org.seamcat.presentation.systems.CellularPosition;
import org.seamcat.simulation.cellular.BaseStation;
import org.seamcat.simulation.cellular.MobileStation;
import org.seamcat.simulation.cellular.PathLossCorrelation;
import org.seamcat.simulation.cellular.ofdma.OFDMADownLink;
import org.seamcat.simulation.cellular.ofdma.OFDMASettings;
import org.seamcat.simulation.cellular.ofdma.OFDMAUpLink;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;

public class UIToModelConverter {
    public static MobileStation convert(OFDMAMobile mobile) {
        return new MobileStation(mobile.antennaHeight(), mobile.antennaGain(), new StairDistributionImpl(new DiscreteFunction(Arrays.asList(new Point2D(0.0, 0.25), new Point2D(3.0, 0.5), new Point2D(30.0, 0.75), new Point2D(100.0, 1.0)))));
    }

    public static void handlePosition(HybridSystemPlugin layout, CellularPosition position) {
        layout.setCellRadius(position.cellRadius());
        layout.setGenerateWrapAround(position.generateWrapAround());
        layout.setIndexOfReferenceCell(position.referenceCellId());
        layout.setReferenceSector(position.referenceSector());
        layout.setMeasureInterferenceFromEntireCluster(position.measureFromEntireCluster());
        layout.setSectorSetup(position.sectorType());
        layout.setTierSetup(position.tiers());
        layout.setSystemLayout(position.layout());
    }

    public static OFDMASettings convert(OFDMAUpLinkGeneralTab general) {
        OFDMASettings result = new OFDMASettings(general.generalSettings().bitRateMapping());
        result.setBandwidthOfResourceBlock(general.generalSettings().bandwidthResourceBlock());
        result.setMaxSubCarriersPerBaseStation(general.generalSettings().maxSubcarriersBs());
        result.setNumberOfSubCarriersPerMobileStation(general.generalSettings().maxSubcarriersMs());
        PathLossCorrelationUI plUI = general.pathLossCorrelation();
        PathLossCorrelation pl = new PathLossCorrelation(plUI.usePathLossCorrelation(), plUI.pathLossVariance(), plUI.correlationFactor());
        result.setPathLossCorrelation(pl);
        OFDMAUpLink uplink = new OFDMAUpLink();
        uplink.setBalancingFactor(general.ofdmaUpLink().getBalancingFactor());
        uplink.setMaximumAllowedTransmitPowerOfMS(general.ofdmaUpLink().getMaximumAllowedTransmitPowerOfMS());
        uplink.setMinimumTransmitPowerOfMS(general.ofdmaUpLink().getMinimumTransmitPowerOfMS());
        uplink.setPowerScalingThreshold(general.ofdmaUpLink().getPowerScalingThreshold());
        uplink.setUseNumberOfActiveMsPerBs(general.ueDistribution().numberOfActiveMsPerBs().isRelevant());
        uplink.setNumberOfActiveMsPerBs(general.ueDistribution().numberOfActiveMsPerBs().getValue());
        uplink.setFrequencyScheduleing(general.ueDistribution().probabilities());
        result.setUpLinkSettings(uplink);
        return result;
    }

    public static OFDMASettings convert(OFDMADownLinkGeneralTab general) {
        OFDMASettings result = new OFDMASettings(general.generalSettings().bitRateMapping());
        result.setBandwidthOfResourceBlock(general.generalSettings().bandwidthResourceBlock());
        result.setMaxSubCarriersPerBaseStation(general.generalSettings().maxSubcarriersBs());
        result.setNumberOfSubCarriersPerMobileStation(general.generalSettings().maxSubcarriersMs());
        PathLossCorrelationUI plUI = general.pathLossCorrelation();
        PathLossCorrelation pl = new PathLossCorrelation(plUI.usePathLossCorrelation(), plUI.pathLossVariance(), plUI.correlationFactor());
        result.setPathLossCorrelation(pl);
        OFDMADownLink downlink = new OFDMADownLink();
        downlink.setBSMaximumTransmitPower(general.ofdmaDownLink().bsMaximumTransmitPower());
        result.setDownLinkSettings(downlink);
        return result;
    }

    public static Receiver getDmaReceiver(double stdDe, double targetINR, double noiseFigure, BlockingMask mask, double bandwidth, List<LocalEnvironment> environments, AntennaGain gain, Distribution height) {
        Function pseudoMask;
        if (mask.getFunction().isConstant()) {
            pseudoMask = Factory.functionFactory().constantFunction(UIToModelConverter.maskValue(mask.getFunction().getConstant(), noiseFigure, bandwidth, stdDe, targetINR));
        } else {
            ArrayList<Point2D> pseudoMaskPoints = new ArrayList<Point2D>();
            for (Point2D maskPoint : mask.getFunction().getPoints()) {
                pseudoMaskPoints.add(new Point2D(maskPoint.getX(), UIToModelConverter.maskValue(maskPoint.getY(), noiseFigure, bandwidth, stdDe, targetINR)));
            }
            pseudoMask = Factory.functionFactory().discreteFunction(pseudoMaskPoints);
        }
        return new Receiver(mask, bandwidth, environments, gain, height, pseudoMask);
    }

    private static double maskValue(double IoobStandard, double noiseFigure, double bandwidth, double standardDe, double targetINR) {
        if (IoobStandard < 0.0) {
            double IoobTarget = IoobStandard - standardDe + 10.0 * Math.log10(Math.pow(10.0, targetINR / 10.0) + 1.0);
            double k = 1.38E-23;
            double T2 = 293.0;
            double B = bandwidth;
            double F = noiseFigure;
            double ktTBF = 10.0 * Math.log10(k * T2 * B * 1000000.0) + F + 30.0;
            return IoobTarget - ktTBF - targetINR;
        }
        return IoobStandard;
    }

    public static Transmitter getDmaTransmitter(Distribution height, EmissionMask emissionMask, MaskFunction emissionFloor, boolean usingFloor, double bandwidth, Bounds bandwidthBounds, List<LocalEnvironment> environments, AntennaGainConfiguration gain) {
        return new Transmitter(emissionMask, emissionFloor, usingFloor, bandwidth, bandwidthBounds, environments, gain, height, 0.0, false);
    }

    public static BaseStation convert(CellularBastStation bs) {
        return new BaseStation(bs.antennaHeight(), bs.antennaTilt(), bs.antennaGain());
    }
}

