/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.propagation;

import org.seamcat.model.propagation.LongleyRice_mod;
import org.seamcat.model.propagation.Param;
import org.seamcat.model.propagation.Param2;
import org.seamcat.model.simulation.result.LinkResult;

class Stat {
    Stat() {
    }

    public static double querfi(double q) {
        double c0 = 2.515516698;
        double c1 = 0.802853;
        double c2 = 0.010328;
        double d1 = 1.432788;
        double d2 = 0.189269;
        double d3 = 0.001308;
        double x = 0.5 - q;
        double t = Math.max(0.5 - Math.abs(x), 1.0E-6);
        t = Math.sqrt(-2.0 * Math.log(t));
        double v = t - ((c2 * t + c1) * t + c0) / (((d3 * t + d2) * t + d1) * t + 1.0);
        if (x < 0.0) {
            v = -v;
        }
        return v;
    }

    public static double curve(double c1, double c2, double x1, double x2, double x3, double de) {
        return (c1 + c2 / (1.0 + Math.pow((de - x2) / x3, 2.0))) * Math.pow(de / x1, 2.0) / (1.0 + Math.pow(de / x1, 2.0));
    }

    public static double avar(double zzt, double zzl, double zzc, LinkResult link, double aref, Param2 param2) {
        double yr;
        double sgl;
        boolean w1;
        double[] bv1 = new double[]{-9.67, -0.62, 1.26, -9.21, -0.62, -0.39, 3.15};
        double[] bv2 = new double[]{12.7, 9.19, 15.5, 9.05, 9.19, 2.86, 857.9};
        double[] xv1 = new double[]{144900.0, 228900.0, 262600.0, 84100.0, 228900.0, 141700.0, 2222000.0};
        double[] xv2 = new double[]{190300.0, 205200.0, 185200.0, 101100.0, 205200.0, 315900.0, 164800.0};
        double[] xv3 = new double[]{133800.0, 143600.0, 99800.0, 98600.0, 143600.0, 167400.0, 116300.0};
        double[] bsm1 = new double[]{2.13, 2.66, 6.11, 1.98, 2.68, 6.86, 8.51};
        double[] bsm2 = new double[]{159.5, 7.67, 6.65, 13.11, 7.16, 10.38, 169.8};
        double[] xsm1 = new double[]{762200.0, 100400.0, 138200.0, 139100.0, 93700.0, 187800.0, 609800.0};
        double[] xsm2 = new double[]{123600.0, 172500.0, 242200.0, 132700.0, 186800.0, 169600.0, 119900.0};
        double[] xsm3 = new double[]{94500.0, 136400.0, 178600.0, 193500.0, 133500.0, 108900.0, 106600.0};
        double[] bsp1 = new double[]{2.11, 6.87, 10.08, 3.68, 4.75, 8.58, 8.43};
        double[] bsp2 = new double[]{102.3, 15.53, 9.6, 159.3, 8.12, 13.97, 8.19};
        double[] xsp1 = new double[]{636900.0, 138700.0, 165300.0, 464400.0, 93200.0, 216000.0, 136200.0};
        double[] xsp2 = new double[]{134800.0, 143700.0, 225700.0, 93100.0, 135900.0, 152000.0, 188500.0};
        double[] xsp3 = new double[]{95600.0, 98600.0, 129700.0, 94200.0, 113400.0, 122700.0, 122900.0};
        double[] bsd1 = new double[]{1.224, 0.801, 1.38, 1.0, 1.224, 1.518, 1.518};
        double[] bzd1 = new double[]{1.282, 2.161, 1.282, 20.0, 1.282, 1.282, 1.282};
        double[] bfm1 = new double[]{1.0, 1.0, 1.0, 1.0, 0.92, 1.0, 1.0};
        double[] bfm2 = new double[]{0.0, 0.0, 0.0, 0.0, 0.25, 0.0, 0.0};
        double[] bfm3 = new double[]{0.0, 0.0, 0.0, 0.0, 1.77, 0.0, 0.0};
        double[] bfp1 = new double[]{1.0, 0.93, 1.0, 0.93, 0.93, 1.0, 1.0};
        double[] bfp2 = new double[]{0.0, 0.31, 0.0, 0.19, 0.31, 0.0, 0.0};
        double[] bfp3 = new double[]{0.0, 2.0, 0.0, 1.79, 2.0, 0.0, 0.0};
        double rt = 7.8;
        double rl = 24.0;
        int temp_radio_2 = LongleyRice_mod.radio_climate;
        double cv1 = bv1[temp_radio_2];
        double cv2 = bv2[temp_radio_2];
        double yv1 = xv1[temp_radio_2];
        double yv2 = xv2[temp_radio_2];
        double yv3 = xv3[temp_radio_2];
        double csm1 = bsm1[temp_radio_2];
        double csm2 = bsm2[temp_radio_2];
        double ysm1 = xsm1[temp_radio_2];
        double ysm2 = xsm2[temp_radio_2];
        double ysm3 = xsm3[temp_radio_2];
        double csp1 = bsp1[temp_radio_2];
        double csp2 = bsp2[temp_radio_2];
        double ysp1 = xsp1[temp_radio_2];
        double ysp2 = xsp2[temp_radio_2];
        double ysp3 = xsp3[temp_radio_2];
        double csd1 = bsd1[temp_radio_2];
        double zd = bzd1[temp_radio_2];
        double cfm1 = bfm1[temp_radio_2];
        double cfm2 = bfm2[temp_radio_2];
        double cfm3 = bfm3[temp_radio_2];
        double cfp1 = bfp1[temp_radio_2];
        double cfp2 = bfp2[temp_radio_2];
        double cfp3 = bfp3[temp_radio_2];
        int kdv = LongleyRice_mod.mdvar;
        boolean ws = kdv >= 20;
        boolean bl = w1 = kdv >= 10;
        if (w1) {
            kdv -= 10;
        }
        if (kdv < 0 || kdv > 3) {
            kdv = 0;
        }
        double q = Math.log(0.133 * param2.k);
        double gm = cfm1 + cfm2 / (Math.pow(cfm3 * q, 2.0) + 1.0);
        double gp = cfp1 + cfp2 / (Math.pow(cfp3 * q, 2.0) + 1.0);
        double dexa = Math.sqrt(1.8E7 * param2.he1) + Math.sqrt(1.8E7 * param2.he2) + Math.cbrt(5.757E14 / param2.k);
        double de = link.getTxRxDistance() * 1000.0 < dexa ? 130000.0 * (link.getTxRxDistance() * 1000.0) / dexa : 130000.0 + link.getTxRxDistance() * 1000.0 - dexa;
        double vmd = Stat.curve(cv1, cv2, yv1, yv2, yv3, de);
        double sgtm = Stat.curve(csm1, csm2, ysm1, ysm2, ysm3, de) * gm;
        double sgtp = Stat.curve(csp1, csp2, ysp1, ysp2, ysp3, de) * gp;
        double sgtd = sgtp * csd1;
        double tgtd = (sgtp - sgtd) * zd;
        if (w1) {
            sgl = 0.0;
        } else {
            q = (1.0 - 0.8 * Math.exp(-(link.getTxRxDistance() * 1000.0) / 50000.0)) * LongleyRice_mod.input.terrainIrregular() * param2.k;
            sgl = 10.0 * q / (q + 13.0);
        }
        double vs0 = ws ? 0.0 : Math.pow(5.0 + 3.0 * Math.exp(-de / 100000.0), 2.0);
        param2.lvar = 0;
        double zt = zzt;
        double zl = zzl;
        double zc = zzc;
        switch (kdv) {
            case 0: {
                zt = zc;
                zl = zc;
                break;
            }
            case 1: {
                zl = zc;
                break;
            }
            case 2: {
                zl = zt;
            }
        }
        double sgt = zt < 0.0 ? sgtm : (zt <= zd ? sgtp : sgtd + tgtd / zt);
        double vs = vs0 + Math.pow(sgt * zt, 2.0) / (rt + zc * zc) + Math.pow(sgl * zl, 2.0) / (rl + zc * zc);
        if (kdv == 0) {
            yr = 0.0;
            param2.sgc = Math.sqrt(sgt * sgt + sgl * sgl + vs);
        } else if (kdv == 1) {
            yr = sgt * zt;
            param2.sgc = Math.sqrt(sgl * sgl + vs);
        } else if (kdv == 2) {
            yr = Math.sqrt(sgt * sgt + sgl * sgl) * zt;
            param2.sgc = Math.sqrt(vs);
        } else {
            yr = sgt * zt + sgl * zl;
            param2.sgc = Math.sqrt(vs);
        }
        double avarv = aref - vmd - yr - param2.sgc * zc;
        if (avarv < 0.0) {
            avarv = avarv * (29.0 - avarv) / (29.0 - 10.0 * avarv);
        }
        return avarv;
    }

    static double stat(LinkResult link, double aref, Param param, Param2 param2) {
        double zt = Stat.querfi(param.pctTime);
        double zl = Stat.querfi(param.pctLoc);
        double zc = Stat.querfi(param.pctConf);
        double fs = 32.45 + 20.0 * Math.log10(link.getFrequency()) + 20.0 * Math.log10(link.getTxRxDistance());
        double dbloss = fs + Stat.avar(zt, zl, zc, link, aref, param2);
        return dbloss;
    }
}

