/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.propagation;

import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.plugin.propagation.PropagationModelPlugin;
import org.seamcat.model.plugin.propagation.SphericalDiffractionInput;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.Origin;
import org.seamcat.model.propagation.Helper;
import org.seamcat.model.propagation.LocalEnvCorrections;
import org.seamcat.model.propagation.PluginCheckUtilsToBeRemoved;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.result.DescriptionImpl;

public class SDPropagationModel
implements PropagationModelPlugin<SphericalDiffractionInput> {
    private static final double EARTHRADIUS_IN_KM = 6371.0;
    private double rBeta;
    private Double wiLoss = 5.0;
    private Double wiStdDev = 10.0;
    private Double floorLoss = 18.3;
    private Double empiricalParameter = 0.46;
    private Double roomSize = 4.0;
    private Double floorHeight = 3.0;
    private Double waterCtr = 3.0;
    private Double earthSurfaceAdmittance = 1.0E-5;
    private Double refrIndexGradient = 40.0;
    private Double refrLayerProb = 1.0;

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, SphericalDiffractionInput input, Validator validator) {
        Bounds bounds;
        if (context.getOrigin() == Origin.EPP) {
            return;
        }
        Distribution frequency = context.getFrequency();
        if (frequency != null && (bounds = frequency.getBounds()).getMax() < 3000.0) {
            validator.error("Frequencies below 3 GHz are not supported by the Spherical Diffraction model" + PluginCheckUtilsToBeRemoved.getExceptionHint());
        }
    }

    public double f(double rX) {
        if (rX < 1.6) {
            return -20.0 * Math.log10(rX) - 5.6488 * Math.pow(rX, 1.425);
        }
        return 11.0 + Math.log10(rX) - 17.6 * rX;
    }

    public double EffectiveEarthRadiusCalculation(double rRefrIndexGradient, double rRefrLayerProb, double rTimePercentage) {
        double rAe = 0.0;
        double rRe = 6371.0;
        double rKe50 = 157.0 / (157.0 - rRefrIndexGradient);
        if (rTimePercentage > 50.0) {
            rAe = rKe50 * rRe;
        } else {
            double rKe = rKe50 + (5.0 - rKe50) * ((1.7 - Math.log10(rTimePercentage)) / (1.7 - Math.log10(rRefrLayerProb)));
            rAe = rKe * rRe;
        }
        return rAe;
    }

    public double diffractionLoss(double rFreq, double rDist, double rHTx, double rHRx, double rTimePercentage) {
        double rK = this.getEarthSurfaceAdmittance();
        double rK2 = rK * rK;
        double rK4 = rK2 * rK2;
        double dmin = 0.0;
        double rXmin = 0.0;
        double rXlim = 0.0;
        double rAe = this.EffectiveEarthRadiusCalculation(this.getRefrIndexGradient(), this.getRefrLayerProb(), rTimePercentage);
        this.rBeta = rFreq < 20.0 ? (1.0 + 1.6 * rK2 + 0.67 * rK4) / (1.0 + 4.5 * rK2 + 1.53 * rK4) : 1.0;
        double rX = 2.188 * this.rBeta * Math.pow(rFreq, 0.3333333333333333) * Math.pow(rAe, -0.6666666666666666) * rDist;
        double rYTx = 0.009575 * this.rBeta * Math.pow(rFreq, 0.6666666666666666) / Math.pow(rAe, 0.3333333333333333) * rHTx;
        double rYRx = 0.009575 * this.rBeta * Math.pow(rFreq, 0.6666666666666666) / Math.pow(rAe, 0.3333333333333333) * rHRx;
        rXlim = 1.096 - 1.28 * (1.0 - this.rBeta);
        rXmin = rXlim + Math.pow(this.rBeta * rYTx, 0.5) * this.delta(rYTx, this.rBeta) + Math.pow(this.rBeta * rYRx, 0.5) * this.delta(rYRx, this.rBeta);
        dmin = rXmin / (2.188 * this.rBeta * Math.pow(rFreq, 0.3333333333333333) * Math.pow(rAe, -0.6666666666666666));
        double rDiffractionLoss = this.f(rX) + this.g(rYTx, this.rBeta * rYTx) + this.g(rYRx, this.rBeta * rYRx);
        if (rDiffractionLoss > 0.0) {
            rDiffractionLoss = 0.0;
        }
        return -rDiffractionLoss;
    }

    public void setEarthSurfaceAdmittance(double esa) {
        this.earthSurfaceAdmittance = esa;
    }

    @Override
    public double evaluate(LinkResult linkResult, boolean variations, SphericalDiffractionInput input) {
        double rFreq = linkResult.getFrequency();
        double rDist = linkResult.getTxRxDistance();
        double rHTx = linkResult.txAntenna().getHeight();
        double rHRx = linkResult.rxAntenna().getHeight();
        double rL = 0.0;
        double rStdDev = 0.0;
        this.wiLoss = input.wallLossInIn();
        this.wiStdDev = input.wallLossStdDev();
        this.floorLoss = input.adjacentFloorLoss();
        this.empiricalParameter = input.empiricalParameters();
        this.roomSize = input.sizeOfRoom();
        this.floorHeight = input.floorHeight();
        this.waterCtr = input.waterConcentration();
        this.earthSurfaceAdmittance = input.earthSurfaceAdm();
        this.refrIndexGradient = input.refractionGradient();
        this.refrLayerProb = input.refractionProb();
        double rW = 0.0;
        double rRho2 = 7.5 + 2.5 * rW;
        Distribution timePercentage = input.timePercentage();
        double rP = timePercentage.trial();
        double rPressure = 1013.0;
        double rTemperature = 10.0;
        if (rFreq < 3000.0) {
            throw new RuntimeException("Frequencies below 3 GHz are not supported by the Spherical Diffraction model");
        }
        rL = 92.5 + 20.0 * Math.log10(rFreq / 1000.0) + 20.0 * Math.log10(rDist) + this.attenuationByAtmosphericGasesP676ver8(rFreq / 1000.0, rRho2, rPressure, rTemperature) + this.diffractionLoss(rFreq, rDist, rHTx, rHRx, rP);
        LocalEnvCorrections lec = Helper.localEnvCorrections(new LocalEnvCorrections(rL, rStdDev), linkResult, this.floorHeight, this.roomSize, this.wiLoss, this.floorLoss, this.empiricalParameter, this.wiStdDev);
        rL = lec.rMedianLoss;
        rStdDev = lec.rStdDev;
        if (variations) {
            rL += Factory.distributionFactory().getGaussianDistribution(0.0, rStdDev).trial();
        }
        if (Double.isInfinite(rL)) {
            rL = 20.0 * Math.log10(rFreq) - 100.0;
        }
        return rL;
    }

    public double delta(double rY, double rBeta) {
        double rDelta = 0.0;
        double rDeltaZero = 0.0;
        double rDeltaInfinity = 0.0;
        rDeltaZero = 0.5 * (1.0 + Math.tanh((-0.255 + 0.5 * Math.log10(rBeta * rY)) / 0.3));
        rDeltaInfinity = 0.5 * (1.0 + Math.tanh((0.255 + 0.5 * Math.log10(rBeta * rY)) / 0.3));
        rDelta = rDeltaZero + 1.779 * (1.0 - rBeta) * (rDeltaInfinity - rDeltaZero);
        return rDelta;
    }

    public double g(double rY, double rB) {
        double rK = this.getEarthSurfaceAdmittance();
        double rK1 = rK * 10.0;
        double rK2 = rK / 10.0;
        double rG = rB > 2.0 ? 17.6 * Math.sqrt(rB - 1.1) - 5.0 * Math.log10(rB - 1.1) - 8.0 : (rB > rK1 ? 20.0 * Math.log10(rB + 0.1 * rB * rB * rB) : (rY > rK2 ? 2.0 + 20.0 * Math.log10(rK) + 9.0 * Math.log10(rB / rK) * (Math.log10(rB / rK) + 1.0) : 2.0 + 20.0 * Math.log10(rK)));
        return rG;
    }

    public double attenuationByAtmosphericGasesP676ver8(double rFreq, double rRho, double rPressure, double rTemperature) {
        double rGamma = 0.0;
        rTemperature = 288.0 / (273.0 + rTemperature);
        double gammaDryAir = this.attenuationDueToDryAir(rFreq, rPressure /= 1013.0, rTemperature);
        double gammaWaterVapour = this.attenuationDueToWaterVapour(rFreq, rPressure, rTemperature, rRho);
        rGamma = gammaDryAir + gammaWaterVapour;
        return rGamma;
    }

    public double functionPhi(double rPressure, double rTemperature, double a, double b, double c, double d) {
        double rValue = 0.0;
        double rTemp = c * (1.0 - rPressure) + d * (1.0 - rTemperature);
        rValue = Math.pow(rPressure, a) * Math.pow(rTemperature, b) * Math.exp(rTemp);
        return rValue;
    }

    public double functionG(double rFreq, double rFreqi) {
        double rValue = 0.0;
        rValue = 1.0 + Math.pow((rFreq - rFreqi) / (rFreq + rFreqi), 2.0);
        return rValue;
    }

    public double attenuationDueToDryAir(double rFreq, double rPressure, double rTemperature) {
        double rGammaDryAir = 0.0;
        double rZeta1 = this.functionPhi(rPressure, rTemperature, 0.0717, -1.8132, 0.0156, -1.6515);
        double rZeta2 = this.functionPhi(rPressure, rTemperature, 0.5146, -4.6368, -0.1921, -5.7416);
        double rZeta3 = this.functionPhi(rPressure, rTemperature, 0.3414, -6.5851, 0.213, -8.5854);
        double rZeta4 = this.functionPhi(rPressure, rTemperature, -0.0112, 0.0092, -0.1033, -9.0E-4);
        double rZeta5 = this.functionPhi(rPressure, rTemperature, 0.2705, -2.7192, -0.3016, -4.1033);
        double rZeta6 = this.functionPhi(rPressure, rTemperature, 0.2445, -5.9191, 0.0422, -8.0719);
        double rZeta7 = this.functionPhi(rPressure, rTemperature, -0.1833, 6.5589, -0.2402, 6.131);
        double rGamma54 = 2.192 * this.functionPhi(rPressure, rTemperature, 1.8286, -1.9487, 0.4051, -2.8509);
        double rGamma58 = 12.59 * this.functionPhi(rPressure, rTemperature, 1.0045, 3.561, 0.1588, 1.2834);
        double rGamma60 = 15.0 * this.functionPhi(rPressure, rTemperature, 0.9003, 4.1335, 0.0427, 1.6088);
        double rGamma62 = 14.28 * this.functionPhi(rPressure, rTemperature, 0.9886, 3.4176, 0.1827, 1.3429);
        double rGamma64 = 6.819 * this.functionPhi(rPressure, rTemperature, 1.432, 0.6258, 0.3177, -0.5914);
        double rGamma66 = 1.908 * this.functionPhi(rPressure, rTemperature, 2.0717, -4.1404, 0.491, -4.8718);
        double rDelta = -0.00306 * this.functionPhi(rPressure, rTemperature, 3.211, -14.94, 1.583, -16.37);
        if (rFreq <= 54.0) {
            rGammaDryAir = (7.2 * Math.pow(rTemperature, 2.8) / (Math.pow(rFreq, 2.0) + 0.34 * Math.pow(rPressure, 2.0) * Math.pow(rTemperature, 1.6)) + 0.62 * rZeta3 / (Math.pow(54.0 - rFreq, 1.16 * rZeta1) + 0.083 * rZeta2)) * Math.pow(rFreq, 2.0) * Math.pow(rPressure, 2.0) * Math.pow(10.0, -3.0);
        } else if (rFreq <= 60.0) {
            rGammaDryAir = Math.exp((rFreq - 58.0) * (rFreq - 60.0) * Math.log(rGamma54) / 24.0 - (rFreq - 54.0) * (rFreq - 60.0) * Math.log(rGamma58) / 8.0 + (rFreq - 54.0) * (rFreq - 58.0) * Math.log(rGamma60) / 12.0);
        } else if (rFreq <= 62.0) {
            rGammaDryAir = rGamma60 + (rGamma62 - rGamma60) * (rFreq - 60.0) / 2.0;
        } else if (rFreq <= 66.0) {
            rGammaDryAir = Math.exp((rFreq - 64.0) * (rFreq - 66.0) * Math.log(rGamma62) / 8.0 - (rFreq - 62.0) * (rFreq - 66.0) * Math.log(rGamma64) / 4.0 + (rFreq - 62.0) * (rFreq - 64.0) * Math.log(rGamma66) / 8.0);
        } else if (rFreq <= 120.0) {
            rGammaDryAir = (3.02 * Math.pow(10.0, -4.0) * Math.pow(rTemperature, 3.5) + 0.283 * Math.pow(rTemperature, 3.8) / (Math.pow(rFreq - 118.75, 2.0) + 2.91 * Math.pow(rPressure, 2.0) * Math.pow(rTemperature, 1.6)) + 0.502 * rZeta6 * (1.0 - 0.0163 * rZeta7 * (rFreq - 66.0)) / (Math.pow(rFreq - 66.0, 1.4346 * rZeta4) + 1.15 * rZeta5)) * Math.pow(rFreq, 2.0) * Math.pow(rPressure, 2.0) * Math.pow(10.0, -3.0);
        } else if (rFreq <= 350.0) {
            rGammaDryAir = (3.02 * Math.pow(10.0, -4.0) / (1.0 + 1.9 * Math.pow(10.0, -5.0) * Math.pow(rFreq, 1.5)) + 0.283 * Math.pow(rTemperature, 0.3) / (Math.pow(rFreq - 118.75, 2.0) + 2.91 * Math.pow(rPressure, 2.0) * Math.pow(rTemperature, 1.6))) * Math.pow(rFreq, 2.0) * Math.pow(rPressure, 2.0) * Math.pow(rTemperature, 3.5) * Math.pow(10.0, -3.0) + rDelta;
        }
        return rGammaDryAir;
    }

    public double attenuationDueToWaterVapour(double rFreq, double rPressure, double rTemperature, double rRho) {
        double rGammaWaterVapour = 0.0;
        double rEta1 = 0.955 * rPressure * Math.pow(rTemperature, 0.68) + 0.006 * rRho;
        double rEta2 = 0.735 * rPressure * Math.pow(rTemperature, 0.5) + 0.0353 * Math.pow(rTemperature, 4.0) * rRho;
        double rValue1 = 3.98 * rEta1 * Math.exp(2.23 * (1.0 - rTemperature)) / (Math.pow(rFreq - 22.235, 2.0) + 9.42 * Math.pow(rEta1, 2.0)) * this.functionG(rFreq, 22.0);
        double rValue2 = 11.96 * rEta1 * Math.exp(0.7 * (1.0 - rTemperature)) / (Math.pow(rFreq - 183.31, 2.0) + 11.14 * Math.pow(rEta1, 2.0));
        double rValue3 = 0.081 * rEta1 * Math.exp(6.44 * (1.0 - rTemperature)) / (Math.pow(rFreq - 321.226, 2.0) + 6.29 * Math.pow(rEta1, 2.0));
        double rValue4 = 3.66 * rEta1 * Math.exp(1.6 * (1.0 - rTemperature)) / (Math.pow(rFreq - 321.153, 2.0) + 9.22 * Math.pow(rEta1, 2.0));
        double rValue5 = 25.37 * rEta1 * Math.exp(1.09 * (1.0 - rTemperature)) / Math.pow(rFreq - 380.0, 2.0);
        double rValue6 = 17.4 * rEta1 * Math.exp(1.46 * (1.0 - rTemperature)) / Math.pow(rFreq - 448.0, 2.0);
        double rValue7 = 844.6 * rEta1 * Math.exp(0.17 * (1.0 - rTemperature)) / Math.pow(rFreq - 557.0, 2.0) * this.functionG(rFreq, 557.0);
        double rValue8 = 290.0 * rEta1 * Math.exp(0.41 * (1.0 - rTemperature)) / Math.pow(rFreq - 752.0, 2.0) * this.functionG(rFreq, 752.0);
        double rValue9 = 8.3328 * Math.pow(10.0, 4.0) * rEta2 * Math.exp(0.99 * (1.0 - rTemperature)) / Math.pow(rFreq - 1780.0, 2.0) * this.functionG(rFreq, 1780.0);
        rGammaWaterVapour = (rValue1 + rValue2 + rValue3 + rValue4 + rValue5 + rValue6 + rValue7 + rValue8 + rValue9) * Math.pow(rFreq, 2.0) * Math.pow(rTemperature, 2.5) * rRho * Math.pow(10.0, -4.0);
        return rGammaWaterVapour;
    }

    public double getEarthSurfaceAdmittance() {
        return this.earthSurfaceAdmittance;
    }

    public double getRefrIndexGradient() {
        return this.refrIndexGradient;
    }

    public double getRefrLayerProb() {
        return this.refrLayerProb;
    }

    @Override
    public Description description() {
        return new DescriptionImpl("ITU-R P.526-2 (Spherical Diffraction) DEPRECATED", "<b><u>Frequency range:</u></b><br>above 3 GHz<br><b><u>Distance range:</u></b><br>Up to and beyond radio horizon<br><b><u>Typical application area:</u></b><br>Interference on terrestrial paths in predominantly open (e.g. rural) areas.");
    }

    public void setRefrIndexGradient(double refrIndexGradient) {
        this.refrIndexGradient = refrIndexGradient;
    }

    public void setRefrLayerProb(double refrLayerProb) {
        this.refrLayerProb = refrLayerProb;
    }
}

