/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.propagation;

import org.seamcat.model.plugin.propagation.PBELInput;
import org.seamcat.model.simulation.result.LinkResult;

public class PBEL {
    public double evaluate(LinkResult linkResult, boolean variations, PBELInput input) {
        double fMHz = linkResult.getFrequency();
        double StdDev = 0.0;
        double f = fMHz / 1000.0;
        int cl = input.building_class().type();
        double p = input.locPercentage().trial();
        double th = input.th().trial();
        double L = this.bel(f, p, cl, th);
        return L;
    }

    public double bel(double f, double p, int cl, double th) {
        if (f < 0.08 || f > 100.0) {
            throw new RuntimeException("Frequency is outside the valid domain [0.08, 100] GHz");
        }
        if (th < -90.0 || th > 90.0) {
            throw new RuntimeException("Elevation angle is outside the valid domain [-90, 90] degrees");
        }
        if (p <= 0.0 || p >= 100.0) {
            throw new RuntimeException("Percentage of locations is outside the valid domain (0, 100)%");
        }
        double r = 12.64;
        double s = 3.72;
        double t = 0.96;
        double u = 9.6;
        double v = 2.0;
        double w = 9.1;
        double x = -3.0;
        double y = 4.5;
        double z = -2.0;
        if (cl == 2) {
            r = 28.19;
            s = -3.0;
            t = 8.48;
            u = 13.5;
            v = 3.8;
            w = 27.8;
            x = -2.9;
            y = 9.4;
            z = -2.1;
        }
        double Le = 0.212 * Math.abs(th);
        double Lh = r + s * Math.log10(f) + t * Math.pow(Math.log10(f), 2.0);
        double sigma2 = y + z * Math.log10(f);
        double sigma1 = u + v * Math.log10(f);
        double mu2 = w + x * Math.log10(f);
        double mu1 = Lh + Le;
        double C = -3.0;
        double B = this.norminv(p / 100.0, mu2, sigma2);
        double A = this.norminv(p / 100.0, mu1, sigma1);
        double L = 10.0 * Math.log10(Math.pow(10.0, 0.1 * A) + Math.pow(10.0, 0.1 * B) + Math.pow(10.0, 0.1 * C));
        return L;
    }

    private double norminv(double p, double mu, double sigma) {
        double y = mu + sigma * this.Qi(1.0 - p);
        return y;
    }

    private double Qi(double x) {
        double out = x <= 0.5 ? this.T(x) - this.C(x) : -(this.T(1.0 - x) - this.C(1.0 - x));
        return out;
    }

    private double T(double y) {
        double outT = Math.sqrt(-2.0 * Math.log(y));
        return outT;
    }

    private double C(double z) {
        double C0 = 2.515517;
        double C1 = 0.802853;
        double C2 = 0.010328;
        double D1 = 1.432788;
        double D2 = 0.189269;
        double D3 = 0.001308;
        double outC = ((C2 * this.T(z) + C1) * this.T(z) + C0) / (((D3 * this.T(z) + D2) * this.T(z) + D1) * this.T(z) + 1.0);
        return outC;
    }
}

