/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.propagation;

import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.plugin.propagation.P452ver16Input;
import org.seamcat.model.plugin.propagation.PropagationModelPlugin;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.Origin;
import org.seamcat.model.propagation.PluginCheckUtilsToBeRemoved;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.LocalEnvironment;
import org.seamcat.model.types.result.DescriptionImpl;

public class P452ver16PropagationModel
implements PropagationModelPlugin<P452ver16Input> {
    private final double rW = 0.0;

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, P452ver16Input input, Validator validator) {
        double nominalDistance;
        if (context.getOrigin() == Origin.EPP) {
            return;
        }
        Distribution frequency = context.getFrequency();
        Bounds bounds = frequency.getBounds();
        if (bounds.getMin() < 100.0 || bounds.getMax() > 50000.0) {
            validator.error("P452-16 model applicable for frequencies in the range 100 MHz to 50 GHz");
        }
        double minDistance = context.getCoverage().getMin();
        if (input.useClutter() && minDistance <= (nominalDistance = input.clutterUserSpecified() ? input.clutterNominalDistanceTx() + input.clutterNominalDistanceRx() : input.clutterAtTx().getDistance() + input.clutterAtRx().getDistance())) {
            validator.error("<HtMl><br/>ITU-R P.452-16: the minimum distance between Tx and Rx (" + minDistance + " km) must be larger <br/>than the sum of nominal clutter distances from Tx and Rx (" + nominalDistance + " km)." + PluginCheckUtilsToBeRemoved.getExceptionHint());
        }
        if (input.useClutter()) {
            boolean environmentClutter = false;
            for (LocalEnvironment env : context.getRxSettings().getLocalEnvironments()) {
                if (env.getEnvironment() != LocalEnvironment.Environment.Outdoor || !env.isUsingClutter()) continue;
                environmentClutter = true;
            }
            for (LocalEnvironment env : context.getTxSettings().getLocalEnvironments()) {
                if (env.getEnvironment() != LocalEnvironment.Environment.Outdoor || !env.isUsingClutter()) continue;
                environmentClutter = true;
            }
            if (environmentClutter) {
                validator.error("Applying clutter twice: the environment selection and propagation model ITU-R P.452-16 are both applying clutter");
            }
        }
    }

    @Override
    public double evaluate(LinkResult linkResult, boolean variations, P452ver16Input input) {
        double sumClutterDistance;
        double rFreq = linkResult.getFrequency();
        double rDist = linkResult.getTxRxDistance();
        double rHTx = linkResult.txAntenna().getHeight();
        double rHRx = linkResult.rxAntenna().getHeight();
        double rL = 0.0;
        double rStdDev = 0.0;
        double ha_t = 0.0;
        double ha_r = 0.0;
        double dk_t = 0.0;
        double dk_r = 0.0;
        if (input.useClutter()) {
            if (input.clutterUserSpecified()) {
                ha_t = input.clutterNominalHeightTx();
                ha_r = input.clutterNominalHeightRx();
                dk_t = input.clutterNominalDistanceTx();
                dk_r = input.clutterNominalDistanceRx();
            } else {
                ha_t = input.clutterAtTx().getHeight();
                ha_r = input.clutterAtRx().getHeight();
                dk_t = input.clutterAtTx().getDistance();
                dk_r = input.clutterAtRx().getDistance();
            }
            if (dk_t + dk_r >= rDist) {
                throw new RuntimeException("Sum of nominal clutter distances from Tx and Rx must be smaller than the distance between Tx and Rx");
            }
        }
        if ((sumClutterDistance = dk_t + dk_r) >= rDist) {
            throw new RuntimeException("Sum of nominal clutter distances from Tx and Rx (" + sumClutterDistance + " km) must be smaller than the distance between Tx and Rx (" + rDist + " km)");
        }
        double rRho1 = input.waterConcentration();
        double rRho2 = 7.5;
        double rP = input.timePercentage().trial();
        double rStep = 0.01;
        int rTotalLength = Math.max(5, (int)Math.round(rDist / rStep));
        rStep = rDist / (double)(rTotalLength - 1);
        double[] rDisti = new double[rTotalLength];
        double[] rHighti = new double[rTotalLength];
        int[] iZonei = new int[rTotalLength];
        rDisti[0] = 0.0;
        rHighti[0] = 0.0;
        iZonei[0] = 2;
        double rpol = 1.0;
        double dct = 500.0;
        double dcr = 500.0;
        for (int i = 1; i < rTotalLength; ++i) {
            rDisti[i] = rDisti[i - 1] + rStep;
            rHighti[i] = 0.0;
            iZonei[i] = 2;
        }
        rL = this.tl_p452(rFreq / 1000.0, rP, rDisti, rHighti, iZonei, rHTx, rHRx, input.latitude(), input.latitude(), linkResult.txAntenna().getGain(), linkResult.rxAntenna().getGain(), rpol, dct, dcr, input.refractionIndex(), input.seaLevelSurfaceRefractivity(), input.surfacePressure(), input.surfaceTemperature(), ha_t, ha_r, dk_t, dk_r, input.diffractionOnly());
        if (variations) {
            rL += Factory.distributionFactory().getGaussianDistribution(0.0, rStdDev).trial();
        }
        if (Double.isInfinite(rL)) {
            rL = 20.0 * Math.log10(rFreq) - 100.0;
        }
        return rL;
    }

    public double Jfunction(double rInput) {
        double rValue = 0.0;
        rValue = 6.9 + 20.0 * Math.log10(Math.sqrt(Math.pow(rInput - 0.1, 2.0) + 1.0) + rInput - 0.1);
        return rValue;
    }

    public double tl_p452(double f, double p, double[] d, double[] h, int[] zone, double htg, double hrg, double phi_t, double phi_r, double Gt, double Gr, double pol, double dct, double dcr, double DN, double N0, double press, double temp, double ha_t, double ha_r, double dk_t, double dk_r, boolean diffractionOnly) {
        double phi_path = (phi_t + phi_r) / 2.0;
        int zone_r = 12;
        double dtm = this.longest_cont_dist(d, zone, zone_r);
        zone_r = 2;
        double dlm = this.longest_cont_dist(d, zone, zone_r);
        double b0 = this.beta0(phi_path, dtm, dlm);
        double[] aa = this.earth_rad_eff(DN);
        double ae = aa[0];
        double ab = aa[1];
        double omega = this.path_fraction_sea(d, zone, 3);
        double Aht = 0.0;
        double Ahr = 0.0;
        double[] clut = this.closs_corr(f, d, h, zone, htg, hrg, ha_t, ha_r, dk_t, dk_r);
        int index1 = (int)clut[0];
        int index2 = (int)clut[1];
        htg = clut[2];
        hrg = clut[3];
        Aht = clut[4];
        Ahr = clut[5];
        int N = index2 - index1 + 1;
        double[] dc = new double[N];
        double[] hc = new double[N];
        int[] zonec = new int[N];
        for (int ii = index1; ii <= index2; ++ii) {
            dc[ii - index1] = d[ii] - d[index1];
            hc[ii - index1] = h[ii];
            zonec[ii - index1] = zone[ii];
        }
        int n = dc.length;
        double[] seh = this.smooth_earth_heights(dc, hc, htg, hrg, ae, f);
        double hst = seh[0];
        double hsr = seh[1];
        double hstd = seh[2];
        double hsrd = seh[3];
        double hte = seh[4];
        double hre = seh[5];
        double hm = seh[6];
        double dlt = seh[7];
        double dlr = seh[8];
        double theta_t = seh[9];
        double theta_r = seh[10];
        double theta = seh[11];
        double pathtype = seh[12];
        double dtot = dc[n - 1] - dc[0];
        double hts = hc[0] + htg;
        double hrs = hc[n - 1] + hrg;
        double Ce = 1.0 / ae;
        double lambda = 0.3 / f;
        double Stim = (hc[1] + 500.0 * Ce * dc[1] * (dtot - dc[1]) - hts) / dc[1];
        for (int i = 2; i < n - 1; ++i) {
            Stim = Math.max(Stim, (hc[i] + 500.0 * Ce * dc[i] * (dtot - dc[i]) - hts) / dc[i]);
        }
        double Str = (hrs - hts) / dtot;
        double THETA = 0.3;
        double KSI = 0.8;
        double Fj = 1.0 - 0.5 * (1.0 + Math.tanh(3.0 * KSI * (Stim - Str) / THETA));
        double dsw = 20.0;
        double kappa = 0.5;
        double Fk = 1.0 - 0.5 * (1.0 + Math.tanh(3.0 * kappa * (dtot - dsw) / dsw));
        double[] Lpl = this.pl_los(dtot, f, p, b0, omega, temp, press, dlt, dlr);
        double Lbfsg = Lpl[0];
        double Lb0p = Lpl[1];
        double Lb0b = Lpl[2];
        double[] Ldl = this.dl_p(dc, hc, hts, hrs, hstd, hsrd, f, omega, p, b0, DN, pol);
        double Ldp = Ldl[0];
        double Ld50 = Ldl[1];
        double Lbd50 = Lbfsg + Ld50;
        double Lbd = Lb0p + Ldp;
        if (diffractionOnly) {
            return Lbd;
        }
        double Lminb0p = Lb0p + (1.0 - omega) * Ldp;
        double Fi = 1.0;
        if (p >= b0) {
            Fi = this.inv_cum_norm(p / 100.0) / this.inv_cum_norm(b0 / 100.0);
            Lminb0p = Lbd50 + (Lb0b + (1.0 - omega) * Ldp - Lbd50) * Fi;
        }
        double eta = 2.5;
        double Lba = this.tl_anomalous(dtot, dlt, dlr, dct, dcr, dlm, hts, hrs, hte, hre, hm, theta_t, theta_r, f, p, temp, press, omega, ae, b0);
        double Lminbap = eta * Math.log(Math.exp(Lba / eta) + Math.exp(Lb0p / eta));
        double Lbda = Lbd;
        if (Lminbap <= Lbd) {
            Lbda = Lminbap + (Lbd - Lminbap) * Fk;
        }
        double Lbam = Lbda + (Lminb0p - Lbda) * Fj;
        double Lbs = this.tl_tropo(dtot, theta, f, p, temp, press, N0, Gt, Gr);
        return -5.0 * Math.log10(Math.pow(10.0, -0.2 * Lbs) + Math.pow(10.0, -0.2 * Lbam)) + Aht + Ahr;
    }

    public double tl_anomalous(double dtot, double dlt, double dlr, double dct, double dcr, double dlm, double hts, double hrs, double hte, double hre, double hm, double theta_t, double theta_r, double f, double p, double temp, double press, double omega, double ae, double b0) {
        double mu2;
        double Alf = 0.0;
        if (f < 0.5) {
            Alf = 45.375 - 137.0 * f + 92.5 * f * f;
        }
        double theta_t1 = theta_t - 0.1 * dlt;
        double theta_r1 = theta_r - 0.1 * dlr;
        double Ast = 0.0;
        double Asr = 0.0;
        if (theta_t1 > 0.0) {
            Ast = 20.0 * Math.log10(1.0 + 0.361 * theta_t1 * Math.sqrt(f * dlt)) + 0.264 * theta_t1 * Math.pow(f, 0.3333333333333333);
        }
        if (theta_r1 > 0.0) {
            Asr = 20.0 * Math.log10(1.0 + 0.361 * theta_r1 * Math.sqrt(f * dlr)) + 0.264 * theta_r1 * Math.pow(f, 0.3333333333333333);
        }
        double Act = 0.0;
        double Acr = 0.0;
        if (dct <= 5.0 && dct <= dlt && omega >= 0.75) {
            Act = -3.0 * Math.exp(-0.25 * dct * dct) * (1.0 + Math.tanh(0.07 * (50.0 - hts)));
        }
        if (dcr <= 5.0 && dcr <= dlr && omega >= 0.75) {
            Acr = -3.0 * Math.exp(-0.25 * dcr * dcr) * (1.0 + Math.tanh(0.07 * (50.0 - hrs)));
        }
        double gamma_d = 5.0E-5 * ae * Math.pow(f, 0.3333333333333333);
        theta_t1 = theta_t;
        theta_r1 = theta_r;
        if (theta_t > 0.1 * dlt) {
            theta_t1 = 0.1 * dlt;
        }
        if (theta_r > 0.1 * dlr) {
            theta_r1 = 0.1 * dlr;
        }
        double theta1 = 1000.0 * dtot / ae + theta_t1 + theta_r1;
        double dI = Math.min(dtot - dlt - dlr, 40.0);
        double mu3 = 1.0;
        if (hm > 10.0) {
            mu3 = Math.exp(-4.6E-5 * (hm - 10.0) * (43.0 + 6.0 * dI));
        }
        double tau = 1.0 - Math.exp(-(4.12E-4 * Math.pow(dlm, 2.41)));
        double epsilon = 3.5;
        double alpha = -0.6 - epsilon * 1.0E-9 * Math.pow(dtot, 3.1) * tau;
        if (alpha < -3.4) {
            alpha = -3.4;
        }
        if ((mu2 = Math.pow(500.0 / ae * dtot * dtot / Math.pow(Math.sqrt(hte) + Math.sqrt(hre), 2.0), alpha)) > 1.0) {
            mu2 = 1.0;
        }
        double beta = b0 * mu2 * mu3;
        beta = Math.max(beta, 1.0E-16);
        double Gamma = 1.076 / Math.pow(2.0058 - Math.log10(beta), 1.012) * Math.exp(-(9.51 - 4.8 * Math.log10(beta) + 0.198 * Math.pow(Math.log10(beta), 2.0)) * 1.0E-6 * Math.pow(dtot, 1.13));
        double Ap = -12.0 + (1.2 + 0.0037 * dtot) * Math.log10(p / beta) + 12.0 * Math.pow(p / beta, Gamma);
        double Adp = gamma_d * theta1 + Ap;
        double rho = 7.5 + 2.5 * omega;
        double T2 = temp + 273.15;
        double g = this.p676_ga_ver11(f, press, rho, T2);
        double Ag = g * dtot;
        double Af = 102.45 + 20.0 * Math.log10(f) + 20.0 * Math.log10(dlt + dlr) + Alf + Ast + Asr + Act + Acr;
        return Af + Adp + Ag;
    }

    public double tl_tropo(double dtot, double theta, double f, double p, double temp, double press, double N0, double Gt, double Gr) {
        double T2 = temp + 273.15;
        double Lf = 25.0 * Math.log10(f) - 2.5 * Math.pow(Math.log10(f / 2.0), 2.0);
        double Lc = 0.051 * Math.exp(0.055 * (Gt + Gr));
        double rho = 3.0;
        double g = this.p676_ga_ver11(f, press, rho, T2);
        double Ag = g * dtot;
        return 190.0 + Lf + 20.0 * Math.log10(dtot) + 0.573 * theta - 0.15 * N0 + Lc + Ag - 10.1 * Math.pow(-Math.log10(p / 50.0), 0.7);
    }

    public double[] smooth_earth_heights(double[] d, double[] hi, double htg, double hrg, double ae, double f) {
        int n = d.length;
        double dtot = d[n - 1];
        double hts = hi[0] + htg;
        double hrs = hi[n - 1] + hrg;
        double v1 = 0.0;
        for (int ii = 1; ii < n; ++ii) {
            v1 += (d[ii] - d[ii - 1]) * (hi[ii] + hi[ii - 1]);
        }
        double v2 = 0.0;
        for (int ii = 1; ii < n; ++ii) {
            v2 += (d[ii] - d[ii - 1]) * (hi[ii] * (2.0 * d[ii] + d[ii - 1]) + hi[ii - 1] * (d[ii] + 2.0 * d[ii - 1]));
        }
        double hst = (2.0 * v1 * dtot - v2) / (dtot * dtot);
        double hsr = (v2 - v1 * dtot) / (dtot * dtot);
        double hobs = hi[1] - (hts * (dtot - d[1]) + hrs * d[1]) / dtot;
        double alpha_obt = hobs / d[1];
        double alpha_obr = hobs / (dtot - d[1]);
        for (int ii = 2; ii < n - 1; ++ii) {
            double hh = hi[ii] - (hts * (dtot - d[ii]) + hrs * d[ii]) / dtot;
            hobs = Math.max(hh, hobs);
            alpha_obt = Math.max(alpha_obt, hh / d[ii]);
            alpha_obr = Math.max(alpha_obr, hh / (dtot - d[ii]));
        }
        double gt = alpha_obt / (alpha_obt + alpha_obr);
        double gr = alpha_obr / (alpha_obt + alpha_obr);
        double hstp = 0.0;
        double hsrp = 0.0;
        if (hobs <= 0.0) {
            hstp = hst;
            hsrp = hsr;
        } else {
            hstp = hst - hobs * gt;
            hsrp = hsr - hobs * gr;
        }
        double hstd = 0.0;
        double hsrd = 0.0;
        hstd = hstp >= hi[0] ? hi[0] : hstp;
        hsrd = hsrp > hi[n - 1] ? hi[n - 1] : hsrp;
        double theta_t = 1000.0 * Math.atan((hi[1] - hts) / (1000.0 * d[1]) - d[1] / (2.0 * ae));
        int lt = 0;
        for (int ii = 2; ii < n - 1; ++ii) {
            double theta = 1000.0 * Math.atan((hi[ii] - hts) / (1000.0 * d[ii]) - d[ii] / (2.0 * ae));
            if (!(theta > theta_t)) continue;
            theta_t = theta;
            lt = ii;
        }
        double theta_td = 1000.0 * Math.atan((hrs - hts) / (1000.0 * dtot) - dtot / (2.0 * ae));
        double theta_rd = 1000.0 * Math.atan((hts - hrs) / (1000.0 * dtot) - dtot / (2.0 * ae));
        int pathtype = 1;
        if (theta_t > theta_td) {
            pathtype = 2;
        }
        double dlt = d[lt];
        double theta_r = 1000.0 * Math.atan((hi[1] - hrs) / (1000.0 * (dtot - d[1])) - (dtot - d[1]) / (2.0 * ae));
        int lr = 0;
        for (int ii = 2; ii < n - 1; ++ii) {
            double theta = 1000.0 * Math.atan((hi[ii] - hrs) / (1000.0 * (dtot - d[ii])) - (dtot - d[ii]) / (2.0 * ae));
            if (!(theta > theta_r)) continue;
            theta_r = theta;
            lr = ii;
        }
        double dlr = dtot - d[lr];
        if (pathtype == 1) {
            int ii;
            theta_t = theta_td;
            theta_r = theta_rd;
            double lambda = 0.3 / f;
            double Ce = 1.0 / ae;
            lt = 0;
            double numax = (hi[1] + 500.0 * Ce * d[1] * (dtot - d[1]) - (hts * (dtot - d[1]) + hrs * d[1]) / dtot) * Math.sqrt(0.002 * dtot / (lambda * d[1] * (dtot - d[1])));
            for (ii = 2; ii < n - 1; ++ii) {
                double nu = (hi[ii] + 500.0 * Ce * d[ii] * (dtot - d[ii]) - (hts * (dtot - d[ii]) + hrs * d[ii]) / dtot) * Math.sqrt(0.002 * dtot / (lambda * d[ii] * (dtot - d[ii])));
                if (!(nu > numax)) continue;
                numax = nu;
                lt = ii;
            }
            dlt = d[lt];
            dlr = dtot - dlt;
            lr = 0;
            for (ii = 2; ii < n - 1; ++ii) {
                if (!(dlr < dtot - d[ii])) continue;
                lr = ii;
            }
        }
        double theta_tot = 1000.0 * dtot / ae + theta_t + theta_r;
        hst = Math.min(hst, hi[0]);
        hsr = Math.min(hsr, hi[n - 1]);
        double m = (hsr - hst) / dtot;
        double hte = htg + hi[0] - hst;
        double hre = hrg + hi[n - 1] - hsr;
        double hm = hi[lt] - (hst + m * d[lt]);
        for (int ii = lt + 1; ii <= lr; ++ii) {
            hm = Math.max(hm, hi[ii] - (hst + m * d[ii]));
        }
        double[] smeth = new double[]{hst, hsr, hstd, hsrd, hte, hre, hm, dlt, dlr, theta_t, theta_r, theta_tot, pathtype};
        return smeth;
    }

    public double beta0(double phi, double dtm, double dlm) {
        double tau = 1.0 - Math.exp(-(4.1200000000000004E-4 * Math.pow(dlm, 2.41)));
        double mu1 = Math.pow(Math.pow(10.0, -dtm / (16.0 - 6.6 * tau)) + Math.pow(10.0, -5.0 * (0.496 + 0.354 * tau)), 0.2);
        mu1 = Math.min(mu1, 1.0);
        double b0 = 0.0;
        if (Math.abs(phi) <= 70.0) {
            double mu4 = Math.pow(10.0, (-0.935 + 0.0176 * Math.abs(phi)) * Math.log10(mu1));
            b0 = Math.pow(10.0, -0.015 * Math.abs(phi) + 1.67) * mu1 * mu4;
        } else {
            double mu4 = Math.pow(10.0, 0.3 * Math.log10(mu1));
            b0 = 4.17 * mu1 * mu4;
        }
        return b0;
    }

    public double[] pl_los(double d, double f, double p, double b0, double w, double temp, double press, double dlt, double dlr) {
        double T2 = temp + 273.15;
        double rho = 7.5 + 2.5 * w;
        double g = this.p676_ga_ver11(f, press, rho, T2);
        double Ag = g * d;
        double Lbfsg = 92.5 + 20.0 * Math.log10(f) + 20.0 * Math.log10(d) + Ag;
        double Esp = 2.6 * (1.0 - Math.exp(-0.1 * (dlt + dlr))) * Math.log10(p / 50.0);
        double Esb = 2.6 * (1.0 - Math.exp(-0.1 * (dlt + dlr))) * Math.log10(b0 / 50.0);
        double Lb0p = Lbfsg + Esp;
        double Lb0b = Lbfsg + Esb;
        double[] Lb = new double[]{Lbfsg, Lb0p, Lb0b};
        return Lb;
    }

    public double p676_ga_ver10(double f, double p, double rho, double T2) {
        double Fi;
        double delta;
        double df;
        double Si;
        double fi;
        int i;
        double[][] oxigen = new double[][]{{50.474214, 0.975, 9.651, 6.69, 0.0, 2.566, 6.85}, {50.987745, 2.529, 8.653, 7.17, 0.0, 2.246, 6.8}, {51.50336, 6.193, 7.709, 7.64, 0.0, 1.947, 6.729}, {52.021429, 14.32, 6.819, 8.11, 0.0, 1.667, 6.64}, {52.542418, 31.24, 5.983, 8.58, 0.0, 1.388, 6.526}, {53.066934, 64.29, 5.201, 9.06, 0.0, 1.349, 6.206}, {53.595775, 124.6, 4.474, 9.55, 0.0, 2.227, 5.085}, {54.130025, 227.3, 3.8, 9.96, 0.0, 3.17, 3.75}, {54.67118, 389.7, 3.182, 10.37, 0.0, 3.558, 2.654}, {55.221384, 627.1, 2.618, 10.89, 0.0, 2.56, 2.952}, {55.783815, 945.3, 2.109, 11.34, 0.0, -1.172, 6.135}, {56.264774, 543.4, 0.014, 17.03, 0.0, 3.525, -0.978}, {56.363399, 1331.8, 1.654, 11.89, 0.0, -2.378, 6.547}, {56.968211, 1746.6, 1.255, 12.23, 0.0, -3.545, 6.451}, {57.612486, 2120.1, 0.91, 12.62, 0.0, -5.416, 6.056}, {58.323877, 2363.7, 0.621, 12.95, 0.0, -1.932, 0.436}, {58.446588, 1442.1, 0.083, 14.91, 0.0, 6.768, -1.273}, {59.164204, 2379.9, 0.387, 13.53, 0.0, -6.561, 2.309}, {59.590983, 2090.7, 0.207, 14.08, 0.0, 6.957, -0.776}, {60.306056, 2103.4, 0.207, 14.15, 0.0, -6.395, 0.699}, {60.434778, 2438.0, 0.386, 13.39, 0.0, 6.342, -2.825}, {61.150562, 2479.5, 0.621, 12.92, 0.0, 1.014, -0.584}, {61.800158, 2275.9, 0.91, 12.63, 0.0, 5.014, -6.619}, {62.41122, 1915.4, 1.255, 12.17, 0.0, 3.029, -6.759}, {62.486253, 1503.0, 0.083, 15.13, 0.0, -4.499, 0.844}, {62.997984, 1490.2, 1.654, 11.74, 0.0, 1.856, -6.675}, {63.568526, 1078.0, 2.108, 11.34, 0.0, 0.658, -6.139}, {64.127775, 728.7, 2.617, 10.88, 0.0, -3.036, -2.895}, {64.67891, 461.3, 3.181, 10.38, 0.0, -3.968, -2.59}, {65.224078, 274.0, 3.8, 9.96, 0.0, -3.528, -3.68}, {65.764779, 153.0, 4.473, 9.55, 0.0, -2.548, -5.002}, {66.302096, 80.4, 5.2, 9.06, 0.0, -1.66, -6.091}, {66.836834, 39.8, 5.982, 8.58, 0.0, -1.68, -6.393}, {67.369601, 18.56, 6.818, 8.11, 0.0, -1.956, -6.475}, {67.900868, 8.172, 7.708, 7.64, 0.0, -2.216, -6.545}, {68.431006, 3.397, 8.652, 7.17, 0.0, -2.492, -6.6}, {68.960312, 1.334, 9.65, 6.69, 0.0, -2.773, -6.65}, {118.750334, 940.3, 0.01, 16.64, 0.0, -0.439, 0.079}, {368.498246, 67.4, 0.048, 16.4, 0.0, 0.0, 0.0}, {424.76302, 637.7, 0.044, 16.4, 0.0, 0.0, 0.0}, {487.249273, 237.4, 0.049, 16.0, 0.0, 0.0, 0.0}, {715.392902, 98.1, 0.145, 16.0, 0.0, 0.0, 0.0}, {773.83949, 572.3, 0.141, 16.2, 0.0, 0.0, 0.0}, {834.145546, 183.1, 0.145, 14.7, 0.0, 0.0, 0.0}};
        double[][] vapor = new double[][]{{22.23508, 0.113, 2.143, 28.11, 0.69, 4.8, 1.0}, {67.80396, 0.0012, 8.735, 28.58, 0.69, 4.93, 0.82}, {119.99594, 8.0E-4, 8.356, 29.48, 0.7, 4.78, 0.79}, {183.310091, 2.42, 0.668, 30.5, 0.64, 5.3, 0.85}, {321.225644, 0.0483, 6.181, 23.03, 0.67, 4.69, 0.54}, {325.152919, 1.499, 1.54, 27.83, 0.68, 4.85, 0.74}, {336.222601, 0.0011, 9.829, 26.93, 0.69, 4.74, 0.61}, {380.197372, 11.52, 1.048, 28.73, 0.54, 5.38, 0.89}, {390.134508, 0.0046, 7.35, 21.52, 0.63, 4.81, 0.55}, {437.346667, 0.065, 5.05, 18.45, 0.6, 4.23, 0.48}, {439.150812, 0.9218, 3.596, 21.0, 0.63, 4.29, 0.52}, {443.018295, 0.1976, 5.05, 18.6, 0.6, 4.23, 0.5}, {448.001075, 10.32, 1.405, 26.32, 0.66, 4.84, 0.67}, {470.888947, 0.3297, 3.599, 21.52, 0.66, 4.57, 0.65}, {474.689127, 1.262, 2.381, 23.55, 0.65, 4.65, 0.64}, {488.491133, 0.252, 2.853, 26.02, 0.69, 5.04, 0.72}, {503.568532, 0.039, 6.733, 16.12, 0.61, 3.98, 0.43}, {504.482692, 0.013, 6.733, 16.12, 0.61, 4.01, 0.45}, {547.67644, 9.701, 0.114, 26.0, 0.7, 4.5, 1.0}, {552.02096, 14.77, 0.114, 26.0, 0.7, 4.5, 1.0}, {556.936002, 487.4, 0.159, 32.1, 0.69, 4.11, 1.0}, {620.700807, 5.012, 2.2, 24.38, 0.71, 4.68, 0.68}, {645.866155, 0.0713, 8.58, 18.0, 0.6, 4.0, 0.5}, {658.00528, 0.3022, 7.82, 32.1, 0.69, 4.14, 1.0}, {752.033227, 239.6, 0.396, 30.6, 0.68, 4.09, 0.84}, {841.053973, 0.014, 8.18, 15.9, 0.33, 5.76, 0.45}, {859.962313, 0.1472, 7.989, 30.6, 0.68, 4.09, 0.84}, {899.306675, 0.0605, 7.917, 29.85, 0.68, 4.53, 0.9}, {902.616173, 0.0426, 8.432, 28.65, 0.7, 5.1, 0.95}, {906.207325, 0.1876, 5.111, 24.08, 0.7, 4.7, 0.53}, {916.171582, 8.34, 1.442, 26.7, 0.7, 4.78, 0.78}, {923.118427, 0.0869, 10.22, 29.0, 0.7, 5.0, 0.8}, {970.315022, 8.972, 1.92, 25.5, 0.64, 4.94, 0.67}, {987.926764, 132.1, 0.258, 29.85, 0.68, 4.55, 0.9}, {1780.0, 22300.0, 0.952, 176.2, 0.5, 30.5, 5.0}};
        double theta = 300.0 / T2;
        double e = rho * T2 / 216.7;
        double g_0 = 0.0;
        double SumSiFi = 0.0;
        double d = 5.6E-4 * (p + e) * Math.pow(theta, 0.8);
        double Ndf = f * p * theta * theta * (6.14E-5 / (d * (1.0 + Math.pow(f / d, 2.0))) + 1.4E-12 * p * Math.pow(theta, 1.5) / (1.0 + 1.9E-5 * Math.pow(f, 1.5)));
        for (i = 0; i < 44; ++i) {
            fi = oxigen[i][0];
            Si = oxigen[i][1] * 1.0E-7 * p * Math.pow(theta, 3.0) * Math.exp(oxigen[i][2] * (1.0 - theta));
            df = oxigen[i][3] * 1.0E-4 * (p * Math.pow(theta, 0.8 - oxigen[i][4]) + 1.1 * e * theta);
            df = Math.sqrt(df * df + 2.25E-6);
            delta = (oxigen[i][5] + oxigen[i][6] * theta) * 1.0E-4 * (p + e) * Math.pow(theta, 0.8);
            Fi = f / fi * ((df - delta * (fi - f)) / (Math.pow(fi - f, 2.0) + df * df) + (df - delta * (fi + f)) / (Math.pow(fi + f, 2.0) + df * df));
            if (f <= 118.750343) {
                SumSiFi += Si * Fi;
                continue;
            }
            if (i < 37) continue;
            SumSiFi += Si * Fi;
        }
        g_0 = 0.182 * f * (SumSiFi + Ndf);
        SumSiFi = 0.0;
        for (i = 0; i < 35; ++i) {
            fi = vapor[i][0];
            Si = vapor[i][1] * 0.1 * e * Math.pow(theta, 3.5) * Math.exp(vapor[i][2] * (1.0 - theta));
            df = vapor[i][3] * 1.0E-4 * (p * Math.pow(theta, vapor[i][4]) + vapor[i][5] * e * Math.pow(theta, vapor[i][6]));
            df = 0.535 * df + Math.sqrt(0.217 * df * df + 2.1316E-12 * fi * fi / theta);
            delta = 0.0;
            Fi = f / fi * ((df - delta * (fi - f)) / (Math.pow(fi - f, 2.0) + df * df) + (df - delta * (fi + f)) / (Math.pow(fi + f, 2.0) + df * df));
            SumSiFi += Si * Fi;
        }
        double g_w = 0.182 * f * SumSiFi;
        return g_0 + g_w;
    }

    public double p676_ga_ver11(double f, double p, double rho, double T2) {
        double Fi;
        double delta;
        double df;
        double Si;
        double fi;
        int i;
        double[][] oxigen = new double[][]{{50.474214, 0.975, 9.651, 6.69, 0.0, 2.566, 6.85}, {50.987745, 2.529, 8.653, 7.17, 0.0, 2.246, 6.8}, {51.50336, 6.193, 7.709, 7.64, 0.0, 1.947, 6.729}, {52.021429, 14.32, 6.819, 8.11, 0.0, 1.667, 6.64}, {52.542418, 31.24, 5.983, 8.58, 0.0, 1.388, 6.526}, {53.066934, 64.29, 5.201, 9.06, 0.0, 1.349, 6.206}, {53.595775, 124.6, 4.474, 9.55, 0.0, 2.227, 5.085}, {54.130025, 227.3, 3.8, 9.96, 0.0, 3.17, 3.75}, {54.67118, 389.7, 3.182, 10.37, 0.0, 3.558, 2.654}, {55.221384, 627.1, 2.618, 10.89, 0.0, 2.56, 2.952}, {55.783815, 945.3, 2.109, 11.34, 0.0, -1.172, 6.135}, {56.264774, 543.4, 0.014, 17.03, 0.0, 3.525, -0.978}, {56.363399, 1331.8, 1.654, 11.89, 0.0, -2.378, 6.547}, {56.968211, 1746.6, 1.255, 12.23, 0.0, -3.545, 6.451}, {57.612486, 2120.1, 0.91, 12.62, 0.0, -5.416, 6.056}, {58.323877, 2363.7, 0.621, 12.95, 0.0, -1.932, 0.436}, {58.446588, 1442.1, 0.083, 14.91, 0.0, 6.768, -1.273}, {59.164204, 2379.9, 0.387, 13.53, 0.0, -6.561, 2.309}, {59.590983, 2090.7, 0.207, 14.08, 0.0, 6.957, -0.776}, {60.306056, 2103.4, 0.207, 14.15, 0.0, -6.395, 0.699}, {60.434778, 2438.0, 0.386, 13.39, 0.0, 6.342, -2.825}, {61.150562, 2479.5, 0.621, 12.92, 0.0, 1.014, -0.584}, {61.800158, 2275.9, 0.91, 12.63, 0.0, 5.014, -6.619}, {62.41122, 1915.4, 1.255, 12.17, 0.0, 3.029, -6.759}, {62.486253, 1503.0, 0.083, 15.13, 0.0, -4.499, 0.844}, {62.997984, 1490.2, 1.654, 11.74, 0.0, 1.856, -6.675}, {63.568526, 1078.0, 2.108, 11.34, 0.0, 0.658, -6.139}, {64.127775, 728.7, 2.617, 10.88, 0.0, -3.036, -2.895}, {64.67891, 461.3, 3.181, 10.38, 0.0, -3.968, -2.59}, {65.224078, 274.0, 3.8, 9.96, 0.0, -3.528, -3.68}, {65.764779, 153.0, 4.473, 9.55, 0.0, -2.548, -5.002}, {66.302096, 80.4, 5.2, 9.06, 0.0, -1.66, -6.091}, {66.836834, 39.8, 5.982, 8.58, 0.0, -1.68, -6.393}, {67.369601, 18.56, 6.818, 8.11, 0.0, -1.956, -6.475}, {67.900868, 8.172, 7.708, 7.64, 0.0, -2.216, -6.545}, {68.431006, 3.397, 8.652, 7.17, 0.0, -2.492, -6.6}, {68.960312, 1.334, 9.65, 6.69, 0.0, -2.773, -6.65}, {118.750334, 940.3, 0.01, 16.64, 0.0, -0.439, 0.079}, {368.498246, 67.4, 0.048, 16.4, 0.0, 0.0, 0.0}, {424.76302, 637.7, 0.044, 16.4, 0.0, 0.0, 0.0}, {487.249273, 237.4, 0.049, 16.0, 0.0, 0.0, 0.0}, {715.392902, 98.1, 0.145, 16.0, 0.0, 0.0, 0.0}, {773.83949, 572.3, 0.141, 16.2, 0.0, 0.0, 0.0}, {834.145546, 183.1, 0.145, 14.7, 0.0, 0.0, 0.0}};
        double[][] vapor = new double[][]{{22.23508, 0.1079, 2.144, 26.38, 0.76, 5.087, 1.0}, {67.80396, 0.0011, 8.732, 28.58, 0.69, 4.93, 0.82}, {119.99594, 7.0E-4, 8.353, 29.48, 0.7, 4.78, 0.79}, {183.310087, 2.273, 0.668, 29.06, 0.77, 5.022, 0.85}, {321.22563, 0.047, 6.179, 24.04, 0.67, 4.398, 0.54}, {325.152888, 1.514, 1.541, 28.23, 0.64, 4.893, 0.74}, {336.227764, 0.001, 9.825, 26.93, 0.69, 4.74, 0.61}, {380.197353, 11.67, 1.048, 28.11, 0.54, 5.063, 0.89}, {390.134508, 0.0045, 7.347, 21.52, 0.63, 4.81, 0.55}, {437.346667, 0.0632, 5.048, 18.45, 0.6, 4.23, 0.48}, {439.150807, 0.9098, 3.595, 20.07, 0.63, 4.483, 0.52}, {443.018343, 0.192, 5.048, 15.55, 0.6, 5.083, 0.5}, {448.001085, 10.41, 1.405, 25.64, 0.66, 5.028, 0.67}, {470.888999, 0.3254, 3.597, 21.34, 0.66, 4.506, 0.65}, {474.689092, 1.26, 2.379, 23.2, 0.65, 4.804, 0.64}, {488.490108, 0.2529, 2.852, 25.86, 0.69, 5.201, 0.72}, {503.568532, 0.0372, 6.731, 16.12, 0.61, 3.98, 0.43}, {504.482692, 0.0124, 6.731, 16.12, 0.61, 4.01, 0.45}, {547.67644, 0.9785, 0.158, 26.0, 0.7, 4.5, 1.0}, {552.02096, 0.184, 0.158, 26.0, 0.7, 4.5, 1.0}, {556.935985, 497.0, 0.159, 30.86, 0.69, 4.552, 1.0}, {620.700807, 5.015, 2.391, 24.38, 0.71, 4.856, 0.68}, {645.766085, 0.0067, 8.633, 18.0, 0.6, 4.0, 0.5}, {658.00528, 0.2732, 7.816, 32.1, 0.69, 4.14, 1.0}, {752.033113, 243.4, 0.396, 30.86, 0.68, 4.352, 0.84}, {841.051732, 0.0134, 8.177, 15.9, 0.33, 5.76, 0.45}, {859.965698, 0.1325, 8.055, 30.6, 0.68, 4.09, 0.84}, {899.303175, 0.0547, 7.914, 29.85, 0.68, 4.53, 0.9}, {902.611085, 0.0386, 8.429, 28.65, 0.7, 5.1, 0.95}, {906.205957, 0.1836, 5.11, 24.08, 0.7, 4.7, 0.53}, {916.171582, 8.4, 1.441, 26.73, 0.7, 5.15, 0.78}, {923.112692, 0.0079, 10.293, 29.0, 0.7, 5.0, 0.8}, {970.315022, 9.009, 1.919, 25.5, 0.64, 4.94, 0.67}, {987.926764, 134.6, 0.257, 29.85, 0.68, 4.55, 0.9}, {1780.0, 17506.0, 0.952, 196.3, 2.0, 24.15, 5.0}};
        double theta = 300.0 / T2;
        double e = rho * T2 / 216.7;
        double g_0 = 0.0;
        double SumSiFi = 0.0;
        double d = 5.6E-4 * (p + e) * Math.pow(theta, 0.8);
        double Ndf = f * p * theta * theta * (6.14E-5 / (d * (1.0 + Math.pow(f / d, 2.0))) + 1.4E-12 * p * Math.pow(theta, 1.5) / (1.0 + 1.9E-5 * Math.pow(f, 1.5)));
        for (i = 0; i < 44; ++i) {
            fi = oxigen[i][0];
            Si = oxigen[i][1] * 1.0E-7 * p * Math.pow(theta, 3.0) * Math.exp(oxigen[i][2] * (1.0 - theta));
            df = oxigen[i][3] * 1.0E-4 * (p * Math.pow(theta, 0.8 - oxigen[i][4]) + 1.1 * e * theta);
            df = Math.sqrt(df * df + 2.25E-6);
            delta = (oxigen[i][5] + oxigen[i][6] * theta) * 1.0E-4 * (p + e) * Math.pow(theta, 0.8);
            Fi = f / fi * ((df - delta * (fi - f)) / (Math.pow(fi - f, 2.0) + df * df) + (df - delta * (fi + f)) / (Math.pow(fi + f, 2.0) + df * df));
            SumSiFi += Si * Fi;
        }
        g_0 = 0.182 * f * (SumSiFi + Ndf);
        SumSiFi = 0.0;
        for (i = 0; i < 35; ++i) {
            fi = vapor[i][0];
            Si = vapor[i][1] * 0.1 * e * Math.pow(theta, 3.5) * Math.exp(vapor[i][2] * (1.0 - theta));
            df = vapor[i][3] * 1.0E-4 * (p * Math.pow(theta, vapor[i][4]) + vapor[i][5] * e * Math.pow(theta, vapor[i][6]));
            df = 0.535 * df + Math.sqrt(0.217 * df * df + 2.1316E-12 * fi * fi / theta);
            delta = 0.0;
            Fi = f / fi * ((df - delta * (fi - f)) / (Math.pow(fi - f, 2.0) + df * df) + (df - delta * (fi + f)) / (Math.pow(fi + f, 2.0) + df * df));
            SumSiFi += Si * Fi;
        }
        double g_w = 0.182 * f * SumSiFi;
        return g_0 + g_w;
    }

    public double inv_cum_norm(double x) {
        if (x < 1.0E-6) {
            x = 1.0E-6;
        }
        double tx = Math.sqrt(-2.0 * Math.log(x));
        double C0 = 2.515516698;
        double C1 = 0.802853;
        double C2 = 0.010328;
        double D1 = 1.432788;
        double D2 = 0.189269;
        double D3 = 0.001308;
        double ksi = ((C2 * tx + C1) * tx + C0) / (((D3 * tx + D2) * tx + D1) * tx + 1.0);
        return ksi - tx;
    }

    public double longest_cont_dist(double[] d, int[] zone, int zone_r) {
        double dm = 0.0;
        double dmc = 0.0;
        int n = d.length;
        if (zone_r == 12) {
            for (int i = 0; i < n; ++i) {
                if (zone[i] == 1 || zone[i] == 2) {
                    double delta = i == 0 ? (d[1] - d[0]) / 2.0 : (i == n - 1 ? (d[n - 1] - d[n - 2]) / 2.0 : (d[i + 1] - d[i - 1]) / 2.0);
                    dm = Math.max(dm, dmc += delta);
                    continue;
                }
                dmc = 0.0;
            }
            return dm;
        }
        for (int i = 0; i < n; ++i) {
            if (zone[i] == zone_r) {
                double delta = i == 0 ? (d[1] - d[0]) / 2.0 : (i == n - 1 ? (d[n - 1] - d[n - 2]) / 2.0 : (d[i + 1] - d[i - 1]) / 2.0);
                dm = Math.max(dm, dmc += delta);
                continue;
            }
            dmc = 0.0;
        }
        return dm;
    }

    public double path_fraction_sea(double[] d, int[] zone, int zone_r) {
        double dm = 0.0;
        int n = d.length;
        for (int i = 0; i < n; ++i) {
            if (zone[i] != zone_r) continue;
            double delta = i == 0 ? (d[1] - d[0]) / 2.0 : (i == n - 1 ? (d[n - 1] - d[n - 2]) / 2.0 : (d[i + 1] - d[i - 1]) / 2.0);
            dm += delta;
        }
        return dm / (d[n - 1] - d[0]);
    }

    public double dl_bull(double[] rDisti, double[] rhi, double rhts, double rhrs, double rAe, double rFreq) {
        double rHi = 0.0;
        double rLambda = 0.3 / rFreq;
        double rCe = 1.0 / rAe;
        double rLuc = 0.0;
        int n = rDisti.length;
        double rDist = rDisti[n - 1] - rDisti[0];
        double rStim = (rhi[1] + 500.0 * rCe * rDisti[1] * (rDist - rDisti[1]) - rhts) / rDisti[1];
        for (int i = 2; i < rDisti.length; ++i) {
            double rStimi = (rhi[i] + 500.0 * rCe * rDisti[i] * (rDist - rDisti[i]) - rhts) / rDisti[i];
            rStim = Math.max(rStim, rStimi);
        }
        double rStr = (rhrs - rhts) / rDist;
        if (rStim < rStr) {
            double rnumax = rhi[1] + 500.0 * rCe * rDisti[1] * (rDist - rDisti[1]) - (rhts * (rDist - rDisti[1]) + rhrs * rDisti[1]) / rDist;
            rnumax *= Math.sqrt(0.002 * rDist / (rLambda * rDisti[1] * (rDist - rDisti[1])));
            for (int i = 2; i < rDisti.length; ++i) {
                double rnumai = rhi[i] + 500.0 * rCe * rDisti[i] * (rDist - rDisti[i]) - (rhts * (rDist - rDisti[i]) + rhrs * rDisti[i]) / rDist;
                rnumax = Math.max(rnumai *= Math.sqrt(0.002 * rDist / (rLambda * rDisti[i] * (rDist - rDisti[i]))), rnumax);
            }
            rLuc = 0.0;
            if (rnumax > -0.78) {
                rLuc = this.Jfunction(rnumax);
            }
        } else {
            double rSrim = (rhi[1] + 500.0 * rCe * rDisti[1] * (rDist - rDisti[1]) - rhrs) / (rDist - rDisti[1]);
            for (int i = 2; i < rDisti.length; ++i) {
                double rSrimi = (rhi[i] + 500.0 * rCe * rDisti[i] * (rDist - rDisti[i]) - rhrs) / (rDist - rDisti[i]);
                rSrim = Math.max(rSrim, rSrimi);
            }
            double rdbp = (rhrs - rhts + rSrim * rDist) / (rStim + rSrim);
            double rnub = rhts + rStim * rdbp - (rhts * (rDist - rdbp) + rhrs * rdbp) / rDist;
            rnub *= Math.sqrt(0.002 * rDist / (rLambda * rdbp * (rDist - rdbp)));
            rLuc = 0.0;
            if (rnub > -0.78) {
                rLuc = this.Jfunction(rnub);
            }
        }
        return rLuc + (1.0 - Math.exp(-rLuc / 6.0)) * (10.0 + 0.02 * rDist);
    }

    public double dl_se_ft_inner(double repsr, double rsigma, double rDist, double rhte, double rhre, double radft, double rFreq, double rpol) {
        double rLdft = 0.0;
        double rK = 0.036 * Math.pow(radft * rFreq, -0.3333333333333333) * Math.pow(Math.pow(repsr - 1.0, 2.0) + Math.pow(18.0 * rsigma / rFreq, 2.0), -0.25);
        if (rpol == 2.0) {
            rK *= Math.sqrt(Math.pow(repsr, 2.0) + Math.pow(18.0 * rsigma / rFreq, 2.0));
        }
        double rbeta_dft = (1.0 + 1.6 * Math.pow(rK, 2.0) + 0.67 * Math.pow(rK, 4.0)) / (1.0 + 4.5 * Math.pow(rK, 2.0) + 1.53 * Math.pow(rK, 4.0));
        double rX = 21.88 * rbeta_dft * Math.pow(rFreq / (radft * radft), 0.3333333333333333) * rDist;
        double rYt = 0.9575 * rbeta_dft * Math.pow(rFreq * rFreq / radft, 0.3333333333333333) * rhte;
        double rYr = 0.9575 * rbeta_dft * Math.pow(rFreq * rFreq / radft, 0.3333333333333333) * rhre;
        double rFx = 0.0;
        rFx = rX >= 1.6 ? 11.0 + 10.0 * Math.log10(rX) - 17.6 * rX : -20.0 * Math.log10(rX) - 5.6488 * Math.pow(rX, 1.425);
        double rBt = rbeta_dft * rYt;
        double rBr = rbeta_dft * rYr;
        double rGYt = 0.0;
        double rGYr = 0.0;
        rGYt = rBt > 2.0 ? 17.6 * Math.pow(rBt - 1.1, 0.5) - 5.0 * Math.log10(rBt - 1.1) - 8.0 : 20.0 * Math.log10(rBt + 0.1 * Math.pow(rBt, 3.0));
        rGYr = rBr > 2.0 ? 17.6 * Math.pow(rBr - 1.1, 0.5) - 5.0 * Math.log10(rBr - 1.1) - 8.0 : 20.0 * Math.log10(rBr + 0.1 * Math.pow(rBr, 3.0));
        double rLimit = 2.0 + 20.0 * Math.log10(rK);
        rGYt = Math.max(rGYt, rLimit);
        rGYr = Math.max(rGYr, rLimit);
        rLdft = -rFx - rGYt - rGYr;
        return rLdft;
    }

    public double dl_se_ft(double d, double hte, double hre, double adft, double f, double omega, double pol) {
        double epsr = 22.0;
        double sigma = 0.003;
        double Ldft_land = this.dl_se_ft_inner(epsr, sigma, d, hte, hre, adft, f, pol);
        epsr = 80.0;
        sigma = 5.0;
        double Ldft_sea = this.dl_se_ft_inner(epsr, sigma, d, hte, hre, adft, f, pol);
        return omega * Ldft_sea + (1.0 - omega) * Ldft_land;
    }

    public double dl_se(double rDist, double rhte, double rhre, double rap, double rFreq, double omega, double rpol) {
        double rLambda = 0.3 / rFreq;
        double rLdsph = 0.0;
        double rdlos = Math.sqrt(2.0 * rap) * (Math.sqrt(0.001 * rhte) + Math.sqrt(0.001 * rhre));
        if (rDist >= rdlos) {
            rLdsph = this.dl_se_ft(rDist, rhte, rhre, rap, rFreq, omega, rpol);
            return rLdsph;
        }
        double rc = (rhte - rhre) / (rhte + rhre);
        double rm = 250.0 * rDist * rDist / (rap * (rhte + rhre));
        double rb = 2.0 * Math.sqrt((rm + 1.0) / (3.0 * rm)) * Math.cos(1.0471975511965976 + 0.3333333333333333 * Math.acos(3.0 * rc / 2.0 * Math.sqrt(3.0 * rm / Math.pow(rm + 1.0, 3.0))));
        double rdse1 = rDist / 2.0 * (1.0 + rb);
        double rdse2 = rDist - rdse1;
        double rhse = (rhte - 500.0 * rdse1 * rdse1 / rap) * rdse2 + (rhre - 500.0 * rdse2 * rdse2 / rap) * rdse1;
        double rhreq = 17.456 * Math.sqrt(rdse1 * rdse2 * rLambda / rDist);
        if ((rhse /= rDist) > rhreq) {
            rLdsph = 0.0;
            return rLdsph;
        }
        double raem = 500.0 * Math.pow(rDist / (Math.sqrt(rhte) + Math.sqrt(rhre)), 2.0);
        double rLdft = this.dl_se_ft(rDist, rhte, rhre, raem, rFreq, omega, rpol);
        if (rLdft < 0.0) {
            rLdsph = 0.0;
            return rLdsph;
        }
        rLdsph = (1.0 - rhse / rhreq) * rLdft;
        return rLdsph;
    }

    public double[] dl_p(double[] d, double[] h, double hts, double hrs, double hstd, double hsrd, double f, double omega, double p, double b0, double DN, double pol) {
        double[] aa = this.earth_rad_eff(DN);
        double ae = aa[0];
        double ab = aa[1];
        double ap = ae;
        double Ld50 = this.dl_delta_bull(d, h, hts, hrs, hstd, hsrd, ap, f, omega, pol);
        double Ldp = 0.0;
        double[] Ldout = new double[2];
        if (p == 50.0) {
            Ldp = Ld50;
        }
        if (p < 50.0) {
            ap = ab;
            double Ldb = this.dl_delta_bull(d, h, hts, hrs, hstd, hsrd, ap, f, omega, pol);
            double Fi = 1.0;
            if (p > b0) {
                Fi = this.inv_cum_norm(p / 100.0) / this.inv_cum_norm(b0 / 100.0);
            }
            Ldp = Ld50 + Fi * (Ldb - Ld50);
        }
        Ldout[0] = Ldp;
        Ldout[1] = Ld50;
        return Ldout;
    }

    public double[] earth_rad_eff(double DN) {
        double k50 = 157.0 / (157.0 - DN);
        double ae = 6371.0 * k50;
        double kbeta = 3.0;
        double ab = 6371.0 * kbeta;
        double[] aa = new double[]{ae, ab};
        return aa;
    }

    public double dl_delta_bull(double[] d, double[] h, double hts, double hrs, double hstd, double hsrd, double ap, double f, double omega, double pol) {
        double Lbulla = this.dl_bull(d, h, hts, hrs, ap, f);
        double hts1 = hts - hstd;
        double hrs1 = hrs - hsrd;
        int n = d.length;
        double[] h1 = new double[n];
        for (int i = 0; i < n; ++i) {
            h1[i] = 0.0;
        }
        double Lbulls = this.dl_bull(d, h1, hts1, hrs1, ap, f);
        double hte = hts1;
        double hre = hrs1;
        double dtot = d[n - 1] - d[0];
        double Ldsph = this.dl_se(dtot, hte, hre, ap, f, omega, pol);
        return Lbulla + Math.max(Ldsph - Lbulls, 0.0);
    }

    public double[] closs_corr(double f, double[] d, double[] h, int[] zone, double htg, double hrg, double ha_t, double ha_r, double dk_t, double dk_r) {
        int kk;
        double Ffc;
        int index1 = 0;
        int index2 = d.length - 1;
        double htgc = htg;
        double hrgc = hrg;
        double Aht = 0.0;
        double Ahr = 0.0;
        double ha = ha_t;
        double dk = dk_t;
        if (ha > htg) {
            Ffc = 0.25 + 0.375 * (1.0 + Math.tanh(7.5 * (f - 0.5)));
            Aht = 10.25 * Ffc * Math.exp(-dk) * (1.0 - Math.tanh(6.0 * (htg / ha - 0.625))) - 0.33;
            for (kk = 0; kk < d.length; ++kk) {
                if (!(d[kk] >= dk)) continue;
                index1 = kk;
                break;
            }
            htgc = ha_t;
        }
        ha = ha_r;
        dk = dk_r;
        if (ha > hrg) {
            Ffc = 0.25 + 0.375 * (1.0 + Math.tanh(7.5 * (f - 0.5)));
            Ahr = 10.25 * Ffc * Math.exp(-dk) * (1.0 - Math.tanh(6.0 * (hrg / ha - 0.625))) - 0.33;
            for (kk = d.length - 1; kk >= 0; --kk) {
                if (!(d[kk] <= d[d.length - 1] - dk)) continue;
                index2 = kk;
                break;
            }
            hrgc = ha_r;
        }
        double[] out = new double[]{index1, index2, htgc, hrgc, Aht, Ahr};
        return out;
    }

    @Override
    public Description description() {
        return new DescriptionImpl("ITU-R P.452-16", "<b><u>Frequency range:</u></b><br>about 0.1 GHz to 50 GHz<br><b><u>Distance range:</u></b><br>up to a distance limit of 10 000 km<br><b><u>Typical application area:</u></b><br>Prediction method for the evaluation of interference between stations on the surface of the Earth at frequencies above about 0.1 GHz, accounting for clear-air interference mechanisms. Note that only flat terrain (h = 0 masl) and inland paths are considered.");
    }
}

