/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.propagation;

import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.plugin.propagation.P452ver14Input;
import org.seamcat.model.plugin.propagation.PropagationModelPlugin;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.Origin;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.result.DescriptionImpl;

public class P452ver14PropagationModel
implements PropagationModelPlugin<P452ver14Input> {
    private static final double EARTHRADIUS_IN_KM = 6371.0;
    private Double rPressure = 1013.25;
    private Double refrIndexGradient = 40.0;
    Double rTemperature = 15.0;
    Double rLat = 45.0;
    Double rAht = 0.0;
    Double rAhr = 0.0;
    Double rGTx = 0.0;
    Double rGRx = 0.0;
    Double rNo = 325.0;
    public double rBeta0 = 0.0;
    double rLd50 = 0.0;
    double rLdBeta = 0.0;
    double rLB0p = 0.0;
    double rLb0Beta = 0.0;
    double rLdp = 0.0;
    double rLbd50 = 0.0;
    double rDistIm50 = 0.0;
    double rDistIt50 = 0.0;
    double rDistIr50 = 0.0;
    double rLt50 = 0.0;
    double rLr50 = 0.0;
    double rHm = 0.0;
    double rW = 0.0;

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, P452ver14Input input, Validator validator) {
        if (context.getOrigin() == Origin.EPP) {
            return;
        }
        Distribution frequency = context.getFrequency();
        Bounds bounds = frequency.getBounds();
        if (bounds.getMin() < 700.0 || bounds.getMax() > 50000.0) {
            validator.error("P452-14 model applicable for frequencies in the range 700 MHz to 50 GHz");
        }
    }

    @Override
    public double evaluate(LinkResult linkResult, boolean variations, P452ver14Input input) {
        double rhi;
        double rFreq = linkResult.getFrequency();
        double rDist = linkResult.getTxRxDistance();
        double rHTx = linkResult.txAntenna().getHeight();
        double rHRx = linkResult.rxAntenna().getHeight();
        double rL = 0.0;
        double rStdDev = 0.0;
        this.rPressure = input.surfacePressure();
        this.refrIndexGradient = input.refractionIndex();
        this.rTemperature = input.surfaceTemperature();
        this.rLat = input.latitude();
        this.rAht = input.clutterLossTx();
        this.rAhr = input.clutterLossRx();
        this.rGTx = input.antennaGainTx();
        this.rGRx = input.antennaGainRx();
        this.rNo = input.seaLevelSurfaceRefractivity();
        double rGRx = this.getAntennaGainReceiverForTroposphericModel();
        double rGTx = this.getAntennaGainTransmitterForTroposphericModel();
        double rNo = this.getSeaLevelSurfaceRefractivity();
        double rRho1 = input.waterConcentration();
        double rRho2 = 7.5 + 2.5 * this.rW;
        double rP = input.timePercentage().trial();
        double rAe = this.medianEffectiveEarthRadiusCalculation(this.getRefrIndexGradient());
        double rABeta = this.betaPercentageEffectiveEarthRadiusCalculation();
        double rDistt = 0.0;
        double rDistr = 0.0;
        double rhj = rhi = 0.0;
        double rhts = rhi + rHTx;
        double rhrs = rhi + rHRx;
        double rStep = 0.01;
        int rTotalLength = Math.max(1, (int)Math.round(rDist / rStep));
        double[] rDisti = new double[rTotalLength];
        rDisti[0] = 0.0;
        for (int i = 1; i < rDisti.length; ++i) {
            rDisti[i] = rDisti[i - 1] + rStep;
        }
        double rThetaiMax = 0.0;
        double rThetajMax = 0.0;
        double rTemp1 = 0.0;
        double rTemp2 = 0.0;
        int rthetaiIndex = 0;
        int rthetajIndex = 0;
        for (int i = 1; i < rDisti.length; ++i) {
            rTemp1 = (rhi - rhts) / rDisti[i] - 1000.0 * rDisti[i] / (2.0 * rAe);
            if (i == 1) {
                rThetaiMax = rTemp1;
            }
            if (rTemp1 > rThetaiMax) {
                rThetaiMax = rTemp1;
                rthetaiIndex = i;
            }
            rTemp2 = (rhj - rhrs) / (rDist - rDisti[i]) - 1000.0 * (rDist - rDisti[i]) / (2.0 * rAe);
            if (i == 1) {
                rThetajMax = rTemp2;
            }
            if (!(rTemp2 > rThetajMax)) continue;
            rThetajMax = rTemp2;
            rthetajIndex = i;
        }
        double rThetat = 0.0;
        double rThetar = 0.0;
        double rThetatd = (rhrs - rhts) / rDist - 1000.0 * rDist / (2.0 * rAe);
        double rThetard = (rhts - rhrs) / rDist - 1000.0 * rDist / (2.0 * rAe);
        double rDistMedianDiffractionLoss = this.calculateDistMedianDiffractionLoss(rDist, rDisti, rhrs, rhts, rFreq / 1000.0, rhi, rAe);
        if (rThetaiMax > rThetatd) {
            rThetat = rThetaiMax;
            rThetar = rThetajMax;
            rDistt = rDisti[rthetaiIndex];
            rDistr = rDist - rDisti[rthetajIndex];
        } else {
            rThetat = rThetatd;
            rThetar = rThetard;
            rDistt = rDistMedianDiffractionLoss;
            rDistr = rDist - rDistMedianDiffractionLoss;
        }
        double rLbfsg = 92.5 + 20.0 * Math.log10(rFreq / 1000.0) + 20.0 * Math.log10(rDist) + this.attenuationByAtmosphericGasesP676ver8(rFreq / 1000.0, rRho2, this.rPressure, this.rTemperature);
        double rLbs = this.troposhericScatter(rFreq / 1000.0, rDist, rhts, rhrs, rP, rGRx, rGTx, rNo, rThetat, rThetar, rAe, rRho1, this.rPressure, this.rTemperature);
        double rLba = this.ductingLayerReflection(rFreq / 1000.0, rDistt, rDistr, rP, rThetat, rThetar, rhts, rhrs, rDist, rAe, rRho2, this.rPressure, this.rTemperature);
        double rLbd = this.diffractionLossP452(rFreq / 1000.0, rDist, rP, rDistt, rDistr, rLbfsg, rDisti, rhrs, rhts, rhi, rAe, rABeta, this.rBeta0);
        this.rAht = this.getAdditionalClutterLossesTransmitter();
        this.rAhr = this.getAdditionalClutterLossesReceiver();
        rL = input.diffraction() && !input.troposphericScatter() && !input.layerReflection() ? rLbd + this.rAht + this.rAhr : (input.diffraction() && input.troposphericScatter() && !input.layerReflection() ? Math.min(rLbd, rLbs) + this.rAht + this.rAhr : (input.diffraction() && !input.troposphericScatter() && input.layerReflection() ? Math.min(rLbd, rLba) + this.rAht + this.rAhr : (!input.diffraction() && input.troposphericScatter() && !input.layerReflection() ? rLbs + this.rAht + this.rAhr : (!input.diffraction() && input.troposphericScatter() && input.layerReflection() ? Math.min(rLbs, rLba) + this.rAht + this.rAhr : (!input.diffraction() && !input.troposphericScatter() && input.layerReflection() ? rLba + this.rAht + this.rAhr : this.calculateOverallPrediction(rLbfsg, rLbd, rLba, rLbs, this.rAht, this.rAhr, this.rBeta0, rDisti, rDist, rDistt, rDistr, rP, rAe, rThetat, rThetar, this.rW, rhrs, rhts, rFreq / 1000.0, rhi, this.rLB0p, this.rLdp, this.rLb0Beta, this.rLbd50))))));
        if (variations) {
            rL += Factory.distributionFactory().getGaussianDistribution(0.0, rStdDev).trial();
        }
        if (Double.isInfinite(rL)) {
            rL = 20.0 * Math.log10(rFreq) - 100.0;
        }
        return rL;
    }

    public double angularDistance(double rDist, double rAe, double rThetat, double rThetar) {
        double rTheta = 0.0;
        rTheta = 1000.0 * rDist / rAe + rThetat + rThetar;
        return rTheta;
    }

    public double angularDistanceDependentLoss(double rFreq, double rDist, double rDistt, double rDistr, double rTimePercentage, double rThetat, double rThetar, double rAe, double rHTx, double rHRx) {
        double rAd = 0.0;
        double rGammaD = 0.0;
        double rThetaPrime = 0.0;
        double rThetatPrime = 0.0;
        double rThetarPrime = 0.0;
        double rAp = 0.0;
        double rEpsilon = 3.5;
        double rTau = 0.0;
        double rAlpha = 0.0;
        double rNu2 = 0.0;
        double rNu3 = 0.0;
        double rNu1 = 0.0;
        double rNu4 = 0.0;
        double rBeta = 0.0;
        double rGammaCapital = 0.0;
        double rDI = Math.min(rDist - rDistt - rDistr, 40.0);
        rNu3 = this.rHm <= 10.0 ? 1.0 : Math.exp(-4.6 * Math.pow(10.0, -5.0) * (this.rHm - 10.0) * (43.0 + 6.0 * rDI));
        rTau = 1.0 - Math.exp(-(4.12 * Math.pow(10.0, -4.0) * Math.pow(rDist, 2.41)));
        double rValue1 = Math.pow(10.0, -rDist / (16.0 - 6.6 * rTau));
        double rValue3 = Math.pow(10.0, -(0.496 + 0.354 * rTau));
        double rValue2 = Math.pow(rValue3, 5.0);
        rNu1 = Math.pow(rValue1 + rValue2, 0.2);
        this.rLat = this.getLatitude();
        rNu4 = Math.abs(this.rLat) <= 70.0 ? Math.pow(10.0, (-0.935 + 0.0176 * Math.abs(this.rLat)) * Math.log10(rNu1)) : Math.pow(10.0, 0.3 * Math.log10(rNu1));
        this.rBeta0 = Math.abs(this.rLat) <= 70.0 ? Math.pow(10.0, -0.015 * Math.abs(this.rLat) + 1.67) * rNu1 * rNu4 : 4.17 * rNu1 * rNu4;
        rGammaD = 5.0 * Math.pow(10.0, -5.0) * rAe * Math.pow(rFreq, 0.3333333333333333);
        if (rThetat <= 0.1 * rDistt) {
            rThetatPrime = rThetat;
        } else if (rThetat > 0.1 * rDistt) {
            rThetatPrime = 0.1 * rDistt;
        }
        if (rThetar <= 0.1 * rDistr) {
            rThetarPrime = rThetar;
        } else if (rThetar > 0.1 * rDistr) {
            rThetarPrime = 0.1 * rDistr;
        }
        rThetaPrime = 1000.0 * rDist / rAe + rThetatPrime + rThetarPrime;
        rAlpha = -0.6 - rEpsilon * Math.pow(10.0, -9.0) * Math.pow(rDist, 3.1) * rTau;
        rAlpha = Math.max(rAlpha, -3.4);
        rNu2 = Math.pow(500.0 / rAe * (rDist * rDist / Math.pow(Math.sqrt(rHTx) + Math.sqrt(rHTx), 2.0)), rAlpha);
        rNu2 = Math.min(rNu2, 1.0);
        rBeta = this.rBeta0 * rNu2 * rNu3;
        rGammaCapital = 1.076 / Math.pow(2.0058 - Math.log10(rBeta), 1.012) * Math.exp(-(9.51 - 4.8 * Math.log10(rBeta) + 0.198 * Math.pow(Math.log10(rBeta), 2.0)) * Math.pow(10.0, -6.0) * Math.pow(rDist, 1.13));
        rAp = -12.0 + (1.2 + 3.7 * Math.pow(10.0, -3.0) * rDist) * Math.log10(rTimePercentage / rBeta) + 12.0 * Math.pow(rTimePercentage / rBeta, rGammaCapital);
        rAd = rGammaD * rThetaPrime + rAp;
        return rAd;
    }

    public double totalFixedCoulingLosses(double rFreq, double rDistt, double rDistr, double rThetat, double rThetar) {
        double rAf = 0.0;
        double rAlf = 0.0;
        double rAst = 0.0;
        double rAsr = 0.0;
        double rAct = 0.0;
        double rAcr = 0.0;
        double rThetatSecond = rThetat - 0.1 * rDistt;
        double rThetarSecond = rThetar - 0.1 * rDistr;
        rAlf = rFreq < 0.5 ? 45.375 - 137.0 * rFreq + 92.5 * rFreq * rFreq : 0.0;
        if (rThetatSecond > 0.0) {
            rAst = 20.0 * Math.log10(1.0 + 0.361 * rThetatSecond * Math.pow(rFreq * rDistt, 0.5)) + 0.264 * rThetatSecond * Math.pow(rFreq, 0.0);
        } else if (rThetatSecond <= 0.0) {
            rAst = 0.0;
        }
        if (rThetarSecond > 0.0) {
            rAsr = 20.0 * Math.log10(1.0 + 0.361 * rThetarSecond * Math.pow(rFreq * rDistr, 0.5)) + 0.264 * rThetarSecond * Math.pow(rFreq, 0.0);
        } else if (rThetarSecond <= 0.0) {
            rAsr = 0.0;
        }
        rAct = 0.0;
        rAcr = 0.0;
        rAf = 102.45 + 20.0 * Math.log10(rFreq) + 20.0 * Math.log10(rDistt + rDistr) + rAlf + rAst + rAsr + rAct + rAcr;
        return rAf;
    }

    public double ductingLayerReflection(double rFreq, double rDistt, double rDistr, double rTimePercentage, double rThetat, double rThetar, double rHTx, double rHRx, double rDist, double rAe, double rRho, double rPressure, double rTemperature) {
        double rDucting = 0.0;
        double rAf = 0.0;
        double rAd = 0.0;
        double rAg = 0.0;
        rAf = this.totalFixedCoulingLosses(rFreq, rDistt, rDistr, rThetat, rThetar);
        rAd = this.angularDistanceDependentLoss(rFreq, rDist, rDistt, rDistr, rTimePercentage, rThetat, rThetar, rAe, rHTx, rHRx);
        rAg = rDist * this.attenuationByAtmosphericGasesP676ver8(rFreq, rRho, rPressure, rTemperature);
        rDucting = rAf + rAd + rAg;
        return rDucting;
    }

    public double troposhericScatter(double rFreq, double rDist, double rHTx, double rHRx, double rTimePercentage, double rGRx, double rGTx, double rSeaLevelSurfaceRefractivity, double rThetat, double rThetar, double rAe, double rRho, double rPressure, double rTemperature) {
        double rTroposphericScatterLoss = 0.0;
        double rLf = 0.0;
        double rLc = 0.0;
        double rNo = 0.0;
        double rAg = 0.0;
        double rTheta = 0.0;
        rLf = 25.0 * Math.log10(rFreq) - 2.5 * Math.pow(Math.log10(rFreq / 2.0), 2.0);
        rLc = 0.051 * Math.exp(0.055 * (rGTx + rGRx));
        rNo = rSeaLevelSurfaceRefractivity;
        rAg = this.attenuationByAtmosphericGasesP676ver8(rFreq, rRho, rPressure, rTemperature);
        rTheta = this.angularDistance(rDist, rAe, rThetat, rThetar);
        rTroposphericScatterLoss = 190.0 + rLf + 20.0 * Math.log10(rDist) + 0.573 * rTheta - 0.15 * rNo + rLc + rAg - 10.1 * Math.pow(-Math.log10(rTimePercentage / 50.0), 0.7);
        return rTroposphericScatterLoss;
    }

    public double medianEffectiveEarthRadiusCalculation(double rRefrIndexGradient) {
        double rAe = 0.0;
        double rRe = 6371.0;
        double rKe50 = 157.0 / (157.0 - rRefrIndexGradient);
        rAe = rKe50 * rRe;
        return rAe;
    }

    public double betaPercentageEffectiveEarthRadiusCalculation() {
        double rAbeta = 0.0;
        double rRe = 6371.0;
        double rKbeta = 3.0;
        rAbeta = rKbeta * rRe;
        return rAbeta;
    }

    public double diffractionLossP452(double rFreq, double rDist, double rP, double rDistt, double rDistr, double rLbfsg, double[] rDisti, double rhrs, double rhts, double rhi, double rAe, double rABeta, double rBeta0) {
        double rLbd = 0.0;
        this.rLd50 = this.calculateMedianDiffractionLoss(rDist, rDisti, rhrs, rhts, rFreq, rhi, rAe);
        this.rLdBeta = this.calculateBetaPercentageDiffractionLoss(rDist, rDisti, rhrs, rhts, rFreq, rhi, rABeta);
        double rEsp = 2.6 * (1.0 - Math.exp(-0.1 * (rDistt + rDistr))) * Math.log10(rP / 50.0);
        double rEsbeta = 2.6 * (1.0 - Math.exp(-0.1 * (rDistt + rDistr))) * Math.log10(rBeta0 / 50.0);
        this.rLB0p = rLbfsg + rEsp;
        this.rLb0Beta = rLbfsg + rEsbeta;
        this.rLdp = this.rLd50 + this.Fi(rP, rBeta0) * (this.rLdBeta - this.rLd50);
        this.rLbd50 = rLbfsg + this.rLd50;
        rLbd = this.rLB0p + this.rLdp;
        return rLbd;
    }

    public double calculateDistMedianDiffractionLoss(double rDist, double[] rDisti, double rhrs, double rhts, double rFreq, double rhi, double rAe) {
        double rDist50per = 0.0;
        double zeta_m = 0.0;
        double rHi = 0.0;
        double rLambda = 0.3 / rFreq;
        zeta_m = Math.cos(Math.atan(0.001 * ((rhrs - rhts) / rDist)));
        double rTemp = 0.0;
        double rNu50 = 0.0;
        int rNu50Index = 0;
        for (int i = 0; i < rDisti.length; ++i) {
            rHi = rhi + 1000.0 * (rDisti[i] * (rDist - rDisti[i])) / (2.0 * rAe) - (rhts * (rDist - rDisti[i]) + rhrs * rDisti[i]) / rDist;
            rTemp = zeta_m * rHi * Math.sqrt(2.0 * rDist / (1000.0 * rLambda * rDisti[i] * (rDist - rDisti[i])));
            if (i == 0) {
                rNu50 = rTemp;
            }
            if (!(rTemp > rNu50)) continue;
            rNu50 = rTemp;
            rNu50Index = i;
        }
        rDist50per = rDisti[rNu50Index];
        return rDist50per;
    }

    public double calculateBetaPercentageDiffractionLoss(double rDist, double[] rDisti, double rhrs, double rhts, double rFreq, double rhi, double rABeta) {
        double rLdBeta = 0.0;
        double rHimBeta = 0.0;
        double rHitBeta = 0.0;
        double rHirBeta = 0.0;
        double rLambda = 0.3 / rFreq;
        double rLmBeta = 0.0;
        double rLtBeta = 0.0;
        double rLrBeta = 0.0;
        double rhim50 = rhi;
        double rhit50 = rhi;
        double rhir50 = rhi;
        double rZetam = 0.0;
        double rZetat = 0.0;
        double rZetar = 0.0;
        double rNumBeta = 0.0;
        double rNutBeta = 0.0;
        double rNurBeta = 0.0;
        rZetam = Math.cos(Math.atan(Math.pow(10.0, -3.0) * (rhrs - rhts) / rDist));
        rNumBeta = rZetam * (rHimBeta = rhim50 + 1000.0 * (this.rDistIm50 * (rDist - this.rDistIm50)) / (2.0 * rABeta) - (rhts * (rDist - this.rDistIm50) + rhrs * this.rDistIm50) / rDist) * Math.sqrt(2.0 * rDist / (1000.0 * rLambda * this.rDistIm50 * (rDist - this.rDistIm50)));
        rLmBeta = rNumBeta >= -0.78 ? this.Jfunction(rNumBeta) : 0.0;
        if (this.rLt50 == 0.0) {
            rLtBeta = 0.0;
        } else {
            rZetat = Math.cos(Math.atan(Math.pow(10.0, -3.0) * (rhim50 - rhts) / this.rDistIm50));
            rHitBeta = rhit50 + 1000.0 * (this.rDistIt50 * (this.rDistIm50 - this.rDistIt50)) / (2.0 * rABeta) - (rhts * (this.rDistIm50 - this.rDistIt50) + rhim50 * this.rDistIt50) / this.rDistIm50;
            rNutBeta = rZetat * rHitBeta * Math.sqrt(2.0 * this.rDistIm50 / (1000.0 * rLambda * this.rDistIt50 * (this.rDistIm50 - this.rDistIt50)));
        }
        rLtBeta = rNutBeta >= -0.78 ? this.Jfunction(rNutBeta) : 0.0;
        if (this.rLr50 == 0.0) {
            rLrBeta = 0.0;
        } else {
            rZetar = Math.cos(Math.atan(Math.pow(10.0, -3.0) * (rhrs - rhim50) / (rDist - this.rDistIm50)));
            rHirBeta = rhir50 + 1000.0 * ((this.rDistIr50 - this.rDistIm50) * (rDist - this.rDistIr50)) / (2.0 * rABeta) - (rhim50 * (rDist - this.rDistIr50) + rhrs * (this.rDistIr50 - this.rDistIm50)) / (rDist - this.rDistIm50);
            rNurBeta = rZetar * rHirBeta * Math.sqrt(2.0 * (rDist - this.rDistIm50) / (1000.0 * rLambda * (this.rDistIr50 - this.rDistIm50) * (rDist - this.rDistIr50)));
        }
        rLrBeta = rNurBeta >= -0.78 ? this.Jfunction(rNurBeta) : 0.0;
        rLdBeta = rNumBeta >= -0.78 ? rLmBeta + (1.0 - Math.exp(-rLmBeta / 6.0)) * (rLtBeta + rLrBeta + 10.0 + 0.04 * rDist) : 0.0;
        return rLdBeta;
    }

    public double calculateMedianDiffractionLoss(double rDist, double[] rDisti, double rhrs, double rhts, double rFreq, double rhi, double rAe) {
        double rHi = 0.0;
        double rLambda = 0.3 / rFreq;
        double rTempm = 0.0;
        double rNum50 = 0.0;
        int rNu50mIndex = 0;
        double rZetam = 0.0;
        rZetam = Math.cos(Math.atan(Math.pow(10.0, -3.0) * (rhrs - rhts) / rDist));
        for (int i = 0; i < rDisti.length; ++i) {
            rHi = rhi + 1000.0 * (rDisti[i] * (rDist - rDisti[i])) / (2.0 * rAe) - (rhts * (rDist - rDisti[i]) + rhrs * rDisti[i]) / rDist;
            rTempm = rZetam * rHi * Math.sqrt(2.0 * rDist / (1000.0 * rLambda * rDisti[i] * (rDist - rDisti[i])));
            if (i == 0) {
                rNum50 = rTempm;
            }
            if (!(rTempm > rNum50)) continue;
            rNum50 = rTempm;
            rNu50mIndex = i;
        }
        int rIndexm50 = rNu50mIndex;
        double rLm50 = 0.0;
        rLm50 = rNum50 >= -0.78 ? this.Jfunction(rNum50) : 0.0;
        double rhim50 = rhi;
        this.rDistIm50 = rDisti[rIndexm50];
        if (rLm50 == 0.0) {
            this.rLd50 = 0.0;
            this.rLdBeta = 0.0;
        } else {
            int i;
            if (rIndexm50 == 1) {
                this.rLt50 = 0.0;
            } else {
                double rTempt = 0.0;
                double rNut50 = 0.0;
                int rNu50tIndex = 0;
                double rZetat = 0.0;
                rZetat = Math.cos(Math.atan(Math.pow(10.0, -3.0) * (rhim50 - rhts) / this.rDistIm50));
                for (i = 0; i < rIndexm50; ++i) {
                    rHi = rhi + 1000.0 * (rDisti[i] * (this.rDistIm50 - rDisti[i])) / (2.0 * rAe) - (rhts * (this.rDistIm50 - rDisti[i]) + rhim50 * rDisti[i]) / this.rDistIm50;
                    rTempt = rZetat * rHi * Math.sqrt(2.0 * this.rDistIm50 / (1000.0 * rLambda * rDisti[i] * (this.rDistIm50 - rDisti[i])));
                    if (i == 0) {
                        rNut50 = rTempt;
                    }
                    if (!(rTempt > rNut50)) continue;
                    rNut50 = rTempt;
                    rNu50tIndex = i;
                }
                this.rDistIt50 = rDisti[rNu50tIndex];
                int rIndext50 = rNu50tIndex;
                this.rLt50 = rNut50 >= -0.78 && rIndexm50 >= 2 ? this.Jfunction(rNut50) : 0.0;
            }
            if (rIndexm50 == rDisti.length) {
                this.rLr50 = 0.0;
            } else {
                double rTempr = 0.0;
                double rNur50 = 0.0;
                int rNu50rIndex = 0;
                double rZetar = 0.0;
                rZetar = Math.cos(Math.atan(Math.pow(10.0, -3.0) * (rhrs - rhim50) / (rDist - this.rDistIm50)));
                for (i = rIndexm50 + 1; i < rDisti.length; ++i) {
                    rHi = rhi + 1000.0 * ((rDisti[i] - this.rDistIm50) * (rDist - rDisti[i])) / (2.0 * rAe) - (rhim50 * (rDist - rDisti[i]) + rhrs * (rDisti[i] - this.rDistIm50)) / (rDist - this.rDistIm50);
                    rTempr = rZetar * rHi * Math.sqrt(2.0 * (rDist - this.rDistIm50) / (1000.0 * rLambda * (rDisti[i] - this.rDistIm50) * (rDist - rDisti[i])));
                    if (i == rIndexm50 + 1) {
                        rNur50 = rTempr;
                    }
                    if (!(rTempr > rNur50)) continue;
                    rNur50 = rTempr;
                    rNu50rIndex = i;
                }
                this.rDistIr50 = rDisti[rNu50rIndex];
                int rIndexr50 = rNu50rIndex;
                this.rLr50 = rNur50 >= -0.78 && rIndexm50 < rDisti.length ? this.Jfunction(rNur50) : 0.0;
            }
        }
        this.rLd50 = rNum50 > -0.78 ? rLm50 + (1.0 - Math.exp(-rLm50 / 6.0)) * (this.rLt50 + this.rLr50 + 10.0 + 0.04 * rDist) : 0.0;
        return this.rLd50;
    }

    public double calculateOverallPrediction(double rLbfsg, double rLbd, double rLba, double rLbs, double rAht, double rAhr, double rBeta0, double[] rDisti, double rDist, double rDistt, double rDistr, double rP, double rAe, double rThetat, double rThetar, double rW, double rhrs, double rhts, double rFreq, double rhi, double rLB0p, double rLdp, double rLb0Beta, double rLbd50) {
        double rL = 0.0;
        double rZeta = 0.8;
        double rThetaCapital = 0.3;
        double rTheta = this.angularDistance(rDist, rAe, rThetat, rThetar);
        double rFactorj = rZeta * (rTheta - rThetaCapital) / rThetaCapital;
        double rFj = 1.0 - 0.5 * (1.0 + Math.tanh(3.0 * rFactorj));
        double rDsw = 20.0;
        double rKappa = 0.5;
        double rFactork = rKappa * (rDist - rDsw) / rDsw;
        double rFk = 1.0 - 0.5 * (1.0 + Math.tanh(3.0 * rFactork));
        double rLminB0p = 0.0;
        rLminB0p = rP < rBeta0 ? rLB0p + (1.0 - rW) * rLdp : rLbd50 + this.Fi(rP, rBeta0) * (rLb0Beta + (1.0 - rW) * rLdp - rLbd50);
        double rLminbap = 0.0;
        double rEta = 2.5;
        rLminbap = rEta * Math.log(Math.exp(rLba / rEta) + Math.exp(rLB0p / rEta));
        double rLbda = 0.0;
        rLbda = rLminbap > rLbd ? rLbd : rLminbap + rFk * (rLbd - rLminbap);
        double rLbam = 0.0;
        rLbam = rLbda + rFj * (rLminB0p - rLbda);
        rL = -5.0 * Math.log10(Math.pow(10.0, -0.2 * rLbs) + Math.pow(10.0, -0.2 * rLbam)) + rAht + rAhr;
        return rL;
    }

    public double Jfunction(double rInput) {
        double rValue = 0.0;
        rValue = 6.9 + 20.0 * Math.log10(Math.sqrt(Math.pow(rInput - 0.1, 2.0) + 1.0) + rInput - 0.1);
        return rValue;
    }

    public double Fi(double rP, double rBeta0) {
        double rValue = 0.0;
        if (rP == 50.0) {
            rValue = 0.0;
        } else if (50.0 > rP && rP > rBeta0) {
            rValue = this.Ifunction(rP / 100.0) / this.Ifunction(rBeta0 / 100.0);
        } else if (rBeta0 >= rP) {
            rValue = 1.0;
        }
        return rValue;
    }

    public double Ifunction(double rInput) {
        double rXi = 0.0;
        double rC0 = 2.515516698;
        double rC1 = 0.802853;
        double rC2 = 0.010328;
        double rD1 = 1.432788;
        double rD2 = 0.189269;
        double rD3 = 0.001308;
        double rTau = Math.sqrt(-2.0 * Math.log(rInput));
        rXi = ((rC1 + rTau * rC2) * rTau + rC0) / ((rD1 + rTau * (rD2 + rD3 * rTau)) * rTau + 1.0);
        return rXi - rTau;
    }

    public double attenuationByAtmosphericGasesP676ver8(double rFreq, double rRho, double rPressure, double rTemperature) {
        double rGamma = 0.0;
        rTemperature = 288.0 / (273.0 + rTemperature);
        double gammaDryAir = this.attenuationDueToDryAir(rFreq, rPressure /= 1013.0, rTemperature);
        double gammaWaterVapour = this.attenuationDueToWaterVapour(rFreq, rPressure, rTemperature, rRho);
        rGamma = gammaDryAir + gammaWaterVapour;
        return rGamma;
    }

    public double functionPhi(double rPressure, double rTemperature, double a, double b, double c, double d) {
        double rValue = 0.0;
        double rTemp = c * (1.0 - rPressure) + d * (1.0 - rTemperature);
        rValue = Math.pow(rPressure, a) * Math.pow(rTemperature, b) * Math.exp(rTemp);
        return rValue;
    }

    public double functionG(double rFreq, double rFreqi) {
        double rValue = 0.0;
        rValue = 1.0 + Math.pow((rFreq - rFreqi) / (rFreq + rFreqi), 2.0);
        return rValue;
    }

    public double attenuationDueToDryAir(double rFreq, double rPressure, double rTemperature) {
        double rGammaDryAir = 0.0;
        double rZeta1 = this.functionPhi(rPressure, rTemperature, 0.0717, -1.8132, 0.0156, -1.6515);
        double rZeta2 = this.functionPhi(rPressure, rTemperature, 0.5146, -4.6368, -0.1921, -5.7416);
        double rZeta3 = this.functionPhi(rPressure, rTemperature, 0.3414, -6.5851, 0.213, -8.5854);
        double rZeta4 = this.functionPhi(rPressure, rTemperature, -0.0112, 0.0092, -0.1033, -9.0E-4);
        double rZeta5 = this.functionPhi(rPressure, rTemperature, 0.2705, -2.7192, -0.3016, -4.1033);
        double rZeta6 = this.functionPhi(rPressure, rTemperature, 0.2445, -5.9191, 0.0422, -8.0719);
        double rZeta7 = this.functionPhi(rPressure, rTemperature, -0.1833, 6.5589, -0.2402, 6.131);
        double rGamma54 = 2.192 * this.functionPhi(rPressure, rTemperature, 1.8286, -1.9487, 0.4051, -2.8509);
        double rGamma58 = 12.59 * this.functionPhi(rPressure, rTemperature, 1.0045, 3.561, 0.1588, 1.2834);
        double rGamma60 = 15.0 * this.functionPhi(rPressure, rTemperature, 0.9003, 4.1335, 0.0427, 1.6088);
        double rGamma62 = 14.28 * this.functionPhi(rPressure, rTemperature, 0.9886, 3.4176, 0.1827, 1.3429);
        double rGamma64 = 6.819 * this.functionPhi(rPressure, rTemperature, 1.432, 0.6258, 0.3177, -0.5914);
        double rGamma66 = 1.908 * this.functionPhi(rPressure, rTemperature, 2.0717, -4.1404, 0.491, -4.8718);
        double rDelta = -0.00306 * this.functionPhi(rPressure, rTemperature, 3.211, -14.94, 1.583, -16.37);
        if (rFreq <= 54.0) {
            rGammaDryAir = (7.2 * Math.pow(rTemperature, 2.8) / (Math.pow(rFreq, 2.0) + 0.34 * Math.pow(rPressure, 2.0) * Math.pow(rTemperature, 1.6)) + 0.62 * rZeta3 / (Math.pow(54.0 - rFreq, 1.16 * rZeta1) + 0.083 * rZeta2)) * Math.pow(rFreq, 2.0) * Math.pow(rPressure, 2.0) * Math.pow(10.0, -3.0);
        } else if (rFreq <= 60.0) {
            rGammaDryAir = Math.exp((rFreq - 58.0) * (rFreq - 60.0) * Math.log(rGamma54) / 24.0 - (rFreq - 54.0) * (rFreq - 60.0) * Math.log(rGamma58) / 8.0 + (rFreq - 54.0) * (rFreq - 58.0) * Math.log(rGamma60) / 12.0);
        } else if (rFreq <= 62.0) {
            rGammaDryAir = rGamma60 + (rGamma62 - rGamma60) * (rFreq - 60.0) / 2.0;
        } else if (rFreq <= 66.0) {
            rGammaDryAir = Math.exp((rFreq - 64.0) * (rFreq - 66.0) * Math.log(rGamma62) / 8.0 - (rFreq - 62.0) * (rFreq - 66.0) * Math.log(rGamma64) / 4.0 + (rFreq - 62.0) * (rFreq - 64.0) * Math.log(rGamma66) / 8.0);
        } else if (rFreq <= 120.0) {
            rGammaDryAir = (3.02 * Math.pow(10.0, -4.0) * Math.pow(rTemperature, 3.5) + 0.283 * Math.pow(rTemperature, 3.8) / (Math.pow(rFreq - 118.75, 2.0) + 2.91 * Math.pow(rPressure, 2.0) * Math.pow(rTemperature, 1.6)) + 0.502 * rZeta6 * (1.0 - 0.0163 * rZeta7 * (rFreq - 66.0)) / (Math.pow(rFreq - 66.0, 1.4346 * rZeta4) + 1.15 * rZeta5)) * Math.pow(rFreq, 2.0) * Math.pow(rPressure, 2.0) * Math.pow(10.0, -3.0);
        } else if (rFreq <= 350.0) {
            rGammaDryAir = (3.02 * Math.pow(10.0, -4.0) / (1.0 + 1.9 * Math.pow(10.0, -5.0) * Math.pow(rFreq, 1.5)) + 0.283 * Math.pow(rTemperature, 0.3) / (Math.pow(rFreq - 118.75, 2.0) + 2.91 * Math.pow(rPressure, 2.0) * Math.pow(rTemperature, 1.6))) * Math.pow(rFreq, 2.0) * Math.pow(rPressure, 2.0) * Math.pow(rTemperature, 3.5) * Math.pow(10.0, -3.0) + rDelta;
        }
        return rGammaDryAir;
    }

    public double attenuationDueToWaterVapour(double rFreq, double rPressure, double rTemperature, double rRho) {
        double rGammaWaterVapour = 0.0;
        double rEta1 = 0.955 * rPressure * Math.pow(rTemperature, 0.68) + 0.006 * rRho;
        double rEta2 = 0.735 * rPressure * Math.pow(rTemperature, 0.5) + 0.0353 * Math.pow(rTemperature, 4.0) * rRho;
        double rValue1 = 3.98 * rEta1 * Math.exp(2.23 * (1.0 - rTemperature)) / (Math.pow(rFreq - 22.235, 2.0) + 9.42 * Math.pow(rEta1, 2.0)) * this.functionG(rFreq, 22.0);
        double rValue2 = 11.96 * rEta1 * Math.exp(0.7 * (1.0 - rTemperature)) / (Math.pow(rFreq - 183.31, 2.0) + 11.14 * Math.pow(rEta1, 2.0));
        double rValue3 = 0.081 * rEta1 * Math.exp(6.44 * (1.0 - rTemperature)) / (Math.pow(rFreq - 321.226, 2.0) + 6.29 * Math.pow(rEta1, 2.0));
        double rValue4 = 3.66 * rEta1 * Math.exp(1.6 * (1.0 - rTemperature)) / (Math.pow(rFreq - 321.153, 2.0) + 9.22 * Math.pow(rEta1, 2.0));
        double rValue5 = 25.37 * rEta1 * Math.exp(1.09 * (1.0 - rTemperature)) / Math.pow(rFreq - 380.0, 2.0);
        double rValue6 = 17.4 * rEta1 * Math.exp(1.46 * (1.0 - rTemperature)) / Math.pow(rFreq - 448.0, 2.0);
        double rValue7 = 844.6 * rEta1 * Math.exp(0.17 * (1.0 - rTemperature)) / Math.pow(rFreq - 557.0, 2.0) * this.functionG(rFreq, 557.0);
        double rValue8 = 290.0 * rEta1 * Math.exp(0.41 * (1.0 - rTemperature)) / Math.pow(rFreq - 752.0, 2.0) * this.functionG(rFreq, 752.0);
        double rValue9 = 8.3328 * Math.pow(10.0, 4.0) * rEta2 * Math.exp(0.99 * (1.0 - rTemperature)) / Math.pow(rFreq - 1780.0, 2.0) * this.functionG(rFreq, 1780.0);
        rGammaWaterVapour = (rValue1 + rValue2 + rValue3 + rValue4 + rValue5 + rValue6 + rValue7 + rValue8 + rValue9) * Math.pow(rFreq, 2.0) * Math.pow(rTemperature, 2.5) * rRho * Math.pow(10.0, -4.0);
        return rGammaWaterVapour;
    }

    public double getRefrIndexGradient() {
        return this.refrIndexGradient;
    }

    public double getLatitude() {
        return this.rLat;
    }

    public double getAdditionalClutterLossesTransmitter() {
        return this.rAht;
    }

    public double getAdditionalClutterLossesReceiver() {
        return this.rAhr;
    }

    public double getAntennaGainReceiverForTroposphericModel() {
        return this.rGRx;
    }

    public double getAntennaGainTransmitterForTroposphericModel() {
        return this.rGTx;
    }

    public double getSeaLevelSurfaceRefractivity() {
        return this.rNo;
    }

    @Override
    public Description description() {
        return new DescriptionImpl("ITU-R P.452-14", "<b><u>Frequency range:</u></b><br>about 0.7 GHz to 50 GHz<br><b><u>Distance range:</u></b><br>up to a distance limit of 10 000 km<br><b><u>Typical application area:</u></b><br>Prediction method for the evaluation of interference between stations on the surface of the Earth at frequencies above about 0.1 GHz, accounting for both clear-air and hydrometeor scattering interference mechanisms.");
    }
}

