/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.propagation;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class P2001ver2DigitalMaps {
    private DigitalMap _mapSdN = new DigitalMap("DN_Median.txt", true);
    private DigitalMap _mapSdNsup = new DigitalMap("DN_SupSlope.txt", true);
    private DigitalMap _mapSdNsub = new DigitalMap("DN_SubSlope.txt", true);
    private DigitalMap _mapDndz_01 = new DigitalMap("dndz_01.txt", true);
    private DigitalMap _mapRho_sur = new DigitalMap("surfwv_50_fixed.txt", true);
    private DigitalMap _mapEsarain_Pr6 = new DigitalMap("Esarain_Pr6_v5.txt", true);
    private DigitalMap _mapEsarain_Mt = new DigitalMap("Esarain_Mt_v5.txt", true);
    private DigitalMap _mapEsarain_Beta = new DigitalMap("Esarain_Beta_v5.txt", true);
    private DigitalMap _mapData_h0 = new DigitalMap("h0.txt", true);
    private DigitalMap _mapFoEs50 = new DigitalMap("FoEs50.txt", true);
    private DigitalMap _mapFoEs10 = new DigitalMap("FoEs10.txt", true);
    private DigitalMap _mapFoEs01 = new DigitalMap("FoEs01.txt", true);
    private DigitalMap _mapFoEs0_1 = new DigitalMap("FoEs0.1.txt", true);
    private DigitalMap _mapTropoClim = new DigitalMap("TropoClim.txt", false);

    public double GetSdN(double lon, double lat) {
        return this._mapSdN.GetInterpolatedValue(lon, lat);
    }

    public double GetSdNsup(double lon, double lat) {
        return this._mapSdNsup.GetInterpolatedValue(lon, lat);
    }

    public double GetSdNsub(double lon, double lat) {
        return this._mapSdNsub.GetInterpolatedValue(lon, lat);
    }

    public double GetNd65m1(double lon, double lat) {
        return this._mapDndz_01.GetInterpolatedValue(lon, lat);
    }

    public double GetRhoSur(double lon, double lat) {
        return this._mapRho_sur.GetInterpolatedValue(lon, lat);
    }

    public double GetPr6(double lon, double lat) {
        return this._mapEsarain_Pr6.GetInterpolatedValue(lon, lat);
    }

    public double GetMt(double lon, double lat) {
        return this._mapEsarain_Mt.GetInterpolatedValue(lon, lat);
    }

    public double GetBetaRain(double lon, double lat) {
        return this._mapEsarain_Beta.GetInterpolatedValue(lon, lat);
    }

    public double GetH0(double lon, double lat) {
        return this._mapData_h0.GetInterpolatedValue(lon, lat);
    }

    public double GetFoEs(double lon, double lat, double p) {
        double foEs;
        if (p == 50.0) {
            foEs = this._mapFoEs50.GetInterpolatedValue(lon, lat);
        } else if (p == 10.0) {
            foEs = this._mapFoEs10.GetInterpolatedValue(lon, lat);
        } else if (p == 1.0) {
            foEs = this._mapFoEs01.GetInterpolatedValue(lon, lat);
        } else if (p == 0.1) {
            foEs = this._mapFoEs0_1.GetInterpolatedValue(lon, lat);
        } else {
            throw new RuntimeException("Allowed values for p: 0.1, 1, 10, 50.");
        }
        return foEs;
    }

    public int GetClimZone(double lon, double lat) {
        return (int)this._mapTropoClim.GetClosestGridPointValue(lon, lat);
    }

    class DigitalMap {
        double[][] _map;
        int _sizeX;
        int _sizeY;
        private double _spacing;

        public DigitalMap(String path, boolean lastAndFirstColumnEqual) {
            String name = "/p2001/" + path;
            try {
                String line;
                InputStream inputStream = this.getClass().getResourceAsStream(name);
                ArrayList<String> lines = new ArrayList<String>();
                BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
                while (null != (line = br.readLine())) {
                    lines.add(line);
                }
                this._sizeY = lines.size();
                this._sizeX = this.ParseLine((String)lines.get(0)).length;
                this._map = new double[this._sizeY][this._sizeX];
                for (int i = 0; i < this._sizeY; ++i) {
                    double[] data = this.ParseLine((String)lines.get(i));
                    for (int j = 0; j < this._sizeX; ++j) {
                        this._map[i][j] = data[j];
                    }
                }
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Could not load map: '" + name + "'");
            }
            this._spacing = lastAndFirstColumnEqual ? 360.0 / (double)(this._map[1].length - 1) : 360.0 / (double)this._map[1].length;
        }

        private double[] ParseLine(String line) {
            String[] parts = line.trim().split("\\s+");
            double[] data = new double[parts.length];
            for (int i = 0; i < parts.length; ++i) {
                data[i] = Double.parseDouble(parts[i]);
            }
            return data;
        }

        public double GetClosestGridPointValue(double longitude, double latitude) {
            double longitudeOffset = longitude + 180.0;
            double latitudeOffset = 90.0 - latitude;
            int latitudeIndex = (int)(latitudeOffset / this._spacing);
            int longitudeIndex = (int)(longitudeOffset / this._spacing);
            double val = this._map[latitudeIndex %= this._sizeY][longitudeIndex %= this._sizeX];
            return val;
        }

        public double GetInterpolatedValue(double longitude, double latitude) {
            double longitudeOffset = longitude;
            if (longitude < 0.0) {
                longitudeOffset = longitude + 360.0;
            }
            double latitudeOffset = 90.0 - latitude;
            int latitudeIndex = (int)(latitudeOffset / this._spacing);
            int longitudeIndex = (int)(longitudeOffset / this._spacing);
            double latitudeFraction = latitudeOffset / this._spacing - (double)latitudeIndex;
            double longitudeFraction = longitudeOffset / this._spacing - (double)longitudeIndex;
            double value_ul = this._map[latitudeIndex][longitudeIndex];
            double value_ur = this._map[latitudeIndex][(longitudeIndex + 1) % this._sizeX];
            double value_ll = this._map[(latitudeIndex + 1) % this._sizeY][longitudeIndex];
            double value_lr = this._map[(latitudeIndex + 1) % this._sizeY][(longitudeIndex + 1) % this._sizeX];
            double interpolatedHeight1 = longitudeFraction * (value_ur - value_ul) + value_ul;
            double interpolatedHeight2 = longitudeFraction * (value_lr - value_ll) + value_ll;
            double interpolatedHeight3 = latitudeFraction * (interpolatedHeight2 - interpolatedHeight1) + interpolatedHeight1;
            return interpolatedHeight3;
        }
    }
}

