/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.propagation;

import java.util.List;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.propagation.P1411LowAntennaHeightInput;
import org.seamcat.model.plugin.propagation.PropagationModelPlugin;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.Origin;
import org.seamcat.model.propagation.PluginCheckUtilsToBeRemoved;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.LocalEnvironment;
import org.seamcat.model.types.result.DescriptionImpl;

public class P1411LowAntennaHeight
implements PropagationModelPlugin<P1411LowAntennaHeightInput> {
    @Override
    public void consistencyCheck(ConsistencyCheckContext context, P1411LowAntennaHeightInput input, Validator validator) {
        String msg;
        if (context.getOrigin() == Origin.EPP) {
            return;
        }
        Distribution frequency = context.getFrequency();
        if (frequency.getBounds().getMax() > 100000.0 || frequency.getBounds().getMin() < 300.0) {
            validator.error("ITU-R P.1411 model not applicable outside the frequency range 300 MHz ... 100 GHz");
        }
        Bounds rx = context.getRxSettings().getHeight();
        Bounds tx = context.getTxSettings().getHeight();
        List<LocalEnvironment> envRX = context.getRxSettings().getLocalEnvironments();
        List<LocalEnvironment> envTX = context.getTxSettings().getLocalEnvironments();
        if (context.getOrigin() == Origin.SYSTEM) {
            if (rx.getMin() < 1.9 || rx.getMax() > 3.0) {
                validator.error("ITU-R P.1411: valid receiver antenna height range is 1.9 ... 3 m " + PluginCheckUtilsToBeRemoved.getExceptionHint());
            }
            if (tx.getMin() < 1.9 || tx.getMax() > 3.0) {
                validator.error("ITU-R P.1411: valid transmitter antenna height range is 1.9 ... 3 m " + PluginCheckUtilsToBeRemoved.getExceptionHint());
            }
        } else if (context.getOrigin() == Origin.INTERFERENCE_LINK) {
            if (rx.getMin() < 1.9 || rx.getMax() > 3.0) {
                validator.error("ITU-R P.1411: valid VLR antenna height range is 1.9 ... 3 m " + PluginCheckUtilsToBeRemoved.getExceptionHint());
            }
            if (tx.getMin() < 1.9 || tx.getMax() > 3.0) {
                validator.error("ITU-R P.1411: valid ILT antenna height range is 1.9 ... 3 m " + PluginCheckUtilsToBeRemoved.getExceptionHint());
            }
        }
        boolean usingClutter = false;
        for (LocalEnvironment env : envRX) {
            String string = msg = context.getOrigin() == Origin.SYSTEM ? "ITU-R P.1411 model: Indoor environment on the receiver will be ignored." : "ITU-R P.1411 model: Indoor environment on the VLR will be ignored.";
            if (env.getEnvironment() == LocalEnvironment.Environment.Indoor) {
                validator.error(msg);
                break;
            }
            if (env.getEnvironment() != LocalEnvironment.Environment.Outdoor || !env.isUsingClutter()) continue;
            usingClutter = true;
        }
        for (LocalEnvironment env : envTX) {
            String string = msg = context.getOrigin() == Origin.SYSTEM ? "ITU-R P.1411 model: Indoor environment on the transmitter will be ignored." : "ITU-R P.1411 model: Indoor environment on the ILT will be ignored.";
            if (env.getEnvironment() == LocalEnvironment.Environment.Indoor) {
                validator.error(msg);
                break;
            }
            if (env.getEnvironment() != LocalEnvironment.Environment.Outdoor || !env.isUsingClutter()) continue;
            usingClutter = true;
        }
        if (usingClutter) {
            validator.error("Applying clutter twice: the environment selection and propagation model ITU-R P.1411 are both applying clutter");
        }
    }

    @Override
    public double evaluate(LinkResult linkResult, boolean variations, P1411LowAntennaHeightInput input) {
        double loss = 0.0;
        double frequency = linkResult.getFrequency();
        double distance = linkResult.getTxRxDistance();
        double HTx = linkResult.txAntenna().getHeight();
        double HRx = linkResult.rxAntenna().getHeight();
        if (frequency < 300.0) {
            throw new RuntimeException("ITU-R P.1411 model not applicable below 300 MHz");
        }
        if (frequency > 100000.0) {
            throw new RuntimeException("ITU-R P.1411 model not applicable above 100 GHz");
        }
        if (HTx > 3.0 || HRx > 3.0) {
            throw new RuntimeException("ITU-R P.1411 model not applicable with Tx Antenna above 3 m");
        }
        if (HTx < 1.9 || HRx < 1.9) {
            throw new RuntimeException("ITU-R P.1411 model not applicable with Tx Antenna below 1.9 m");
        }
        double percentLoc = input.LocationPercentage() / 100.0;
        double street_width = input.WidthTransitionRegion();
        loss = P1411LowAntennaHeight.perteP1411(distance, frequency, input.generalEnvironment(), percentLoc, street_width);
        if (variations) {
            loss += Factory.distributionFactory().getGaussianDistribution(0.0, input.stdDev()).trial();
        }
        return loss;
    }

    @Override
    public Description description() {
        return new DescriptionImpl("ITU-R P.1411 (Low Antenna Height)", "ITU-R P.1411 \u00a74.3");
    }

    public static double perteP1411(double distance, double frequency, P1411LowAntennaHeightInput.Environment environment, double pLoc, double street_width) {
        double loss = 0.0;
        double distance_m = distance * 1000.0;
        double Lurban = environment == P1411LowAntennaHeightInput.Environment.Suburban ? 0.0 : (environment == P1411LowAntennaHeightInput.Environment.Urban ? 6.8 : (environment == P1411LowAntennaHeightInput.Environment.DenseUrban ? 2.3 : 0.0));
        double deltaL_los = 10.9368 * (Math.sqrt(-2.0 * Math.log(1.0 - pLoc)) - 1.1774);
        double deltaL_Nlos = -7.0 * Mathematics.Qi(pLoc);
        double dist_los = pLoc < 0.45 ? 212.0 * Math.pow(Math.log10(pLoc), 2.0) - 64.0 * Math.log10(pLoc) : 79.2 - 70.0 * pLoc;
        if (distance_m < dist_los) {
            loss = 32.45 + 20.0 * Math.log10(frequency) + 20.0 * Math.log10(distance) + deltaL_los;
        } else if (distance_m > dist_los + street_width) {
            loss = 9.5 + 45.0 * Math.log10(frequency) + 40.0 * Math.log10(distance) + Lurban + deltaL_Nlos;
        } else {
            double Llos = 32.45 + 20.0 * Math.log10(frequency) + 20.0 * Math.log10(dist_los / 1000.0) + deltaL_los;
            double Lnlos = 9.5 + 45.0 * Math.log10(frequency) + 40.0 * Math.log10((dist_los + street_width) / 1000.0) + Lurban + deltaL_Nlos;
            loss = Llos + (Lnlos - Llos) * (distance_m - dist_los) / street_width;
        }
        return loss;
    }

    private static double Qi_1411(double x) {
        try {
            double c0 = 2.515516996383667;
            double c1 = 0.802852988243103;
            double c2 = 0.010328f;
            double d1 = 1.432788f;
            double d2 = 0.189269f;
            double d3 = 0.001308f;
            double t = x <= 0.5 ? Math.sqrt(-2.0 * Math.log(x)) : Math.sqrt(-2.0 * Math.log(1.0 - x));
            double xi = ((c2 * t + c1) * t + c0) / (((d3 * t + d2) * t + d1) * t + 1.0);
            double Q = x <= 0.5 ? t - xi : -(t - xi);
            return Q;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

