/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.propagation;

import org.apache.log4j.Logger;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.RandomAccessor;
import org.seamcat.model.factory.SeamcatRandom;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.propagation.Model_C_IEEE_802_11_rev3_Input;
import org.seamcat.model.plugin.propagation.PropagationModelPlugin;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.Origin;
import org.seamcat.model.propagation.PluginCheckUtilsToBeRemoved;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.result.DescriptionImpl;

public class Model_C_IEEE_802_11_rev3
implements PropagationModelPlugin<Model_C_IEEE_802_11_rev3_Input> {
    private String warningMessage;
    private static final Logger LOG = Logger.getLogger(Model_C_IEEE_802_11_rev3.class);

    @Override
    public double evaluate(LinkResult linkResult, boolean variation, Model_C_IEEE_802_11_rev3_Input input) {
        SeamcatRandom random = RandomAccessor.getRandom();
        double pathLoss = 0.0;
        double pathLossToBP = 0.0;
        double pathLossAfter = 0.0;
        double distance = linkResult.getTxRxDistance();
        double distanceToBP = input.distanceToBP() / 1000.0;
        if (Mathematics.equals(input.distanceToBP(), 0.0, 1.0E-5)) {
            throw new RuntimeException("distance to break point (BP) equal to zero not allowed.");
        }
        double freeSpaceReference = 32.44 + 20.0 * Math.log10(linkResult.getFrequency()) + 10.0 * Math.log10(distance * distance + (linkResult.rxAntenna().getHeight() - linkResult.txAntenna().getHeight()) * (linkResult.rxAntenna().getHeight() - linkResult.txAntenna().getHeight()) / 1000000.0);
        if (distance <= distanceToBP) {
            pathLoss = freeSpaceReference;
            if (variation) {
                pathLoss += input.logNormBefore() * random.nextGaussian();
            }
        } else {
            pathLossToBP = 32.44 + 20.0 * Math.log10(linkResult.getFrequency()) + 10.0 * Math.log10(distanceToBP * distanceToBP + (linkResult.rxAntenna().getHeight() - linkResult.txAntenna().getHeight()) * (linkResult.rxAntenna().getHeight() - linkResult.txAntenna().getHeight()) / 1000000.0);
            pathLossAfter = 35.0 * Math.log10(distance / distanceToBP);
            pathLoss = variation ? pathLossToBP + input.logNormBefore() * random.nextGaussian() + pathLossAfter + input.logNormAfter() * random.nextGaussian() : pathLossToBP + pathLossAfter;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("distance to break point = " + distanceToBP + " km; LOG-NORMAL distribution before BP = " + input.logNormBefore() + " dB; LOG-NORMAL distribution after BP = " + input.logNormAfter() + " dB");
        }
        return pathLoss;
    }

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, Model_C_IEEE_802_11_rev3_Input input, Validator validator) {
        Bounds coverage;
        if (input.logNormAfter() < input.logNormBefore()) {
            validator.error("LOG-NORMAL distribution after BP shall not be less than LOG-NORMAL distribution before BP");
        }
        if (Mathematics.equals(input.distanceToBP(), 0.0, 1.0E-5)) {
            validator.error("distance to break point (BP) must be greater than zero" + PluginCheckUtilsToBeRemoved.getExceptionHint());
        }
        if (context.getOrigin() == Origin.EPP) {
            return;
        }
        Distribution frequency = context.getFrequency();
        if (frequency.getBounds().isBounded() && frequency.getBounds().getMin() < 1800.0) {
            validator.error("This model is designed for the 2 GHz and 5 GHz ranges. 1800 MHz is assumed as lowest valid frequency.");
        }
        if (!Mathematics.equals((coverage = context.getCoverage()).getMax(), coverage.getMin(), 1.0E-5) && coverage.getMin() > input.distanceToBP() / 1000.0) {
            validator.error("distance to break point (BP) must be greater than " + coverage.getMin() * 1000.0 + "m" + PluginCheckUtilsToBeRemoved.getExceptionHint());
        }
        if (coverage.getMax() < input.distanceToBP() / 1000.0) {
            this.setWarningMessage("distance to break point (BP) must be less than " + coverage.getMax() * 1000.0 + "m");
            validator.error("distance to break point (BP) must be less than " + coverage.getMax() * 1000.0 + "m" + PluginCheckUtilsToBeRemoved.getExceptionHint());
        }
    }

    @Override
    public Description description() {
        return new DescriptionImpl("IEEE 802.11 rev3 (Model C)", "Calculate the IEEE 802.11 Model C");
    }

    public void setWarningMessage(String warningMessage) {
        this.warningMessage = warningMessage;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }
}

