/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.propagation;

import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.plugin.propagation.LongleyRice_modInput;
import org.seamcat.model.plugin.propagation.PropagationModelPlugin;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.Origin;
import org.seamcat.model.propagation.Att;
import org.seamcat.model.propagation.Complex;
import org.seamcat.model.propagation.Licz_geometrie;
import org.seamcat.model.propagation.Param;
import org.seamcat.model.propagation.Param2;
import org.seamcat.model.propagation.Param_att;
import org.seamcat.model.propagation.Param_tmp;
import org.seamcat.model.propagation.PluginCheckUtilsToBeRemoved;
import org.seamcat.model.propagation.Stat;
import org.seamcat.model.propagation.Strefa1;
import org.seamcat.model.propagation.Strefa2;
import org.seamcat.model.propagation.Strefa3;
import org.seamcat.model.propagation.Wyznaczanie_param;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.result.DescriptionImpl;

public class LongleyRice_mod
implements PropagationModelPlugin<LongleyRice_modInput> {
    public static LongleyRice_modInput input;
    public static int polar;
    public static int sitingCriteria;
    public static int radio_climate;
    public static int mdvar;

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, LongleyRice_modInput input, Validator validator) {
        Bounds txHeight;
        Distribution frequencies;
        if (context.getOrigin() == Origin.EPP) {
            return;
        }
        Bounds coverage = context.getCoverage();
        if (coverage.getMax() < 1.0) {
            validator.error("Results with distances below 1 km are not guaranteed <br/>by the Longley Rice propagation model" + PluginCheckUtilsToBeRemoved.getExceptionHint());
        }
        if ((frequencies = context.getFrequency()).getBounds().getMin() < 20.0 || frequencies.getBounds().getMax() > 20000.0) {
            validator.error("Frequencies below 20 MHz or above 20 GHz are not supported by the Longley Rice propagation model" + PluginCheckUtilsToBeRemoved.getExceptionHint());
        }
        if ((txHeight = context.getTxSettings().getHeight()).getMax() > 1000.0) {
            validator.error("Antenna Height above 1 000 m are not supported by the Longley Rice propagation model" + PluginCheckUtilsToBeRemoved.getExceptionHint());
        }
        LongleyRice_mod.input = input;
    }

    @Override
    public double evaluate(LinkResult linkResult, boolean variation, LongleyRice_modInput input) {
        double frequency = linkResult.getFrequency();
        double distance = linkResult.getTxRxDistance();
        double txHeight = linkResult.txAntenna().getHeight();
        double rxHeight = linkResult.rxAntenna().getHeight();
        if (frequency < 20.0 || frequency > 20000.0) {
            throw new RuntimeException("Frequencies below 20 MHz or above 20 GHz are not supported by the Longley Rice propagation model");
        }
        if (txHeight > 1000.0 || rxHeight > 1000.0) {
            throw new RuntimeException("Antenna Height above 1 000 m are not supported by the Longley Rice propagation model");
        }
        if (distance < 1.0) {
            throw new RuntimeException("Results with distances below 1 km are not guaranteed the Longley Rice propagation model");
        }
        Param param = new Param();
        Param_att param_att = new Param_att();
        Param_tmp param_tmp = new Param_tmp();
        param.setPar2(txHeight, rxHeight);
        Param2 param2 = new Param2();
        this.initPlugin(param);
        Complex wyznaczanie = Wyznaczanie_param.wyznaczanie_param(linkResult, param2);
        Licz_geometrie.licz_geometrie(param, param2);
        Strefa2 strefa2 = new Strefa2();
        strefa2.licz_Aed(wyznaczanie, param, param2, param_att, param_tmp);
        Strefa1 strefa1 = new Strefa1();
        strefa1.strefa1(wyznaczanie, param_att, param2, param_tmp);
        Strefa3 strefa3 = new Strefa3();
        strefa3.strefa3(param_att, param2, param_tmp);
        double aref = Att.att(linkResult, param_att, param_tmp, param2);
        double loss = Stat.stat(linkResult, aref, param, param2);
        if (variation) {
            loss += input.stdDev() * Factory.distributionFactory().getGaussianDistribution(0.0, 1.0).trial();
        }
        return loss;
    }

    private void initPlugin(Param param) {
        if (input.polarisation() == LongleyRice_modInput.Polarization.Horizontal) {
            LongleyRice_mod.setPolar(0);
        } else {
            LongleyRice_mod.setPolar(1);
        }
        if (input.siteCriteria() == LongleyRice_modInput.Site.Random) {
            LongleyRice_mod.setSitingCriteria(0);
        } else if (input.siteCriteria() == LongleyRice_modInput.Site.VeryCareful) {
            LongleyRice_mod.setSitingCriteria(2);
        } else {
            LongleyRice_mod.setSitingCriteria(1);
        }
        if (input.radioClimate() == LongleyRice_modInput.Climate.Equatorial) {
            LongleyRice_mod.setRadio_climate(0);
        } else if (input.radioClimate() == LongleyRice_modInput.Climate.Continental_Subtropical) {
            LongleyRice_mod.setRadio_climate(1);
        } else if (input.radioClimate() == LongleyRice_modInput.Climate.Maritime_Subtropical) {
            LongleyRice_mod.setRadio_climate(2);
        } else if (input.radioClimate() == LongleyRice_modInput.Climate.Desert) {
            LongleyRice_mod.setRadio_climate(3);
        } else if (input.radioClimate() == LongleyRice_modInput.Climate.Continental_Temperate) {
            LongleyRice_mod.setRadio_climate(4);
        } else if (input.radioClimate() == LongleyRice_modInput.Climate.Maritime_Temperate_over_land) {
            LongleyRice_mod.setRadio_climate(5);
        } else {
            LongleyRice_mod.setRadio_climate(6);
        }
        param.pctTime = input.timePercentage().trial() / 100.0;
        param.pctLoc = input.locationPercentage().trial() / 100.0;
        param.pctConf = input.confidentPercent().trial() / 100.0;
        if (input.variability() == LongleyRice_modInput.Variability.Single) {
            LongleyRice_mod.setMdvar(0);
        } else if (input.variability() == LongleyRice_modInput.Variability.Individual) {
            LongleyRice_mod.setMdvar(1);
        } else {
            LongleyRice_mod.setMdvar(3);
        }
    }

    public static void setPolar(int _polar) {
        polar = _polar;
    }

    public static void setSitingCriteria(int _sitingCriteria) {
        sitingCriteria = _sitingCriteria;
    }

    public static void setRadio_climate(int _radio_climate) {
        radio_climate = _radio_climate;
    }

    public static void setMdvar(int _mdvar) {
        mdvar = _mdvar;
    }

    @Override
    public Description description() {
        return new DescriptionImpl("Longley Rice", "adapted to SEAMCAT 5");
    }
}

