/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.propagation;

import org.seamcat.model.plugin.propagation.HataInput;
import org.seamcat.model.propagation.LocalEnvCorrections;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.LocalEnvironmentResult;
import org.seamcat.model.types.LocalEnvironment;

public class Helper {
    protected static LocalEnvCorrections localEnvCorrections(LocalEnvCorrections localEnvironmentCorrections, LinkResult linkResult, double floorHeight, double roomSize, double wiLoss, double floorLoss, double empiricalParam, double wiStdDev) {
        LocalEnvironmentResult rxEnv = linkResult.rxAntenna().getLocalEnvironment();
        LocalEnvironmentResult txEnv = linkResult.txAntenna().getLocalEnvironment();
        if (rxEnv.getEnvironment() == LocalEnvironment.Environment.Indoor && txEnv.getEnvironment() == LocalEnvironment.Environment.Indoor) {
            if (linkResult.isTxRxInSameBuilding()) {
                double rK = Math.abs(Math.floor(linkResult.txAntenna().getHeight() / floorHeight) - Math.floor(linkResult.rxAntenna().getHeight() / floorHeight));
                double d1 = linkResult.txAntenna().getHeight() - linkResult.rxAntenna().getHeight();
                double realDistance = Math.sqrt(d1 * d1 + linkResult.getTxRxDistance() * linkResult.getTxRxDistance());
                localEnvironmentCorrections.rMedianLoss = -27.6 + 20.0 * Math.log10(1000.0 * realDistance) + 20.0 * Math.log10(linkResult.getFrequency()) + Math.floor(1000.0 * linkResult.getTxRxDistance() / roomSize) * wiLoss + Math.pow(rK, (rK + 2.0) / (rK + 1.0) - empiricalParam) * floorLoss;
                localEnvironmentCorrections.rStdDev = wiStdDev;
            } else {
                localEnvironmentCorrections.rMedianLoss += rxEnv.getWallLoss() + txEnv.getWallLoss();
                localEnvironmentCorrections.rStdDev = Math.sqrt(localEnvironmentCorrections.rStdDev * localEnvironmentCorrections.rStdDev + (txEnv.getWallLossStdDev() * txEnv.getWallLossStdDev() + rxEnv.getWallLossStdDev() * rxEnv.getWallLossStdDev()));
            }
        } else if (rxEnv.getEnvironment() == LocalEnvironment.Environment.Indoor && txEnv.getEnvironment() == LocalEnvironment.Environment.Outdoor) {
            localEnvironmentCorrections.rMedianLoss += rxEnv.getWallLoss();
            localEnvironmentCorrections.rStdDev = Math.sqrt(localEnvironmentCorrections.rStdDev * localEnvironmentCorrections.rStdDev + rxEnv.getWallLossStdDev() * rxEnv.getWallLossStdDev());
        } else if (rxEnv.getEnvironment() == LocalEnvironment.Environment.Outdoor && txEnv.getEnvironment() == LocalEnvironment.Environment.Indoor) {
            localEnvironmentCorrections.rMedianLoss += txEnv.getWallLoss();
            localEnvironmentCorrections.rStdDev = Math.sqrt(localEnvironmentCorrections.rStdDev * localEnvironmentCorrections.rStdDev + txEnv.getWallLossStdDev() * txEnv.getWallLossStdDev());
        }
        return localEnvironmentCorrections;
    }

    public static double generalEnvCorrections(double rMedianLoss, double frequency, double rDist, HataInput.Environment gEnv) {
        if (rDist >= 0.1) {
            if (gEnv == HataInput.Environment.Suburban) {
                rMedianLoss += -2.0 * Math.pow(Math.log10(Math.min(Math.max(150.0, frequency), 2000.0) / 28.0), 2.0) - 5.4;
            } else if (gEnv == HataInput.Environment.Rural) {
                double rural_correction = -4.78 * Math.pow(Math.log10(Math.min(Math.max(150.0, frequency), 2000.0)), 2.0) + 18.33 * Math.log10(Math.min(Math.max(150.0, frequency), 2000.0)) - 40.94;
                rMedianLoss += rural_correction;
            }
        }
        return rMedianLoss;
    }

    protected static double variationsStdDev(double rDist, HataInput.PropEnvironment pEnv) {
        double rStdDev = 0.0;
        rStdDev = rDist <= 0.04 ? 3.5 : (rDist <= 0.1 ? (pEnv == HataInput.PropEnvironment.Above_roof ? 3.5 + 141.66666666666666 * (rDist - 0.04) : 3.5 + 224.99999999999997 * (rDist - 0.04)) : (rDist <= 0.2 ? (pEnv == HataInput.PropEnvironment.Above_roof ? 12.0 : 17.0) : (rDist <= 0.6 ? (pEnv == HataInput.PropEnvironment.Above_roof ? 12.0 + -7.500000000000001 * (rDist - 0.2) : 17.0 + -20.0 * (rDist - 0.2)) : 9.0)));
        return rStdDev;
    }
}

