/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.propagation;

import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.propagation.FreespaceInput;
import org.seamcat.model.plugin.propagation.PropagationModelPlugin;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.result.DescriptionImpl;

public class FreeSpacePropagationModel
implements PropagationModelPlugin<FreespaceInput> {
    @Override
    public void consistencyCheck(ConsistencyCheckContext context, FreespaceInput input, Validator validator) {
    }

    @Override
    public double evaluate(LinkResult linkResult, boolean variations, FreespaceInput input) {
        double rL = 0.0;
        if (linkResult.getFrequency() < 30.0) {
            throw new RuntimeException("Frequencies below 30 MHz are not supported by the Free Space model");
        }
        rL = 32.44 + 10.0 * Math.log10((linkResult.txAntenna().getHeight() - linkResult.rxAntenna().getHeight()) * (linkResult.txAntenna().getHeight() - linkResult.rxAntenna().getHeight()) / 1000000.0 + linkResult.getTxRxDistance() * linkResult.getTxRxDistance()) + 20.0 * Math.log10(linkResult.getFrequency());
        if (Double.isInfinite(rL)) {
            rL = 20.0 * Math.log10(linkResult.getFrequency()) - 100.0;
        }
        if (variations) {
            rL += Factory.distributionFactory().getGaussianDistribution(0.0, input.stdDev()).trial();
        }
        return rL;
    }

    @Override
    public Description description() {
        return new DescriptionImpl("ITU-R P.525 (Free Space)", "<b><u>Frequency range:</u></b><br>Above 30 MHz<br><b><u>Distance range:</u></b><br>LOS-limited<br><b><u>Typical application area:</u></b><br>This model is appropriate to use on paths were unobstructed direct-Line-of-Sight propagation (with no reflection) could be expected (e.g. point-to-point fixed service links, links over short distances in open areas, etc)");
    }
}

