/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.propagation;

import org.seamcat.model.mathematics.Mathematics;

class Complex {
    public double re;
    public double im;
    public static final Complex I = new Complex(0.0, 1.0);

    public Complex(double x, double y) {
        this.re = x;
        this.im = y;
    }

    public Complex(double x) {
        this.re = x;
        this.im = 0.0;
    }

    public Complex() {
        this.re = 0.0;
        this.im = 0.0;
    }

    public static Complex complex(double x) {
        return new Complex(x);
    }

    public static Complex complex() {
        return new Complex();
    }

    public String getName() {
        if (Mathematics.equals(this.im, 0.0, 1.0E-4)) {
            return this.re + "";
        }
        if (Mathematics.equals(this.re, 0.0, 1.0E-4)) {
            return this.im + "i";
        }
        if (this.im < 0.0) {
            return this.re + " - " + -this.im + "i";
        }
        return this.re + " + " + this.im + "i";
    }

    public boolean equals(Complex x) {
        return Mathematics.equals(this.re, x.re, 1.0E-4) && Mathematics.equals(this.im, x.im, 1.0E-4);
    }

    public static boolean equals(Complex x, Complex y) {
        return Mathematics.equals(x.re, y.re, 1.0E-4) && Mathematics.equals(x.im, y.im, 1.0E-4);
    }

    public static double real(Complex x) {
        return x.re;
    }

    public static double imag(Complex x) {
        return x.im;
    }

    public static double abs(Complex x) {
        return Math.hypot(x.re, x.im);
    }

    public static double arg(Complex x) {
        if (x.equals(Complex.complex())) {
            return 0.0;
        }
        return Math.atan2(x.im, x.re);
    }

    public static Complex add(Complex x, Complex y) {
        Complex z = new Complex(x.re, x.im);
        z.re += y.re;
        z.im += y.im;
        return z;
    }

    public static Complex add(Complex x, double y) {
        return Complex.add(x, Complex.complex(y));
    }

    public static Complex add(double x, Complex y) {
        return Complex.add(Complex.complex(x), y);
    }

    public static Complex sub(Complex x, Complex y) {
        Complex z = new Complex(x.re, x.im);
        z.re -= y.re;
        z.im -= y.im;
        return z;
    }

    public static Complex sub(Complex x, double y) {
        return Complex.sub(x, Complex.complex(y));
    }

    public static Complex sub(double x, Complex y) {
        return Complex.sub(Complex.complex(x), y);
    }

    public static Complex mult(Complex x, Complex y) {
        Complex z = new Complex();
        z.re = x.re * y.re - x.im * y.im;
        z.im = x.re * y.im + x.im * y.re;
        return z;
    }

    public static Complex mult(Complex x, double y) {
        return Complex.mult(x, Complex.complex(y));
    }

    public static Complex div(Complex x, Complex y) {
        Complex z = new Complex();
        double denom = Math.pow(y.re, 2.0) + Math.pow(y.im, 2.0);
        z.re = (x.re * y.re + x.im * y.im) / denom;
        z.im = (x.im * y.re - x.re * y.im) / denom;
        return z;
    }

    public static Complex exp(Complex x) {
        Complex z = new Complex();
        z.re = Math.exp(x.re) * Math.cos(x.im);
        z.im = Math.exp(x.re) * Math.sin(x.im);
        return z;
    }

    public static Complex log(Complex x) {
        Complex z = new Complex(Complex.abs(x), Complex.arg(x));
        z.re = Math.log(z.re);
        return z;
    }

    public static Complex sqrt(Complex x) {
        Complex z = new Complex();
        z.re = Math.sqrt(Complex.abs(x)) * Math.cos(Complex.arg(x) / 2.0);
        z.im = Math.sqrt(Complex.abs(x)) * Math.sin(Complex.arg(x) / 2.0);
        return z;
    }

    public static Complex pow(Complex x, Complex y) {
        if (x.equals(Complex.complex(0.0)) && y.re > 0.0) {
            return Complex.complex();
        }
        return Complex.exp(Complex.mult(y, Complex.log(x)));
    }

    public static Complex pow(Complex x, double y) {
        Complex z = new Complex();
        z.re = Math.pow(Complex.abs(x), y) * Math.cos(y * Complex.arg(x));
        z.im = Math.pow(Complex.abs(x), y) * Math.sin(y * Complex.arg(x));
        return z;
    }

    public static Complex pow(double x, Complex y) {
        return Complex.pow(Complex.complex(x), y);
    }
}

