/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.plugin.system;

import org.seamcat.model.RadioSystem;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.plugin.system.Context;
import org.seamcat.model.plugin.system.DefaultCorrelationDefinitions;
import org.seamcat.model.plugin.system.SimulationInstance;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.plugin.system.SystemSpaces;
import org.seamcat.model.plugin.system.optional.CorrelationDefinitions;
import org.seamcat.model.types.result.Results;

public class ContexedSystemPlugin {
    private final SystemPlugin plugin;
    private final Context context;
    private final CorrelationDefinitions corrDef;
    private Distribution distribution;
    private SystemSpaces systemSpaces;
    private SystemPlugin enclosing;

    public ContexedSystemPlugin(SystemPlugin plugin, Context context, SystemPlugin enclosing) {
        this.plugin = plugin;
        this.context = context;
        this.enclosing = enclosing;
        this.corrDef = plugin instanceof CorrelationDefinitions ? (CorrelationDefinitions)((Object)plugin) : DefaultCorrelationDefinitions.instance;
    }

    @Deprecated
    public Context getContext() {
        return this.context;
    }

    public RadioSystem getSystem() {
        return this.plugin.getSystem(this.context);
    }

    public void preSimulation(Results pre) {
        this.plugin.preSimulation(this.context, pre);
    }

    public void postSimulation(Results results) {
        this.plugin.postSimulation(this.context, results);
    }

    public SimulationInstance simulationInstance() {
        SystemPlugin relevant = this.plugin;
        if (this.enclosing != null) {
            relevant = this.enclosing;
        }
        this.systemSpaces = relevant.generateSystemSpaces(null);
        return relevant.simulationInstance(this.context, this.systemSpaces);
    }

    public SystemSpaces getSystemSpaces() {
        return this.systemSpaces;
    }

    public SystemPlugin getSystemPlugin() {
        return this.plugin;
    }

    public CorrelationDefinitions getCorrelationDefinitions() {
        return this.corrDef;
    }

    public void setFrequency(Distribution distribution) {
        this.distribution = distribution;
    }

    public Distribution getFrequency() {
        return this.distribution;
    }

    public String getName() {
        return this.plugin.getUI().description().name();
    }
}

