/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.plugin.propagation;

import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.Config;
import org.seamcat.model.plugin.OptionalValue;

public interface PCLUTTERInput {
    public static final Environment Environment_Tx = Environment.URBAN;
    public static final OptionalValue<Double> clutterHeightTx = Factory.results().optional(false, 10.0);
    public static final OptionalValue<Double> wsTx = Factory.results().optional(false, 27.0);
    public static final Environment Environment_Rx = Environment.URBAN;
    public static final OptionalValue<Double> clutterHeightRx = Factory.results().optional(false, 10.0);
    public static final OptionalValue<Double> wsRx = Factory.results().optional(false, 27.0);
    public static final Distribution locPercentage2 = Factory.distributionFactory().getUniformDistribution(50.0, 50.0);
    public static final Distribution locPercentage3 = Factory.distributionFactory().getUniformDistribution(50.0, 50.0);
    public static final Distribution theta = Factory.distributionFactory().getUniformDistribution(0.0, 0.0);
    public static final boolean variations = false;
    public static final boolean clutter1 = true;
    public static final boolean clutter1Tx = false;
    public static final boolean clutter2Rx = false;
    public static final boolean clutter2 = false;
    public static final boolean clutter3 = false;

    @Config(order=2, name="\u00a73.1: Site-specific clutter model according to P.1812-4", defineGroup="clutter1")
    public boolean clutter1();

    @Config(order=3, name="Apply clutter at the Tx", group="clutter1", defineGroup="clutter1Tx")
    public boolean clutter1Tx();

    @Config(order=4, name="Local clutter at the Tx", group="clutter1Tx")
    public Environment Environment_Tx();

    @Config(order=5, name="User-specified clutter the Tx", group="clutter1Tx", defineGroup="userSpecifiedClutter1Tx", unit="m")
    public boolean userSpecifiedClutterTx();

    @Config(order=6, name="Clutter height around the Tx", group="userSpecifiedClutter1Tx", unit="m", toolTip="User-defined value of clutter height will override the default value in general environment above.")
    public OptionalValue<Double> clutterHeightTx();

    @Config(order=7, name="Street width around the Tx", group="userSpecifiedClutter1Tx", unit="m", toolTip="User-defined value of street width will override the default value in general environment above.")
    public OptionalValue<Double> wsTx();

    @Config(order=9, name="Apply clutter at the Rx", group="clutter1", defineGroup="clutter1Rx")
    public boolean clutter1Rx();

    @Config(order=10, name="Local clutter at the Rx", group="clutter1Rx")
    public Environment Environment_Rx();

    @Config(order=11, name="User-specified clutter around the Rx", group="clutter1Rx", defineGroup="userSpecifiedClutter1Rx", unit="m")
    public boolean userSpecifiedClutterRx();

    @Config(order=12, name="Clutter height around the Rx", group="userSpecifiedClutter1Rx", unit="m", toolTip="User-defined value of clutter height will override the default value in general environment above.")
    public OptionalValue<Double> clutterHeightRx();

    @Config(order=13, name="Street width around the Rx", group="userSpecifiedClutter1Rx", unit="m", toolTip="User-defined value of street width will override the default value in general environment above.")
    public OptionalValue<Double> wsRx();

    @Config(order=15, name="\u00a73.2: Site-general clutter model for terrestrial paths", defineGroup="clutter2")
    public boolean clutter2();

    @Config(order=16, name="Percentage of locations", unit="%", group="clutter2", distributions={"CONSTANT", "DISCRETE_UNIFORM", "UNIFORM", "USER_DEFINED", "STAIR"})
    public Distribution locPercentage2();

    @Config(order=17, name="Apply clutter at the Tx", group="clutter2")
    public boolean clutter32Tx();

    @Config(order=18, name="Apply clutter at the Rx", group="clutter2")
    public boolean clutter32Rx();

    @Config(order=19, name="\u00a73.3: Site-general clutter model for earth-to-space paths", defineGroup="clutter3")
    public boolean clutter3();

    @Config(order=21, name="Percentage of locations", unit="%", group="clutter3", distributions={"CONSTANT", "DISCRETE_UNIFORM", "UNIFORM", "USER_DEFINED", "STAIR"})
    public Distribution locPercentage3();

    @Config(order=23, name="Elevation angle", unit="degrees", group="clutter3", distributions={"CONSTANT", "STAIR", "USER_DEFINED", "UNIFORM", "DISCRETE_UNIFORM", "UNIFORM_POLAR_ANGLE"})
    public Distribution theta();

    public static enum Environment {
        WATER("Water/Sea", 10.0, 2),
        OPEN("Open/Rural", 10.0, 2),
        SUBURBAN("Suburban", 10.0, 1),
        URBAN("Urban/Trees/Forest", 15.0, 1),
        DENSE_URBAN("Dense Urban", 20.0, 1);

        private String name;
        private int eqnum;
        private double R;

        private Environment(String name, double R, int eqnum) {
            this.name = name;
            this.eqnum = eqnum;
            this.R = R;
        }

        public String toString() {
            return this.name;
        }

        public int eqnum() {
            return this.eqnum;
        }

        public double R() {
            return this.R;
        }
    }
}

