/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.plugin.propagation;

import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.Config;
import org.seamcat.model.plugin.OptionalValue;

public interface P1546ver5Input {
    public static final OptionalValue<Double> stdDev = Factory.results().optional(false, 0.0);
    public static final Distribution timePercentage = Factory.distributionFactory().getUniformDistribution(50.0, 50.0);
    public static final Environment generalEnvironment = Environment.Urban;
    public static final OptionalValue<Double> clutterHeightRx = Factory.results().optional(false, 0.0);
    public static final Distribution locationProbability = Factory.distributionFactory().getUniformDistribution(50.0, 50.0);
    public static final Environment generalEnvironmentTx = Environment.Urban;
    public static final OptionalValue<Double> clutterHeightTx = Factory.results().optional(true, 0.0);
    public static final OptionalValue<Double> effectiveHeightRxAntenna = Factory.results().optional(false, 0.0);
    public static final OptionalValue<Double> effectiveHeightTxAntenna = Factory.results().optional(false, 0.0);
    public static final OptionalValue<Double> terrainClearanceAngleRx = Factory.results().optional(false, 0.0);
    public static final OptionalValue<Double> terrainClearanceAngleTx = Factory.results().optional(false, 0.0);
    public static final OptionalValue<Double> terrainHeightRx = Factory.results().optional(false, 0.0);
    public static final OptionalValue<Double> terrainHeightTx = Factory.results().optional(false, 0.0);
    public static final boolean terminalDesignations = true;
    public static final boolean variations = true;

    @Config(order=1, name="User specified std. dev.", unit="dB", toolTip="User specified standard deviation")
    public OptionalValue<Double> stdDev();

    @Config(order=2, name="Time percentage", unit="%", distributions={"CONSTANT", "DISCRETE_UNIFORM", "UNIFORM", "USER_DEFINED", "STAIR"})
    public Distribution timePercentage();

    @Config(order=3, name="General environment around the Rx")
    public Environment generalEnvironment();

    @Config(order=4, name="Representative clutter height around the Rx", unit="m", toolTip="User defined value of clutter height will override the default value in general environment above.")
    public OptionalValue<Double> clutterHeightRx();

    @Config(order=5, name="Location probability", unit="%", distributions={"CONSTANT", "DISCRETE_UNIFORM", "UNIFORM", "USER_DEFINED", "STAIR"})
    public Distribution locationProbability();

    @Config(order=6, name="Area of location variability")
    public Area area();

    @Config(order=7, name="System")
    public System system();

    @Config(order=8, name="General environment around the Tx")
    public Environment generalEnvironmentTx();

    @Config(order=9, name="Representative clutter height around the Tx", unit="m", toolTip="User defined value of clutter height will override the default value in general environment above.")
    public OptionalValue<Double> clutterHeightTx();

    @Config(order=10, name="Average profile height around the Rx", unit="m", toolTip="Average level of the ground between distances of 3 and 15 km from the receiver (or  between 0.2 d and d for d < 15 km).")
    public OptionalValue<Double> effectiveHeightRxAntenna();

    @Config(order=11, name="Average profile height around the Tx", unit="m", toolTip="Average level of the ground between distances of 3 and 15 km from the transmitter (or  between 0.2 d and d for d < 15 km).")
    public OptionalValue<Double> effectiveHeightTxAntenna();

    @Config(order=12, name="Terrain clearance angle (at the Rx)", unit="deg", toolTip="Elevation angle from the Rx antenna which clears all terrain obstructions in the direction of the Tx antenna over a distance of up to 16 km but not beyond the Tx antenna.")
    public OptionalValue<Double> terrainClearanceAngleRx();

    @Config(order=13, name="Terrain clearance angle (at the Tx)", unit="deg", toolTip="Elevation angle from the Tx antenna which clears all terrain obstructions in the direction of the Rx antenna over a distance of up to 16 km but not beyond the Rx antenna.")
    public OptionalValue<Double> terrainClearanceAngleTx();

    @Config(order=14, name="Terrain height above sea level at the Rx", unit="m")
    public OptionalValue<Double> terrainHeightRx();

    @Config(order=15, name="Terrain height above sea level at the Tx", unit="m")
    public OptionalValue<Double> terrainHeightTx();

    @Config(order=16, name="Terminal designations (Annex 5, Par. 1.1): use options a), b) and c)")
    public boolean terminalDesignations();

    public static enum SeaType {
        Warm("Warm Sea"),
        Cold("Cold Sea");

        private String name;

        private SeaType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Area {
        _500_x_500_m("500 x 500 m"),
        lessthan_2_km_radius("< 2 km radius"),
        lessthan_50_km_radius("< 50 km radius");

        private String name;

        private Area(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum System {
        Mobile("Mobile"),
        Broadcasting_digital("Broadcasting digital"),
        Broadcasting_analogue("Broadcasting analogue");

        private String name;

        private System(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Environment {
        Rural("Rural"),
        Suburban("Suburban"),
        Urban("Urban"),
        Dense_Urban("Dense Urban");

        private String name;

        private Environment(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

