/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.plugin.propagation;

import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.Config;

public interface LongleyRice_modInput {
    public static final Polarization polarisation = Polarization.Horizontal;
    public static final Site siteCriteria = Site.Random;
    public static final Climate radioClimate = Climate.Continental_Temperate;
    public static final Variability variability = Variability.Broadcast;
    public static final int meanSurface = 301;
    public static final double terrainIrregular = 90.0;
    public static final double conductivity = 0.005;
    public static final double relPermit = 15.0;
    public static final Distribution timePercentage = Factory.distributionFactory().getUniformDistribution(50.0, 50.0);
    public static final Distribution locationPercentage = Factory.distributionFactory().getUniformDistribution(50.0, 50.0);
    public static final Distribution confidentPercent = Factory.distributionFactory().getUniformDistribution(50.0, 50.0);
    public static final double stdDev = 0.0;
    public static final boolean variations = false;

    @Config(order=1, name="Mean surface refractivity")
    public int meanSurface();

    @Config(order=2, name="Terrain irregular parameter", unit="m")
    public double terrainIrregular();

    @Config(order=3, name="Conductivity", unit="S/m")
    public double conductivity();

    @Config(order=4, name="Relative permittivity")
    public double relPermit();

    @Config(order=5, name="Polarization")
    public Polarization polarisation();

    @Config(order=6, name="Siting criteria")
    public Site siteCriteria();

    @Config(order=7, name="Radio Climate")
    public Climate radioClimate();

    @Config(order=8, name="Time percentage [1 ... 99%]", unit="%", distributions={"CONSTANT", "DISCRETE_UNIFORM", "UNIFORM", "USER_DEFINED", "STAIR"})
    public Distribution timePercentage();

    @Config(order=9, name="Location percentage [1 ... 99%]", unit="%", distributions={"CONSTANT", "DISCRETE_UNIFORM", "UNIFORM", "USER_DEFINED", "STAIR"})
    public Distribution locationPercentage();

    @Config(order=10, name="Confidential percentage [1 ... 99%]", unit="%", distributions={"CONSTANT", "DISCRETE_UNIFORM", "UNIFORM", "USER_DEFINED", "STAIR"})
    public Distribution confidentPercent();

    @Config(order=11, name="Mode of variability")
    public Variability variability();

    @Config(order=12, name="Standard deviation", unit="dB")
    public double stdDev();

    public static enum Variability {
        Single,
        Individual,
        Broadcast;

    }

    public static enum Climate {
        Equatorial("Equatorial"),
        Continental_Subtropical("Continental Subtropical"),
        Maritime_Subtropical("Maritime Subtropical"),
        Desert("Desert"),
        Continental_Temperate("Continental Temperate"),
        Maritime_Temperate_over_land("Maritime Temperate over land"),
        Maritime_Temperate_over_sea("Maritime Temperate over sea");

        private String name;

        private Climate(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Site {
        Random("Random"),
        Careful("Careful"),
        VeryCareful("Very Careful");

        private String name;

        private Site(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Polarization {
        Horizontal,
        Vertical;

    }
}

