/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.plugin.propagation;

import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.Config;
import org.seamcat.model.plugin.OptionalValue;

public interface JTG56Input {
    public static final boolean allowReciprocity = true;
    public static final boolean useSE42 = false;
    public static final Distribution time = Factory.distributionFactory().getConstantDistribution(50.0);
    public static final double cutOff = 40.0;
    public static final OptionalValue<Double> userClutter = Factory.results().optional(false, 10.0);

    @Config(order=1, name="Allow reciprocity in the antenna height", toolTip="<html>This JTG56 plugin allows reciprocity in the antenna height. <br>Note that the combination of low antenna height (i.e. 1.5 m)<br>for both Rx and Tx should be limited to small distances as this <br>combination is not valid for the P1546.</html>")
    public boolean allowReciprocity();

    @Config(order=2, name="use SE42 modification (Hata instead of Free Space for d <= 0.1 km)", toolTip="for the transition range: cut off distance to 100 m")
    public boolean useSE42();

    @Config(order=3, name="General Environment")
    public Environment generalEnv();

    @Config(order=4, name="Time probability [1% or 50%]", unit="%", distributions={"CONSTANT", "DISCRETE_UNIFORM", "UNIFORM", "USER_DEFINED", "STAIR"})
    public Distribution time();

    @Config(order=5, name="Cutt off discance [< 100 m]", unit="m")
    public double cutOff();

    @Config(order=6, name="User defined local clutter height", unit="m")
    public OptionalValue<Double> userClutter();

    public static enum Environment {
        Urban,
        Suburban,
        Rural;

    }
}

