/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.plugin.antenna;

import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.Config;
import org.seamcat.model.plugin.OptionalValue;
import org.seamcat.model.plugin.antenna.TiltModes;

public interface ITU_R_F1336_4_rec_3_Input {
    public static final TiltModes tiltMode = TiltModes.MECHANICAL_ONLY;
    public static final Distribution additionalTilt = Factory.distributionFactory().getConstantDistribution(0.0);
    public static final double phi3 = 65.0;
    public static final double kp = 0.7;
    public static final double ka = 0.7;
    public static final double kh = 0.8;
    public static final double kv = 0.7;
    public static final OptionalValue<Double> theta3 = Factory.results().optional(false, 5.0);
    public static final double peakGain = 16.0;

    @Config(order=2, name="Consider the peak envelope", toolTip="not selected means average envelope")
    public boolean usePeakGain();

    @Config(order=4, name="Select tilt mode of 'Antenna elevation'", toolTip="if 'Mechanical and electrical' is selected, the angle defined there is used additionally to the mechanically tilted 'Antenna elevation'")
    public TiltModes tiltMode();

    @Config(order=6, name="Mechanical and electrical", defineGroup="mAnde", toolTip="applies the below angle electrically tilted to the mechanically tilted 'Antenna elevation' ")
    public boolean mAnde();

    @Config(order=8, name="Additional electrical tilt", group="mAnde", unit="degree", distributions={"CONSTANT", "DISCRETE_UNIFORM", "UNIFORM", "UNIFORM_POLAR_ANGLE", "USER_DEFINED", "STAIR"})
    public Distribution additionalTilt();

    @Config(order=10, name="3 dB beamwidth in the azimuth plane", unit="degree")
    public double phi3();

    @Config(order=12, name="vertical beam width [NOTE 4]", unit="degree", toolTip="in case this value is known, it is recommended to use the known \u03b83 as an input parameter. ")
    public OptionalValue<Double> theta3();

    @Config(order=14, name="relative minimum gain for peak side-lobe\npatterns kp (F.1336: 0.7)")
    public double kp();

    @Config(order=16, name="relative minimum gain for average side-lobe\npatterns ka (F.1336: 0.7)")
    public double ka();

    @Config(order=18, name="azimuth pattern adjustment factor kh (F.1336: 0 ... 1)")
    public double kh();

    @Config(order=20, name="elevation pattern adjustment factor kv (F.1336: 0 ... 1)")
    public double kv();
}

