/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.plugin.antenna;

import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Function;
import org.seamcat.model.plugin.Config;
import org.seamcat.model.types.AntennaGain;

public interface Antenna_3GPP_TR_37_840_Input {
    public static final TypicalAntenna antennaType = TypicalAntenna.B10;
    public static final boolean specific = false;
    public static final int nh = 4;
    public static final int nv = 15;
    public static final double horizontalSpacing = 0.5;
    public static final double verticalSpacing = 0.9;
    public static final AntennaGain element = Factory.antennaGainFactory().getBeamFormingElementAntenna();
    public static final Function correlationFactor = Factory.functionFactory().constantFunction(1.0);

    @Config(order=1, name="<HtMl>Correlation factor &rho")
    public Function correlationFactor();

    @Config(order=3, name="Pre-defined array parameters  ", toolTip="<Html>According to Table 5.4.4.2.1-1 of 3GPP TR 37.840", invertedGroup="specific")
    public TypicalAntenna antennaType();

    @Config(order=4, name="User-defined array parameters", defineGroup="specific")
    public boolean specific();

    @Config(order=10, name="Number of columns", group="specific")
    public int nh();

    @Config(order=12, name="Number of radiation elements per column", group="specific")
    public int nv();

    @Config(order=13, name="<HtMl>Horizontal element spacing d/&lambda;", group="specific")
    public double horizontalSpacing();

    @Config(order=14, name="<HtMl>Vertical element spacing d/&lambda;", group="specific")
    public double verticalSpacing();

    @Config(order=17, name="Element antenna", group="specific")
    public AntennaGain element();

    public static enum TypicalAntenna {
        A1("A1 - 1 column, 1 element", 1, 1, 8.7, "na", "na", 65.0, 65.0, 0.5, 8.7),
        A5("A5 - 1 column, 5 elements", 1, 5, 15.0, "na", 0.9, 65.0, 65.0, 0.8, 15.0),
        A10("A10 - 1 column, 10 elements", 1, 10, 18.0, "na", 0.9, 65.0, 65.0, 1.0, 18.0),
        A15("A15 - 1 column, 15 elements", 1, 15, 19.5, "na", 0.9, 65.0, 65.0, 1.2, 19.5),
        B5("B5 - 2 columns, 5 elements", 2, 5, 14.5, 0.6, 0.9, 80.0, 65.0, 0.8, 17.0),
        B10("B10 - 2 columns, 10 elements", 2, 10, 17.0, 0.6, 0.9, 80.0, 65.0, 1.0, 19.5),
        B15("B15 - 2 columns, 15 elements", 2, 15, 18.5, 0.6, 0.9, 80.0, 65.0, 1.2, 21.0),
        D5("D5 - 4 columns, 5 elements", 4, 5, 14.5, 0.5, 0.9, 80.0, 65.0, 0.8, 20.0),
        D10("D10 - 4 columns, 10 elements", 4, 10, 17.0, 0.5, 0.9, 80.0, 65.0, 1.0, 22.5),
        D15("D15 - 4 columns, 15 elements", 4, 15, 18.5, 0.5, 0.9, 80.0, 65.0, 1.2, 24.0);

        private String name;
        private int columns;
        private int elements;
        private Object spacingH;
        private Object spacingV;
        private double gainPerColumn;
        private double beamWidthH;
        private double beamWidthV;
        private double cableLoss;
        private double maxGain;

        private TypicalAntenna(String name, int columns, int elements, double gainPerColumn, Object spacingH, Object spacingV, double beamWidthH, double beamWidthV, double cableLoss, double maxGain) {
            this.name = name;
            this.columns = columns;
            this.elements = elements;
            this.gainPerColumn = gainPerColumn;
            this.spacingH = spacingH;
            this.spacingV = spacingV;
            this.beamWidthH = beamWidthH;
            this.beamWidthV = beamWidthV;
            this.cableLoss = cableLoss;
            this.maxGain = maxGain;
        }

        public int getColumns() {
            return this.columns;
        }

        public int getElements() {
            return this.elements;
        }

        public double getSpacingV() {
            if (this.elements > 1) {
                return (Double)this.spacingV;
            }
            return 0.0;
        }

        public double getGainPerColumn() {
            return this.gainPerColumn;
        }

        public double getBeamWidthH() {
            return this.beamWidthH;
        }

        public double getBeamWidthV() {
            return this.beamWidthV;
        }

        public double getCableLoss() {
            return this.cableLoss;
        }

        public String toString() {
            return this.name;
        }

        public double gainSingleElement() {
            if (this.elements > 1) {
                return this.getMaxGain() - 10.0 * Math.log10(this.getElements() * this.getColumns());
            }
            return 8.7;
        }

        public double getSpacingH() {
            if (this.columns > 1) {
                return (Double)this.spacingH;
            }
            return 0.0;
        }

        public double getMaxGain() {
            return this.maxGain;
        }
    }
}

