/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.geometry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.seamcat.model.geometry.Inequality2D;
import org.seamcat.model.geometry.LineSegment2D;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.geometry.Vector2D;

public class Polygon2D {
    private final List<Point2D> vertices;

    public Polygon2D(List<Point2D> vertices) {
        if (vertices.size() < 1) {
            throw new IllegalArgumentException("Less than one vertex is invalid");
        }
        ArrayList<Point2D> copyOfVertices = new ArrayList<Point2D>(vertices);
        if (copyOfVertices.size() > 2) {
            if (!Polygon2D.isConvex(copyOfVertices)) {
                throw new IllegalArgumentException("Vertices do not form a convex polygon");
            }
            if (!Polygon2D.isClockWise(copyOfVertices)) {
                Collections.reverse(copyOfVertices);
            }
        }
        this.vertices = Collections.unmodifiableList(copyOfVertices);
    }

    private static boolean isConvex(ArrayList<Point2D> vertices) {
        int i;
        int size = vertices.size();
        if (size < 3) {
            return true;
        }
        boolean foundCwTurn = false;
        boolean foundCcwTurn = false;
        ArrayList<Vector2D> edges = new ArrayList<Vector2D>(size + 1);
        for (i = 0; i < size; ++i) {
            edges.add(Vector2D.fromTo(vertices.get(i), vertices.get((i + 1) % size)));
        }
        for (i = 0; i < edges.size(); ++i) {
            Vector2D edge2;
            Vector2D edge1 = (Vector2D)edges.get(i);
            double normalDotProduct = edge1.dotProduct((edge2 = (Vector2D)edges.get((i + 1) % size)).cwNormal());
            if (normalDotProduct < 0.0) {
                foundCwTurn = true;
                continue;
            }
            if (!(normalDotProduct > 0.0)) continue;
            foundCcwTurn = true;
        }
        return !foundCwTurn || !foundCcwTurn;
    }

    private static boolean isClockWise(ArrayList<Point2D> vertices) {
        Vector2D secondEdge;
        if (vertices.size() < 3) {
            return true;
        }
        Vector2D firstEdge = Vector2D.fromTo(vertices.get(0), vertices.get(1));
        return firstEdge.dotProduct((secondEdge = Vector2D.fromTo(vertices.get(1), vertices.get(2))).cwNormal()) < 0.0;
    }

    public Polygon2D(Point2D point) {
        this.vertices = Collections.singletonList(point);
    }

    public static Polygon2D of(double ... pointCoords) {
        if (pointCoords.length < 2 || pointCoords.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        ArrayList<Point2D> vertices = new ArrayList<Point2D>(pointCoords.length / 2);
        for (int i = 0; i < pointCoords.length / 2; ++i) {
            vertices.add(new Point2D(pointCoords[i * 2], pointCoords[i * 2 + 1]));
        }
        return new Polygon2D(vertices);
    }

    public List<Point2D> getVertices() {
        return this.vertices;
    }

    public List<LineSegment2D> getEdges() {
        ArrayList<LineSegment2D> edges = new ArrayList<LineSegment2D>(this.vertices.size());
        for (int i = 0; i < this.vertices.size() - 1; ++i) {
            edges.add(new LineSegment2D(this.vertices.get(i), this.vertices.get(i + 1)));
        }
        if (this.vertices.size() > 1) {
            edges.add(new LineSegment2D(this.vertices.get(this.vertices.size() - 1), this.vertices.get(0)));
        }
        return Collections.unmodifiableList(edges);
    }

    public List<Inequality2D> getInequalities() {
        ArrayList<Inequality2D> inequalities = new ArrayList<Inequality2D>();
        Point2D center = this.center();
        for (LineSegment2D edge : this.getEdges()) {
            inequalities.add(Polygon2D.calculateInequality(edge, center));
        }
        return inequalities;
    }

    public static Inequality2D calculateInequality(LineSegment2D lineSegment, Point2D pointInHalfPlane) {
        double xCoefficient = lineSegment.getA().getY() - lineSegment.getB().getY();
        double yCoefficient = lineSegment.getB().getX() - lineSegment.getA().getX();
        double constant = -xCoefficient * lineSegment.getA().getX() - yCoefficient * lineSegment.getA().getY();
        if (xCoefficient * pointInHalfPlane.getX() + yCoefficient * pointInHalfPlane.getY() + constant < 0.0) {
            xCoefficient = -xCoefficient;
            yCoefficient = -yCoefficient;
            constant = -constant;
        }
        return new Inequality2D(xCoefficient, yCoefficient, constant);
    }

    public boolean contains(Point2D p) {
        for (Inequality2D inequality2d : this.getInequalities()) {
            if (inequality2d.evaluate(p)) continue;
            return false;
        }
        return true;
    }

    public Polygon2D translate(Vector2D v) {
        ArrayList<Point2D> translatedVertices = new ArrayList<Point2D>(this.vertices.size());
        for (Point2D p : this.vertices) {
            translatedVertices.add(p.translate(v));
        }
        return new Polygon2D(translatedVertices);
    }

    public Point2D center() {
        double xSum = 0.0;
        double ySum = 0.0;
        for (Point2D v : this.vertices) {
            xSum += v.getX();
            ySum += v.getY();
        }
        return new Point2D(xSum / (double)this.vertices.size(), ySum / (double)this.vertices.size());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Polygon2D [");
        for (Point2D p : this.vertices) {
            sb.append("(");
            sb.append(p.getX());
            sb.append(", ");
            sb.append(p.getY());
            sb.append("), ");
        }
        sb.append("]");
        return sb.toString();
    }
}

