/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.geometry;

import java.util.Comparator;
import org.seamcat.model.geometry.Vector2D;

public class Point2D {
    public static final Point2D ORIGIN = new Point2D(0.0, 0.0);
    public static final Comparator<Point2D> X_COMPARATOR = new Comparator<Point2D>(){

        @Override
        public int compare(Point2D o1, Point2D o2) {
            return Double.compare(o1.x, o2.x);
        }
    };
    public static final Comparator<Point2D> Y_COMPARATOR = new Comparator<Point2D>(){

        @Override
        public int compare(Point2D o1, Point2D o2) {
            return Double.compare(o1.y, o2.y);
        }
    };
    private double x;
    private double y;

    public Point2D() {
        this(0.0, 0.0);
    }

    public Point2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Point2D(Point2D p) {
        this(p.getX(), p.getY());
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public Point2D translate(Vector2D v) {
        return new Point2D(this.x + v.getX(), this.y + v.getY());
    }

    public Point2D add(Point2D other) {
        return new Point2D(this.x + other.getX(), this.y + other.getY());
    }

    public Point2D add(double x, double y) {
        return new Point2D(this.x + x, this.y + y);
    }

    public Point2D subtract(Point2D other) {
        return new Point2D(this.x - other.getX(), this.y - other.getY());
    }

    public Point2D subtract(double x, double y) {
        return this.add(-x, -y);
    }

    public Point2D scale(double factor) {
        return new Point2D(factor * this.x, factor * this.y);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Point2D other = (Point2D)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ')';
    }
}

