/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.geometry;

import java.util.ArrayList;
import java.util.List;
import org.seamcat.model.geometry.Inequality2D;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.geometry.Polygon2D;

public class InnerPlacementBoundaryCalculator {
    public static Polygon2D innerPlacementBoundary(Polygon2D outer, Polygon2D inner) {
        InnerPlacementBoundaryCalculator.checkValidArguments(outer, inner);
        double comparisonPrecision = InnerPlacementBoundaryCalculator.determineComparisonPrecision(outer, inner);
        List<Inequality2D> boundaryInequalities = InnerPlacementBoundaryCalculator.calculateBoundaryInequalities(outer, inner);
        int relevantInequalityIndex = InnerPlacementBoundaryCalculator.searchForRelevantInequality(boundaryInequalities, comparisonPrecision);
        if (relevantInequalityIndex == -1) {
            return null;
        }
        List<Point2D> boundaryVertices = InnerPlacementBoundaryCalculator.scanForVertices(relevantInequalityIndex, boundaryInequalities, comparisonPrecision);
        InnerPlacementBoundaryCalculator.removeConsequtiveDuplicates(boundaryVertices, comparisonPrecision);
        return new Polygon2D(boundaryVertices);
    }

    private static void checkValidArguments(Polygon2D outer, Polygon2D inner) {
        if (outer.getVertices().size() < 3 || inner.getVertices().size() < 3) {
            throw new IllegalArgumentException("Polygons with less than three vertices not supported");
        }
    }

    private static double determineComparisonPrecision(Polygon2D outer, Polygon2D inner) {
        double maxAbsValue = 0.0;
        for (Point2D p : outer.getVertices()) {
            if (Math.abs(p.getX()) > maxAbsValue) {
                maxAbsValue = Math.abs(p.getX());
            }
            if (!(Math.abs(p.getY()) > maxAbsValue)) continue;
            maxAbsValue = Math.abs(p.getY());
        }
        for (Point2D p : inner.getVertices()) {
            if (Math.abs(p.getX()) > maxAbsValue) {
                maxAbsValue = Math.abs(p.getX());
            }
            if (!(Math.abs(p.getY()) > maxAbsValue)) continue;
            maxAbsValue = Math.abs(p.getY());
        }
        return maxAbsValue * 1.0E-11;
    }

    private static List<Inequality2D> calculateBoundaryInequalities(Polygon2D outer, Polygon2D inner) {
        List<Inequality2D> outerInequalities = outer.getInequalities();
        ArrayList<Inequality2D> boundaryInequalities = new ArrayList<Inequality2D>();
        for (Inequality2D io : outerInequalities) {
            Point2D constrainingInnerVertex = InnerPlacementBoundaryCalculator.findConstrainingVertex(io, inner);
            Inequality2D ib = InnerPlacementBoundaryCalculator.calculateBoundaryInequality(io, constrainingInnerVertex);
            boundaryInequalities.add(ib);
        }
        return boundaryInequalities;
    }

    private static Point2D findConstrainingVertex(Inequality2D inequality, Polygon2D polygon) {
        double lowestInequalityLhs = Double.MAX_VALUE;
        Point2D pointWithLowestInequalityLhs = null;
        for (Point2D p : polygon.getVertices()) {
            double inequalityLhs = inequality.evaluateLhs(p);
            if (!(inequalityLhs < lowestInequalityLhs)) continue;
            lowestInequalityLhs = inequalityLhs;
            pointWithLowestInequalityLhs = p;
        }
        return pointWithLowestInequalityLhs;
    }

    private static Inequality2D calculateBoundaryInequality(Inequality2D i, Point2D p) {
        return new Inequality2D(i.getA(), i.getB(), i.getA() * p.getX() + i.getB() * p.getY() + i.getC());
    }

    private static int searchForRelevantInequality(List<Inequality2D> boundaryInequalities, double comparisonPrecision) {
        int p = boundaryInequalities.size();
        for (int distance = 1; distance <= p / 2; ++distance) {
            for (int i = 0; i < p; ++i) {
                boolean intersectionIsAVertex;
                Inequality2D i2;
                Inequality2D i1 = boundaryInequalities.get(i);
                Point2D intersection = i1.intersection(i2 = boundaryInequalities.get((i + distance) % p));
                boolean bl = intersectionIsAVertex = intersection != null && InnerPlacementBoundaryCalculator.isInPolygon(intersection, boundaryInequalities, comparisonPrecision);
                if (!intersectionIsAVertex) continue;
                return i;
            }
        }
        return -1;
    }

    private static boolean isInPolygon(Point2D p, List<Inequality2D> polygonInequalities, double comparisonPrecision) {
        for (Inequality2D i : polygonInequalities) {
            if (!(i.evaluateLhs(p) < 0.0 - comparisonPrecision)) continue;
            return false;
        }
        return true;
    }

    private static List<Point2D> scanForVertices(int startingRelevantIndex, List<Inequality2D> inequalities, double comparisonPrecision) {
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        int currentRelevantIndex = startingRelevantIndex;
        block0: do {
            for (int i = 1; i < inequalities.size() - 1; ++i) {
                Inequality2D nextInequality;
                int nextIndex = (currentRelevantIndex + i) % inequalities.size();
                Inequality2D currentRelevantInequality = inequalities.get(currentRelevantIndex);
                Point2D intersection = currentRelevantInequality.intersection(nextInequality = inequalities.get(nextIndex));
                if (intersection != null && InnerPlacementBoundaryCalculator.isInPolygon(intersection, inequalities, comparisonPrecision)) {
                    result.add(intersection);
                    currentRelevantIndex = nextIndex;
                    continue block0;
                }
                if (i != inequalities.size() - 2) continue;
                throw new RuntimeException("Next intersection with relevant inequality not found. This can't happen.");
            }
        } while (currentRelevantIndex != startingRelevantIndex);
        return result;
    }

    private static void removeConsequtiveDuplicates(List<Point2D> list, double comparisonPrecision) {
        for (int currentIndex = 0; currentIndex < list.size() - 1; ++currentIndex) {
            int successorIndex = currentIndex + 1;
            while (successorIndex < list.size() && InnerPlacementBoundaryCalculator.closeTo(list.get(currentIndex), list.get(successorIndex), comparisonPrecision)) {
                list.remove(successorIndex);
            }
        }
        if (list.size() >= 2 && InnerPlacementBoundaryCalculator.closeTo(list.get(0), list.get(list.size() - 1), comparisonPrecision)) {
            list.remove(list.size() - 1);
        }
    }

    private static boolean closeTo(Point2D p1, Point2D p2, double comparisonPrecision) {
        return Math.abs(p1.getX() - p2.getX()) < comparisonPrecision && Math.abs(p1.getY() - p2.getY()) < comparisonPrecision;
    }
}

