/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.geometry;

import org.seamcat.model.geometry.Point2D;

public class Inequality2D {
    private final double a;
    private final double b;
    private final double c;

    public Inequality2D(double a, double b, double c) {
        if (c < 0.0) {
            a /= -c;
            b /= -c;
            c = -1.0;
        } else if (c > 0.0) {
            a /= c;
            b /= c;
            c = 1.0;
        } else if (b < 0.0) {
            a /= -b;
            b = -1.0;
        } else if (b > 0.0) {
            a /= b;
            b = 1.0;
        } else if (a < 0.0) {
            a = -1.0;
        } else if (a > 0.0) {
            a = 1.0;
        }
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getC() {
        return this.c;
    }

    boolean evaluate(Point2D p) {
        return this.a * p.getX() + this.b * p.getY() + this.c >= 0.0;
    }

    double evaluateLhs(Point2D p) {
        return this.a * p.getX() + this.b * p.getY() + this.c;
    }

    Point2D intersection(Inequality2D other) {
        double divisor = other.a * this.b - this.a * other.b;
        if (divisor == 0.0) {
            return null;
        }
        double x = (other.b * this.c - this.b * other.c) / divisor;
        double y = (this.a * other.c - other.a * this.c) / divisor;
        return new Point2D(x, y);
    }

    public String toString() {
        return "Inequality2D [a=" + this.a + ", b=" + this.b + ", c=" + this.c + "]";
    }
}

