/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.generic;

import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.BlockingMask;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.IntermodulationRejectionMask;
import org.seamcat.model.generic.Defaults;
import org.seamcat.model.plugin.Config;
import org.seamcat.model.plugin.OptionalValue;
import org.seamcat.presentation.genericgui.item.AbstractItem;
import org.seamcat.presentation.genericgui.item.FunctionLibraryItem;
import org.seamcat.presentation.genericgui.panelbuilder.ChangeListener;
import org.seamcat.simulation.generic.GenericSystemPlugin;

public interface ReceptionCharacteristics {
    public static final Distribution noiseFloor = Factory.distributionFactory().getConstantDistribution(-114.0);
    public static final OptionalValue<IntermodulationRejectionMask> intermodulation_rejection = Factory.results().optional(false, Defaults.defaultIntermodulationMask());
    public static final OptionalValue<Double> receivePower = Factory.results().optional(false, 30.0);
    public static final double sensitivity = -98.0;
    public static final double reception_bandwith = 200.0;
    public static final ChangeListener<ReceptionCharacteristics> change = new ChangeListener<ReceptionCharacteristics>(){

        @Override
        public void handle(ReceptionCharacteristics model, List<AbstractItem> items, AbstractItem changedItem) {
            ResourceBundle STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
            FunctionLibraryItem fl = null;
            for (AbstractItem item : items) {
                if (!(item instanceof FunctionLibraryItem)) continue;
                fl = (FunctionLibraryItem)item;
            }
            if (fl == null) {
                return;
            }
            if (model.blockingAttenuationMode() == GenericSystemPlugin.BlockingAttenuationMode.MODE_SENSITIVITY) {
                fl.setUnit("dBm");
                fl.axisNames("MHz", "dBm");
                fl.functionDialogTitle(STRINGLIST.getString("RECEPTION_CHARACTERISTICS_BLOCKING_RESPONSE_DBM_TITLE"));
            } else {
                fl.setUnit("dB");
                fl.axisNames("MHz", "dB");
                fl.functionDialogTitle(STRINGLIST.getString("RECEPTION_CHARACTERISTICS_BLOCKING_RESPONSE_DB_TITLE"));
            }
        }
    };

    @Config(order=1, name="Noise Floor", unit="dBm", information="RECEPTION_CHARACTERISTICS_NOISE_FLOOR_INFORMATION", distributions={"CONSTANT", "USER_DEFINED", "UNIFORM", "GAUSSIAN", "RAYLEIGH", "STAIR", "DISCRETE_UNIFORM"})
    public Distribution noiseFloor();

    @Config(order=2, name="Blocking mode")
    public GenericSystemPlugin.BlockingAttenuationMode blockingAttenuationMode();

    @Config(order=3, name="Blocking mask")
    public BlockingMask blockingMask();

    @Config(order=5, name="Intermodulation rejection mode", information="RECEPTION_CHARACTERISTICS_INTERMODULATION_INFORMATION")
    public GenericSystemPlugin.IntermodulationRejectionMode intermodulationRejectionMode();

    @Config(order=10, name="Intermodulation rejection", xAxis="MHz", yAxis="dB")
    public OptionalValue<IntermodulationRejectionMask> intermodulation_rejection();

    @Config(order=12, name="Receive power dynamic range", unit="dB")
    public OptionalValue<Double> receivePower();

    @Config(order=14, name="Sensitivity", unit="dBm")
    public double sensitivity();

    @Config(order=16, name="Reception Bandwidth", unit="kHz")
    public double reception_bandwith();

    @Config(order=18, name="Overloading", defineGroup="overloading")
    public boolean use_receiver_overloading();

    @Config(order=19, name="Overloading threshold", group="overloading", unit="dBm")
    public Function overloading_mask();

    @Config(order=20, name="Receiver filter", group="overloading", unit="dB")
    public Function receiver_filter();
}

