/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.generic;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import org.seamcat.model.distributions.ConstantDistribution;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.factory.ProxyHelper;
import org.seamcat.model.generic.InterferenceCriteria;
import org.seamcat.model.generic.ReceptionCharacteristics;
import org.seamcat.model.plugin.system.CustomPanelBuilder;
import org.seamcat.model.plugin.system.ModelEditor;
import org.seamcat.model.plugin.system.PanelModelEditor;
import org.seamcat.model.systems.generic.ReceiverModel;
import org.seamcat.model.systems.generic.SystemModelGeneric;
import org.seamcat.presentation.DialogHelper;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.genericgui.item.CalculatedValueItem;
import org.seamcat.presentation.genericgui.panelbuilder.GenericPanelEditor;
import org.seamcat.presentation.systems.generic.InterferenceCriteriaDialog;
import org.seamcat.presentation.systems.generic.WSConsistency;

public class ICBuilder
implements CustomPanelBuilder<InterferenceCriteria, Object> {
    @Override
    public PanelModelEditor<InterferenceCriteria> build(InterferenceCriteria model, final ModelEditor<Object> modelEditor) {
        final GenericPanelEditor<InterferenceCriteria> editor = new GenericPanelEditor<InterferenceCriteria>(MainWindow.getInstance(), InterferenceCriteria.class, model);
        CalculatedValueItem item = editor.getCalculatedValues().get(0);
        item.getEvaluateButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceiverModel receiver;
                Object value = modelEditor.getModel();
                if (value instanceof SystemModelGeneric) {
                    receiver = ((SystemModelGeneric)value).receiver();
                } else if (value instanceof ReceiverModel) {
                    receiver = (ReceiverModel)value;
                } else {
                    return;
                }
                ReceptionCharacteristics characteristics = receiver.receptionCharacteristics();
                Distribution distribution = characteristics.noiseFloor();
                if (distribution instanceof ConstantDistribution) {
                    InterferenceCriteriaDialog dialog = new InterferenceCriteriaDialog(characteristics.noiseFloor(), characteristics.sensitivity(), receiver.interferenceCriteria());
                    if (dialog.display()) {
                        ReceiverModel recProto = ICBuilder.this.buildPrototype(modelEditor);
                        Factory.when(recProto.interferenceCriteria()).thenReturn(dialog.getSelectedCriteria());
                        WSConsistency wsConsistency = dialog.getWSConsistency();
                        if (wsConsistency.wsConsistency()) {
                            ReceptionCharacteristics prototype = Factory.prototype(ReceptionCharacteristics.class, characteristics);
                            ConstantDistribution nf = Factory.distributionFactory().getConstantDistribution(wsConsistency.noiseFloor());
                            Factory.when(prototype.noiseFloor()).thenReturn(nf);
                            Factory.when(prototype.sensitivity()).thenReturn(wsConsistency.sensitivity());
                            Factory.when(recProto.receptionCharacteristics()).thenReturn(Factory.build(prototype));
                        }
                        ICBuilder.this.setModel(recProto, modelEditor);
                    }
                } else {
                    DialogHelper.interferenceCriteriaError();
                }
            }
        });
        return new PanelModelEditor<InterferenceCriteria>(){

            @Override
            public JPanel getPanel() {
                return editor;
            }

            @Override
            public InterferenceCriteria getModel() {
                return (InterferenceCriteria)editor.getModel();
            }
        };
    }

    private void setModel(ReceiverModel recProto, ModelEditor<Object> modelEditor) {
        ReceiverModel receiver = Factory.build(recProto);
        Object model = modelEditor.getModel();
        if (model instanceof ReceiverModel) {
            modelEditor.setModel(receiver);
        } else {
            SystemModelGeneric modelGeneric = ProxyHelper.newComposite(SystemModelGeneric.class);
            SystemModelGeneric prototype = Factory.prototype(SystemModelGeneric.class, (SystemModelGeneric)model);
            Factory.when(prototype.receiver()).thenReturn(receiver);
            modelEditor.setModel(Factory.build(prototype));
        }
    }

    private ReceiverModel buildPrototype(ModelEditor<Object> modelEditor) {
        ReceiverModel proto;
        Object model = modelEditor.getModel();
        if (model instanceof ReceiverModel) {
            proto = Factory.prototype(ReceiverModel.class, (ReceiverModel)model);
        } else if (model instanceof SystemModelGeneric) {
            proto = Factory.prototype(ReceiverModel.class, ((SystemModelGeneric)model).receiver());
        } else {
            throw new RuntimeException("Type not supported: " + model);
        }
        return proto;
    }
}

