/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.generic;

import java.util.List;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.events.CognitiveRadioSettingChangedEvent;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.EmissionMask;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.MaskFunction;
import org.seamcat.model.generic.Defaults;
import org.seamcat.model.plugin.Config;
import org.seamcat.model.plugin.OptionalValue;
import org.seamcat.model.types.PropagationModel;
import org.seamcat.presentation.genericgui.item.AbstractItem;
import org.seamcat.presentation.genericgui.item.BooleanItem;
import org.seamcat.presentation.genericgui.panelbuilder.ChangeListener;

public interface EmissionCharacteristics {
    public static final Distribution power = Factory.distributionFactory().getConstantDistribution(33.0);
    public static final EmissionMask emissionMask = Defaults.defaultEmissionMask();
    public static final OptionalValue<MaskFunction> emissionFloor = Defaults.defaultEmissionFloor();
    public static final double stepSize = 2.0;
    public static final double minThreshold = -103.0;
    public static final double dynamicRange = 6.0;
    public static final Function detectionThreshold = Factory.functionFactory().constantFunction(0.0);
    public static final double receptionBandwidth = 200.0;
    public static final MaskFunction eirpMax = Defaults.defaultEirpMax();
    public static final PropagationModel propagationModel = Factory.propagationModelFactory().getHataSE21();
    public static final ChangeListener<EmissionCharacteristics> change = new ChangeListener<EmissionCharacteristics>(){

        @Override
        public void handle(EmissionCharacteristics model, List<AbstractItem> items, AbstractItem changedItem) {
            if (changedItem instanceof BooleanItem && changedItem.getLabel().equals("Cognitive radio")) {
                EventBusFactory.getEventBus().publish(new CognitiveRadioSettingChangedEvent());
            }
        }
    };

    @Config(order=1, name="Power", unit="dBm", information="EmissionCharacteristics.power", distributions={"CONSTANT", "USER_DEFINED", "UNIFORM", "GAUSSIAN", "RAYLEIGH", "STAIR", "DISCRETE_UNIFORM"})
    public Distribution power();

    @Config(order=3, name="Emissions mask", unit="dBc/Ref.BW")
    public EmissionMask emissionMask();

    @Config(order=5, name="Emissions floor", unit="dBm/Ref.BW", distributions={"CONSTANT", "USER_DEFINED", "UNIFORM", "GAUSSIAN", "RAYLEIGH", "STAIR", "DISCRETE_UNIFORM"})
    public OptionalValue<MaskFunction> emissionFloor();

    @Config(order=6, name="Power Control", defineGroup="pc")
    public boolean powerControl();

    @Config(order=7, name="Power control step size", unit="dB", group="pc")
    public double stepSize();

    @Config(order=8, name="Min threshold", unit="dBm", group="pc")
    public double minThreshold();

    @Config(order=9, name="Dynamic range", unit="dB", group="pc")
    public double dynamicRange();

    @Config(order=10, name="Cognitive radio", defineGroup="cr", information="SensingLinkINFO")
    public boolean cognitiveRadio();

    @Config(order=11, name="Detection threshold", group="cr")
    public Function detectionThreshold();

    @Config(order=12, name="Probability of failure", unit="%", group="cr")
    public double probabilityOfFailure();

    @Config(order=13, name="Sensing reception bandwidth", unit="kHz", group="cr")
    public double receptionBandwidth();

    @Config(order=14, name="e.i.r.p. max in-block limit", group="cr")
    public MaskFunction eirpMax();

    @Config(order=15, name="Sensing link propagation model", group="cr")
    public PropagationModel propagationModel();
}

