/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.generic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.seamcat.model.antenna.HorizontalVerticalAntenna;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.BitRateMapping;
import org.seamcat.model.functions.EmissionMask;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.IntermodulationRejectionMask;
import org.seamcat.model.functions.MaskFunction;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.plugin.OptionalValue;
import org.seamcat.model.plugin.antenna.HorizontalVerticalInput;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.model.types.result.DescriptionImpl;

public class Defaults {
    public static AntennaGain<HorizontalVerticalInput> defaultAntennaGain() {
        HorizontalVerticalInput prototype = Factory.prototype(HorizontalVerticalInput.class);
        List<Point2D> hor = Arrays.asList(new Point2D(0.0, 0.0), new Point2D(360.0, 0.0));
        Factory.when(prototype.horizontal()).thenReturn(Factory.results().optional(false, Factory.functionFactory().discreteFunction(hor)));
        List<Point2D> ver = Arrays.asList(new Point2D(-90.0, 0.0), new Point2D(90.0, 0.0));
        Factory.when(prototype.vertical()).thenReturn(Factory.results().optional(false, Factory.functionFactory().discreteFunction(ver)));
        return Factory.antennaGainFactory().getByClass(HorizontalVerticalAntenna.class, Factory.build(prototype), 0.0, "DEFAULT_ANT", "");
    }

    public static EmissionMask defaultEmissionMask() {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        ArrayList<Double> mask = new ArrayList<Double>();
        points.add(new Point2D(-0.1, 0.0));
        mask.add(200.0);
        points.add(new Point2D(0.1, 0.0));
        mask.add(200.0);
        return Factory.functionFactory().emissionMask(points, mask);
    }

    public static IntermodulationRejectionMask defaultIntermodulationMask() {
        Function mask = Factory.functionFactory().constantFunction(0.0);
        DescriptionImpl description = new DescriptionImpl("Intermodulation Rejection Mask", "");
        return Factory.functionFactory().intermodulationRejectMask(mask, description);
    }

    public static OptionalValue<MaskFunction> defaultEmissionFloor() {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        ArrayList<Double> mask = new ArrayList<Double>();
        points.add(new Point2D(-10.0, -60.0));
        mask.add(20.0);
        points.add(new Point2D(10.0, -60.0));
        mask.add(20.0);
        return Factory.results().optional(false, Factory.functionFactory().maskFunction(points, mask));
    }

    public static MaskFunction defaultEirpMax() {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        ArrayList<Double> mask = new ArrayList<Double>();
        points.add(new Point2D(-100.0, 0.0));
        mask.add(1250.0);
        points.add(new Point2D(-1.0, 0.0));
        mask.add(1250.0);
        points.add(new Point2D(1.0, 0.0));
        mask.add(1250.0);
        points.add(new Point2D(100.0, 0.0));
        mask.add(1250.0);
        return Factory.functionFactory().maskFunction(points, mask);
    }

    public static BitRateMapping defaultOFDMABitRateMapping() {
        double[][] points = new double[][]{{-12.0, 0.0}, {-11.0, 0.0}, {-10.0, 0.06}, {-9.0, 0.07}, {-8.0, 0.08}, {-7.0, 0.1}, {-6.0, 0.13}, {-5.0, 0.16}, {-4.0, 0.19}, {-3.0, 0.23}, {-2.0, 0.28}, {-1.0, 0.34}, {0.0, 0.4}, {1.0, 0.47}, {2.0, 0.55}, {3.0, 0.63}, {4.0, 0.72}, {5.0, 0.82}, {6.0, 0.93}, {7.0, 1.04}, {8.0, 1.15}, {9.0, 1.26}, {10.0, 1.38}, {11.0, 1.51}, {12.0, 1.63}, {13.0, 1.76}, {14.0, 1.88}, {15.0, 2.0}, {16.0, 2.0}, {17.0, 2.0}, {18.0, 2.0}, {19.0, 2.0}, {20.0, 2.0}, {21.0, 2.0}, {22.0, 2.0}, {23.0, 2.0}, {24.0, 2.0}, {25.0, 2.0}};
        return Factory.functionFactory().bitRateMapping(Defaults.fromValues(points), new DescriptionImpl("Default OFDMA Bitrate Mapping", ""));
    }

    private static Function fromValues(double[][] values) {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (double[] point : values) {
            points.add(new Point2D(point[0], point[1]));
        }
        return Factory.functionFactory().discreteFunction(points);
    }

    public static Distribution defaultMobility() {
        double[][] points = new double[][]{{0.0, 0.25}, {3.0, 0.5}, {30.0, 0.75}, {100.0, 1.0}};
        return Factory.distributionFactory().getUserDefinedStair(Defaults.fromValues(points));
    }

    public static BitRateMapping defaultIMT2020ULBitRateMapping() {
        double[][] points = new double[][]{{-12.0, 0.0}, {-11.0, 0.0}, {-10.0, 0.06}, {-9.0, 0.07}, {-8.0, 0.08}, {-7.0, 0.1}, {-6.0, 0.13}, {-5.0, 0.16}, {-4.0, 0.19}, {-3.0, 0.23}, {-2.0, 0.28}, {-1.0, 0.34}, {0.0, 0.4}, {1.0, 0.47}, {2.0, 0.55}, {3.0, 0.63}, {4.0, 0.72}, {5.0, 0.82}, {6.0, 0.93}, {7.0, 1.04}, {8.0, 1.15}, {9.0, 1.26}, {10.0, 1.38}, {11.0, 1.51}, {12.0, 1.63}, {13.0, 1.76}, {14.0, 1.88}, {15.0, 2.01}, {16.0, 2.14}, {17.0, 2.27}, {18.0, 2.4}, {19.0, 2.53}, {20.0, 2.66}, {21.0, 2.79}, {22.0, 2.93}, {23.0, 3.0}, {24.0, 3.0}, {25.0, 3.0}, {26.0, 3.0}, {27.0, 3.0}, {28.0, 3.0}, {29.0, 3.0}, {30.0, 3.0}};
        return Factory.functionFactory().bitRateMapping(Defaults.fromValues(points), new DescriptionImpl("Default IMT-2020 Up Link Bitrate Mapping", ""));
    }

    public static BitRateMapping defaultIMT2020DLBitRateMapping() {
        double[][] points = new double[][]{{-12.0, 0.0}, {-11.0, 0.0}, {-10.0, 0.08}, {-9.0, 0.1}, {-8.0, 0.13}, {-7.0, 0.16}, {-6.0, 0.19}, {-5.0, 0.24}, {-4.0, 0.29}, {-3.0, 0.35}, {-2.0, 0.42}, {-1.0, 0.51}, {0.0, 0.6}, {1.0, 0.71}, {2.0, 0.82}, {3.0, 0.95}, {4.0, 1.09}, {5.0, 1.23}, {6.0, 1.39}, {7.0, 1.55}, {8.0, 1.72}, {9.0, 1.9}, {10.0, 2.08}, {11.0, 2.26}, {12.0, 2.44}, {13.0, 2.63}, {14.0, 2.82}, {15.0, 3.02}, {16.0, 3.21}, {17.0, 3.41}, {18.0, 3.6}, {19.0, 3.8}, {20.0, 3.99}, {21.0, 4.19}, {22.0, 4.39}, {23.0, 4.59}, {24.0, 4.79}, {25.0, 4.99}, {26.0, 5.18}, {27.0, 5.38}, {28.0, 5.58}, {29.0, 5.78}, {30.0, 5.98}, {31.0, 6.0}, {32.0, 6.0}, {33.0, 6.0}, {34.0, 6.0}, {35.0, 6.0}, {36.0, 6.0}, {37.0, 6.0}, {38.0, 6.0}, {39.0, 6.0}, {40.0, 6.0}};
        return Factory.functionFactory().bitRateMapping(Defaults.fromValues(points), new DescriptionImpl("Default IMT-2020 Down Link Bitrate Mapping", ""));
    }
}

