/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.functions;

import org.seamcat.model.functions.Bounds;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;

public class VectorSpace {
    public static final VectorSpace ZERO = new VectorSpace(Bounds.ZERO, Bounds.ZERO);
    private Bounds xBounds;
    private Bounds yBounds;
    private Bounds circleBounds = Bounds.ZERO;

    public VectorSpace(Bounds xBounds, Bounds yBounds) {
        this.xBounds = xBounds;
        this.yBounds = yBounds;
    }

    public Bounds getxBounds() {
        return this.xBounds;
    }

    public Bounds getyBounds() {
        return this.yBounds;
    }

    public VectorSpace add(VectorSpace range) {
        Bounds x = new Bounds(this.xBounds.getMin() + range.getxBounds().getMin(), this.xBounds.getMax() + range.getxBounds().getMax(), true);
        Bounds y = new Bounds(this.yBounds.getMin() + range.getyBounds().getMin(), this.yBounds.getMax() + range.getyBounds().getMax(), true);
        VectorSpace newRange = new VectorSpace(x, y);
        newRange.circleBounds = this.circleBounds.add(range.circleBounds);
        return newRange;
    }

    public VectorSpace negate() {
        Bounds x = new Bounds(-this.xBounds.getMax(), -this.xBounds.getMin(), true);
        Bounds y = new Bounds(-this.yBounds.getMax(), -this.yBounds.getMin(), true);
        VectorSpace range = new VectorSpace(x, y);
        range.circleBounds = this.circleBounds;
        return range;
    }

    public VectorSpace addCircle(Bounds bounds) {
        VectorSpace range = new VectorSpace(this.xBounds, this.yBounds);
        range.circleBounds = this.circleBounds.add(bounds);
        return range;
    }

    public Bounds getCoverage() {
        double x = this.getMinRangeCoordinate(this.xBounds);
        double y = this.getMinRangeCoordinate(this.yBounds);
        double min = Mathematics.distance(new Point2D(x, y));
        x = this.getMaxRangeCoordinate(this.xBounds);
        y = this.getMaxRangeCoordinate(this.yBounds);
        double max = Mathematics.distance(new Point2D(x, y));
        return new Bounds(min += this.circleBounds.getMin(), max += this.circleBounds.getMax(), true);
    }

    private double getMinRangeCoordinate(Bounds bounds) {
        if (bounds.contains(0.0)) {
            return 0.0;
        }
        if (bounds.getMax() < 0.0) {
            return bounds.getMax();
        }
        return bounds.getMin();
    }

    private double getMaxRangeCoordinate(Bounds bounds) {
        if (bounds.contains(0.0)) {
            return Math.max(Math.abs(bounds.getMin()), bounds.getMax());
        }
        if (bounds.getMax() < 0.0) {
            return bounds.getMin();
        }
        return bounds.getMax();
    }

    public String toString() {
        return "X:[" + this.xBounds.getMin() + "; " + this.xBounds.getMax() + "] Y:[" + this.yBounds.getMin() + "; " + this.yBounds.getMax() + "]";
    }

    public Point2D getPoint() {
        return new Point2D(this.xBounds.getMin(), this.yBounds.getMin());
    }
}

