/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.factory;

import java.util.Random;
import org.seamcat.model.factory.SeamcatRandom;

public class RandomAccessor {
    private static boolean seedFixed = false;
    private static long fixedSeed;
    private static final ThreadLocal<SeamcatRandom> threadLocalRandom;

    public static SeamcatRandom getRandom() {
        if (threadLocalRandom.get() == null) {
            if (seedFixed) {
                RandomAccessor.fixSeed(fixedSeed);
            } else {
                threadLocalRandom.set(new SeamcatRandom(new Random()));
            }
        }
        return threadLocalRandom.get();
    }

    public static void fixSeed(long seed) {
        fixedSeed = seed;
        seedFixed = true;
        Random random = new Random(seed);
        long steps = Math.abs(seed % 37L);
        int i = 0;
        while ((long)i < steps) {
            random.nextDouble();
            ++i;
        }
        threadLocalRandom.set(new SeamcatRandom(random));
    }

    static {
        threadLocalRandom = new ThreadLocal();
    }
}

