/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.factory;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import org.seamcat.model.factory.BuildersImpl;
import org.seamcat.model.factory.DefaultValueCache;
import org.seamcat.model.factory.ProxyHelper;

class PrototypeInvocationHandler<T>
implements InvocationHandler {
    private final Map<Method, Object> values;
    private final Class<T> clazz;
    private static boolean DEFAULT_BOOLEAN;
    private static byte DEFAULT_BYTE;
    private static short DEFAULT_SHORT;
    private static int DEFAULT_INT;
    private static long DEFAULT_LONG;
    private static float DEFAULT_FLOAT;
    private static double DEFAULT_DOUBLE;

    PrototypeInvocationHandler(Class<T> clazz, T t) {
        this.clazz = clazz;
        if (t == null) {
            if (!DefaultValueCache.hasDefaultValues(clazz)) {
                ProxyHelper.defaultValues(clazz);
            }
            this.values = DefaultValueCache.defaultValues(clazz);
        } else {
            this.values = ProxyHelper.getHandler(t).getValues();
        }
    }

    @Override
    public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
        if (method.getReturnType().isAssignableFrom(PrototypeInvocationHandler.class)) {
            return this;
        }
        BuildersImpl.method.set(method);
        BuildersImpl.values.set(this.values);
        Class<?> returnType = method.getReturnType();
        if (returnType.isPrimitive()) {
            if (returnType.equals(Boolean.TYPE)) {
                return DEFAULT_BOOLEAN;
            }
            if (returnType.equals(Byte.TYPE)) {
                return DEFAULT_BYTE;
            }
            if (returnType.equals(Short.TYPE)) {
                return DEFAULT_SHORT;
            }
            if (returnType.equals(Integer.TYPE)) {
                return DEFAULT_INT;
            }
            if (returnType.equals(Long.TYPE)) {
                return DEFAULT_LONG;
            }
            if (returnType.equals(Float.TYPE)) {
                return Float.valueOf(DEFAULT_FLOAT);
            }
            if (returnType.equals(Double.TYPE)) {
                return DEFAULT_DOUBLE;
            }
        }
        return null;
    }

    protected T build() {
        return ProxyHelper.newInstance(this.clazz, this.values);
    }
}

