/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.factory;

import java.util.ArrayList;
import java.util.List;
import org.seamcat.function.BitRateMappingImpl;
import org.seamcat.function.BlockingMaskImpl;
import org.seamcat.function.DiscreteFunction;
import org.seamcat.function.EmissionMaskImpl;
import org.seamcat.function.IntermodulationRejectionMaskImpl;
import org.seamcat.function.MaskFunctionImpl;
import org.seamcat.model.functions.BitRateMapping;
import org.seamcat.model.functions.BlockingMask;
import org.seamcat.model.functions.EmissionMask;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.FunctionFactory;
import org.seamcat.model.functions.IntermodulationRejectionMask;
import org.seamcat.model.functions.LibraryFunctionItem;
import org.seamcat.model.functions.MaskFunction;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.result.DescriptionImpl;

public class FunctionFactoryImpl
implements FunctionFactory {
    @Override
    public Function constantFunction(double value) {
        return new DiscreteFunction(value);
    }

    @Override
    public Function discreteFunction(List<Point2D> points) {
        return new DiscreteFunction(points);
    }

    @Override
    public EmissionMask emissionMask(List<Point2D> points, List<Double> mask) {
        return new EmissionMaskImpl(points, mask);
    }

    @Override
    public EmissionMask emissionMask(List<Point2D> points, List<Double> mask, Description description) {
        EmissionMaskImpl em = new EmissionMaskImpl(points, mask);
        em.setDescription(description);
        return em;
    }

    @Override
    public BlockingMask blockingMask(List<Point2D> points) {
        return new BlockingMaskImpl(points, (Description)new DescriptionImpl("Blocking Mask", ""));
    }

    @Override
    public BlockingMask blockingMask(List<Point2D> points, Description description) {
        return new BlockingMaskImpl(points, description);
    }

    @Override
    public BlockingMask blockingMask(double constant) {
        return new BlockingMaskImpl(constant, (Description)new DescriptionImpl("Blocking Mask", ""));
    }

    @Override
    public BlockingMask blockingMask(double constant, Description description) {
        return new BlockingMaskImpl(constant, description);
    }

    @Override
    public BlockingMask blockingMask(Function function, Description description) {
        BlockingMaskImpl mask = function.isConstant() ? new BlockingMaskImpl(function.getConstant(), description) : new BlockingMaskImpl(function.getPoints(), description);
        return mask;
    }

    @Override
    public MaskFunction maskFunction(List<Point2D> points, List<Double> mask) {
        return new MaskFunctionImpl(points, mask);
    }

    @Override
    public MaskFunction maskFunction(MaskFunction maskFunction) {
        return this.copy((MaskFunctionImpl)maskFunction);
    }

    @Override
    public EmissionMask emissionMask(MaskFunction maskFunction) {
        return this.create((MaskFunctionImpl)maskFunction);
    }

    @Override
    public EmissionMask emissionMask(MaskFunction maskFunction, Description description) {
        EmissionMaskImpl mask = this.create((MaskFunctionImpl)maskFunction);
        mask.setDescription(description);
        return mask;
    }

    @Override
    public IntermodulationRejectionMask intermodulationRejectMask(Function function, Description description) {
        IntermodulationRejectionMaskImpl mask = function.isConstant() ? new IntermodulationRejectionMaskImpl(function.getConstant(), description) : new IntermodulationRejectionMaskImpl(function.getPoints(), description);
        return mask;
    }

    public MaskFunctionImpl copy(MaskFunctionImpl other) {
        ArrayList<Double> mask = new ArrayList<Double>();
        for (Point2D point : other.points()) {
            mask.add(other.getMask(point));
        }
        ArrayList<Point2D> copy = new ArrayList<Point2D>(other.points());
        return new MaskFunctionImpl(copy, mask);
    }

    public EmissionMaskImpl create(MaskFunctionImpl other) {
        ArrayList<Double> mask = new ArrayList<Double>();
        for (Point2D point : other.points()) {
            mask.add(other.getMask(point));
        }
        ArrayList<Point2D> copy = new ArrayList<Point2D>(other.points());
        return new EmissionMaskImpl(copy, mask);
    }

    @Override
    public BitRateMapping bitRateMapping(Function function, Description description) {
        return new BitRateMappingImpl(function, description);
    }

    @Override
    public <T extends LibraryFunctionItem> T fromClass(Class<T> clazz, Function function, Description description) {
        if (BitRateMapping.class == clazz) {
            return (T)this.bitRateMapping(function, description);
        }
        if (BlockingMask.class == clazz) {
            return (T)this.blockingMask(function, description);
        }
        if (IntermodulationRejectionMask.class == clazz) {
            return (T)this.intermodulationRejectMask(function, description);
        }
        return null;
    }
}

