/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.factory;

import org.seamcat.model.distributions.DistributionFactory;
import org.seamcat.model.functions.DataExporter;
import org.seamcat.model.functions.FunctionFactory;
import org.seamcat.model.plugin.PluginFactory;
import org.seamcat.model.plugin.antenna.AntennaGainFactory;
import org.seamcat.model.plugin.builder.Returner;
import org.seamcat.model.plugin.coverageradius.CoverageRadiusFactory;
import org.seamcat.model.plugin.eventprocessing.EventProcessingFactory;
import org.seamcat.model.plugin.propagation.PropagationModelFactory;
import org.seamcat.model.plugin.system.CorrelationModeFactory;
import org.seamcat.model.simulation.result.ResultFactory;

public class Factory {
    private static DistributionFactory distributionFactory;
    private static PropagationModelFactory propagationModelFactory;
    private static Builders builders;
    private static AntennaGainFactory antennaGainFactory;
    private static FunctionFactory functionFactory;
    private static CoverageRadiusFactory coverageRadiusFactory;
    private static EventProcessingFactory eventProcessingFactory;
    private static CorrelationModeFactory correlationModeFactory;
    private static PluginFactory pluginFactory;
    private static ResultFactory resultFactory;
    private static DataExporter exporter;

    static void initialize(DistributionFactory distributionFactory, PropagationModelFactory propagationModelFactory, Builders builders, AntennaGainFactory antennaGainFactory, FunctionFactory functionFactory, CoverageRadiusFactory coverageRadiusFactory, EventProcessingFactory eventProcessingFactory, CorrelationModeFactory correlationModeFactory, PluginFactory pluginFactory, ResultFactory resultFactory, DataExporter exporter) {
        Factory.distributionFactory = distributionFactory;
        Factory.propagationModelFactory = propagationModelFactory;
        Factory.builders = builders;
        Factory.antennaGainFactory = antennaGainFactory;
        Factory.functionFactory = functionFactory;
        Factory.coverageRadiusFactory = coverageRadiusFactory;
        Factory.eventProcessingFactory = eventProcessingFactory;
        Factory.correlationModeFactory = correlationModeFactory;
        Factory.pluginFactory = pluginFactory;
        Factory.resultFactory = resultFactory;
        Factory.exporter = exporter;
    }

    public static DistributionFactory distributionFactory() {
        return distributionFactory;
    }

    public static PropagationModelFactory propagationModelFactory() {
        return propagationModelFactory;
    }

    public static <T> T prototype(Class<T> clazz) {
        return builders.prototype(clazz);
    }

    public static <T> T prototype(Class<T> clazz, T t) {
        return builders.prototype(clazz, t);
    }

    public static <V> Returner<V> when(V value) {
        return builders.when(value);
    }

    public static <T> T build(T prototype) {
        return builders.build(prototype);
    }

    public static <T> T instance(Class<T> clazz) {
        return builders.defaultInstance(clazz);
    }

    public static <T> T fromInstance(Class<T> clazz, T t) {
        return Factory.build(Factory.prototype(clazz, t));
    }

    public static AntennaGainFactory antennaGainFactory() {
        return antennaGainFactory;
    }

    public static CoverageRadiusFactory coverageRadii() {
        return coverageRadiusFactory;
    }

    public static EventProcessingFactory eventProcessors() {
        return eventProcessingFactory;
    }

    public static PluginFactory plugins() {
        return pluginFactory;
    }

    public static FunctionFactory functionFactory() {
        return functionFactory;
    }

    public static CorrelationModeFactory correlationModes() {
        return correlationModeFactory;
    }

    public static ResultFactory results() {
        return resultFactory;
    }

    public static DataExporter exporter() {
        return exporter;
    }

    static interface Builders {
        public <T> T prototype(Class<T> var1);

        public <T> T prototype(Class<T> var1, T var2);

        public <V> Returner<V> when(V var1);

        public <T> T build(T var1);

        public <T> T defaultInstance(Class<T> var1);
    }
}

